/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IStubElementType<StubT extends StubElement, PsiT extends PsiElement>
extends IElementType
implements StubSerializer<StubT> {
    private static volatile boolean ourInitializedStubs;
    private static final Logger LOG;

    public IStubElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            IStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName, language);
        if (ourInitializedStubs) {
            LOG.error("All stub element types should be created before index initialization is complete.\nPlease add the class containing stub element type constants to \"stubElementTypeHolder\" extension.\nRegistered extensions: " + Arrays.toString(StubElementTypeHolderEP.EP_NAME.getExtensions()));
        }
    }

    static void loadRegisteredStubElementTypes() {
        for (StubElementTypeHolderEP holderEP : (StubElementTypeHolderEP[])Extensions.getExtensions(StubElementTypeHolderEP.EP_NAME)) {
            holderEP.initialize();
        }
        ourInitializedStubs = true;
    }

    public abstract PsiT createPsi(@NotNull StubT var1);

    @NotNull
    public abstract StubT createStub(@NotNull PsiT var1, StubElement var2);

    public boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    public String getId(@NotNull StubT stub) {
        if (stub == null) {
            IStubElementType.$$$reportNull$$$0(1);
        }
        assert (stub.getStubType() == this);
        StubElement parent = stub.getParentStub();
        int count = 0;
        for (StubElement child : parent.getChildrenStubs()) {
            if (child.getStubType() == this) {
                ++count;
            }
            if (child != stub) continue;
            return '#' + String.valueOf(count);
        }
        throw new RuntimeException("Parent/child relations corrupted");
    }

    static {
        LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.IStubElementType");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/stubs/IStubElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

