/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.hash.LinkedHashMap;
import org.jetbrains.annotations.Nullable;

public class RenameInputValidatorRegistry {
    private RenameInputValidatorRegistry() {
    }

    @Nullable
    public static Condition<String> getInputValidator(PsiElement element) {
        LinkedHashMap acceptedValidators = new LinkedHashMap();
        for (RenameInputValidator validator : (RenameInputValidator[])Extensions.getExtensions(RenameInputValidator.EP_NAME)) {
            ProcessingContext context = new ProcessingContext();
            if (!validator.getPattern().accepts(element, context)) continue;
            acceptedValidators.put((Object)validator, (Object)context);
        }
        return acceptedValidators.isEmpty() ? null : s -> {
            for (RenameInputValidator validator : acceptedValidators.keySet()) {
                if (validator.isInputValid((String)s, element, (ProcessingContext)acceptedValidators.get((Object)validator))) continue;
                return false;
            }
            return true;
        };
    }

    @Nullable
    public static Function<String, String> getInputErrorValidator(PsiElement element) {
        LinkedHashMap acceptedValidators = new LinkedHashMap();
        for (RenameInputValidator validator : (RenameInputValidator[])Extensions.getExtensions(RenameInputValidator.EP_NAME)) {
            ProcessingContext context = new ProcessingContext();
            if (!(validator instanceof RenameInputValidatorEx) || !validator.getPattern().accepts(element, context)) continue;
            acceptedValidators.put((Object)((RenameInputValidatorEx)validator), (Object)context);
        }
        return acceptedValidators.isEmpty() ? null : newName -> {
            for (RenameInputValidatorEx validator : acceptedValidators.keySet()) {
                String message = validator.getErrorMessage((String)newName, element.getProject());
                if (message == null) continue;
                return message;
            }
            return null;
        };
    }
}

