/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.panels;

import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;

public final class VerticalLayout
implements LayoutManager2 {
    public static final String TOP = "TOP";
    public static final String BOTTOM = "BOTTOM";
    public static final String CENTER = "CENTER";
    private final ArrayList<Component> myTop = new ArrayList();
    private final ArrayList<Component> myBottom = new ArrayList();
    private final ArrayList<Component> myCenter = new ArrayList();
    private final int myAlignment;
    private final int myGap;

    public VerticalLayout(int gap) {
        this.myGap = gap;
        this.myAlignment = -1;
    }

    public VerticalLayout(int gap, int alignment) {
        this.myGap = gap;
        switch (alignment) {
            case 0: 
            case 2: 
            case 4: {
                this.myAlignment = alignment;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported alignment: " + alignment);
            }
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints != null && !(constraints instanceof String)) {
            throw new IllegalArgumentException("unsupported constraints: " + constraints);
        }
        this.addLayoutComponent((String)constraints, component);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (name == null || TOP.equalsIgnoreCase(name)) {
                this.myTop.add(component);
            } else if (CENTER.equalsIgnoreCase(name)) {
                this.myCenter.add(component);
            } else if (BOTTOM.equalsIgnoreCase(name)) {
                this.myBottom.add(component);
            } else {
                throw new IllegalArgumentException("unsupported name: " + name);
            }
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.myTop.remove(component);
        this.myBottom.remove(component);
        this.myCenter.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getPreferredSize(container, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getPreferredSize(container, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension top = this.getPreferredSize(this.myTop);
            Dimension bottom = this.getPreferredSize(this.myBottom);
            Dimension center = this.getPreferredSize(this.myCenter);
            Insets insets = container.getInsets();
            int width = container.getWidth() - insets.left - insets.right;
            int height = container.getHeight() - insets.top - insets.bottom;
            int topY = 0;
            if (top != null) {
                topY = this.myGap + this.layout(this.myTop, 0, width, insets);
            }
            int bottomY = height;
            if (bottom != null) {
                bottomY -= bottom.height;
            }
            if (bottomY < topY) {
                bottomY = topY;
            }
            if (center != null) {
                int centerBottomY;
                int centerY = (height - center.height) / 2;
                if (centerY > topY && (centerBottomY = centerY + center.height + this.myGap + this.myGap) > bottomY) {
                    centerY = bottomY - center.height - this.myGap - this.myGap;
                }
                if (centerY < topY) {
                    centerY = topY;
                }
                if (bottomY < (centerY = this.myGap + this.layout(this.myCenter, centerY, width, insets))) {
                    bottomY = centerY;
                }
            }
            if (bottom != null) {
                this.layout(this.myBottom, bottomY, width, insets);
            }
        }
    }

    private int layout(ArrayList<Component> list, int y, int width, Insets insets) {
        for (Component component : list) {
            if (!component.isVisible()) continue;
            Dimension size = component.getPreferredSize();
            int x = 0;
            if (this.myAlignment == -1) {
                size.width = width;
            } else if (this.myAlignment != 2) {
                x = width - size.width;
                if (this.myAlignment == 0) {
                    x /= 2;
                }
            }
            component.setBounds(x + insets.left, y + insets.top, size.width, size.height);
            y += size.height + this.myGap;
        }
        return y;
    }

    private static Dimension join(Dimension result, int gap, Dimension size) {
        if (size == null) {
            return result;
        }
        if (result == null) {
            return new Dimension(size);
        }
        result.height += gap + size.height;
        if (result.width < size.width) {
            result.width = size.width;
        }
        return result;
    }

    private Dimension getPreferredSize(ArrayList<Component> list) {
        Dimension result = null;
        for (Component component : list) {
            if (!component.isVisible()) continue;
            result = VerticalLayout.join(result, this.myGap, component.getPreferredSize());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getPreferredSize(Container container, boolean aligned) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension top = this.getPreferredSize(this.myTop);
            Dimension bottom = this.getPreferredSize(this.myBottom);
            Dimension center = this.getPreferredSize(this.myCenter);
            Dimension result = VerticalLayout.join(VerticalLayout.join(VerticalLayout.join(null, this.myGap + this.myGap, top), this.myGap + this.myGap, center), this.myGap + this.myGap, bottom);
            if (result == null) {
                result = new Dimension();
            } else if (aligned && center != null) {
                int topHeight = top == null ? 0 : top.height;
                int bottomHeight = bottom == null ? 0 : bottom.height;
                result.width += Math.abs(topHeight - bottomHeight);
            }
            JBInsets.addTo((Dimension)result, (Insets)container.getInsets());
            return result;
        }
    }
}

