/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.treetable;

import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.ClientPropertyHolder;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class TreeTableCellRenderer
implements TableCellRenderer,
ClientPropertyHolder {
    private final TreeTable myTreeTable;
    private final TreeTableTree myTree;
    private TreeCellRenderer myTreeCellRenderer;
    private TableCellRendererComponent myCellRendererComponent = new TableCellRendererComponent();
    private Border myDefaultBorder = UIUtil.getTableFocusCellHighlightBorder();

    public TreeTableCellRenderer(TreeTable treeTable, TreeTableTree tree) {
        this.myTreeTable = treeTable;
        this.myTree = tree;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int modelRow = table.convertRowIndexToModel(row);
        boolean lineHasFocus = table.hasFocus();
        if (this.myTreeCellRenderer != null) {
            this.myTree.setCellRenderer(this.myTreeCellRenderer);
        }
        if (isSelected) {
            this.myTree.setBackground(lineHasFocus ? table.getSelectionBackground() : UIUtil.getTreeUnfocusedSelectionBackground());
            this.myTree.setForeground(table.getSelectionForeground());
        } else {
            this.myTree.setBackground(table.getBackground());
            this.myTree.setForeground(table.getForeground());
        }
        this.myCellRendererComponent.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.myTree.setVisibleRow(modelRow);
        Object treeObject = this.myTree.getPathForRow(modelRow).getLastPathComponent();
        boolean leaf = this.myTree.getModel().isLeaf(treeObject);
        boolean expanded = this.myTree.isExpanded(modelRow);
        Component component = this.myTree.getCellRenderer().getTreeCellRendererComponent(this.myTree, treeObject, isSelected, expanded, leaf, modelRow, lineHasFocus);
        if (component instanceof JComponent) {
            table.setToolTipText(((JComponent)component).getToolTipText());
        }
        this.myCellRendererComponent.setComponent(component, expanded, leaf);
        return this.myCellRendererComponent;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.myTreeCellRenderer = treeCellRenderer;
    }

    public void setDefaultBorder(Border border) {
        this.myDefaultBorder = border;
    }

    public void putClientProperty(String key, Object value) {
        this.myTree.putClientProperty(key, value);
    }

    public void putClientProperty(String s, String s1) {
        this.putClientProperty(s, (Object)s1);
    }

    public void setRootVisible(boolean b) {
        this.myTree.setRootVisible(b);
    }

    public void setShowsRootHandles(boolean b) {
        this.myTree.setShowsRootHandles(b);
    }

    private class TableCellRendererComponent
    extends OpaquePanel {
        private Component myComponent;
        private boolean myExpanded;
        private boolean myLeaf;

        public TableCellRendererComponent() {
            super(new BorderLayout());
        }

        public void setComponent(Component component, boolean expanded, boolean leaf) {
            this.myComponent = component;
            this.myExpanded = expanded;
            this.myLeaf = leaf;
            this.accessibleContext = null;
            if (this.getComponentCount() == 0) {
                this.add((Component)TreeTableCellRenderer.this.myTree, "Center");
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = this.myComponent instanceof Accessible && this.myComponent.getAccessibleContext() != null ? new AccessibleTableCellRendererComponent(this.myComponent.getAccessibleContext()) : super.getAccessibleContext();
            }
            return this.accessibleContext;
        }

        protected class AccessibleTableCellRendererComponent
        extends AccessibleContextDelegate {
            public AccessibleTableCellRendererComponent(AccessibleContext context) {
                super(context);
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet set = super.getAccessibleStateSet();
                if (!TableCellRendererComponent.this.myLeaf) {
                    set.add(AccessibleState.EXPANDABLE);
                    set.add(TableCellRendererComponent.this.myExpanded ? AccessibleState.EXPANDED : AccessibleState.COLLAPSED);
                }
                return set;
            }
        }
    }
}

