/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class StripeTableCellRenderer
implements TableCellRenderer {
    private final TableCellRenderer myRenderer;
    private static final double FACTOR = 0.92;

    public StripeTableCellRenderer(TableCellRenderer renderer) {
        this.myRenderer = renderer;
    }

    public StripeTableCellRenderer() {
        this(null);
    }

    public static Color darken(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.92), 0), Math.max((int)((double)color.getGreen() * 0.92), 0), Math.max((int)((double)color.getBlue() * 0.92), 0));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent component = (JComponent)this.getRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (row % 2 != 0 && !isSelected) {
            component.setBackground(StripeTableCellRenderer.darken(table.getBackground()));
        } else {
            component.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        }
        component.setOpaque(true);
        return component;
    }

    protected TableCellRenderer getRenderer(int row, int column) {
        return this.myRenderer;
    }
}

