/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.util.containers.IntArrayList;

public class LineWrapper {
    public static IntArrayList calcBreakOffsets(char[] text, int startOffset, int endOffset, boolean lineStart, double x, double clipX, WidthProvider widthProvider) {
        IntArrayList breakOffsets = new IntArrayList();
        int nextOffset = startOffset;
        while (true) {
            int prevOffset = nextOffset;
            if ((nextOffset = LineWrapper.calcWordBreakOffset(text, nextOffset, endOffset, x, clipX, widthProvider)) == prevOffset && lineStart && (nextOffset = LineWrapper.calcCharBreakOffset(text, nextOffset, endOffset, x, clipX, widthProvider)) == prevOffset) {
                ++nextOffset;
            }
            if (nextOffset >= endOffset) break;
            breakOffsets.add(nextOffset);
            lineStart = true;
            x = 0.0;
        }
        return breakOffsets;
    }

    private static int calcCharBreakOffset(char[] text, int offset, int endOffset, double x, double clipX, WidthProvider widthProvider) {
        double newX = x;
        int breakOffset = offset;
        while (breakOffset < endOffset) {
            int nextOffset = breakOffset + 1;
            if ((newX += widthProvider.getWidth(text, breakOffset, nextOffset - breakOffset, newX)) > clipX) {
                return breakOffset;
            }
            breakOffset = nextOffset;
        }
        return breakOffset;
    }

    private static int calcWordBreakOffset(char[] text, int offset, int endOffset, double x, double clipX, WidthProvider widthProvider) {
        double newX = x;
        int breakOffset = offset;
        while (breakOffset < endOffset) {
            int nextOffset = LineWrapper.getNextWordBreak(text, breakOffset, endOffset);
            if ((newX += widthProvider.getWidth(text, breakOffset, nextOffset - breakOffset, newX)) > clipX) {
                return breakOffset;
            }
            breakOffset = nextOffset;
        }
        return breakOffset;
    }

    private static int getNextWordBreak(char[] text, int offset, int endOffset) {
        boolean isId = Character.isJavaIdentifierPart(text[offset]);
        for (int i = offset + 1; i < endOffset; ++i) {
            if (isId == Character.isJavaIdentifierPart(text[i])) continue;
            return i;
        }
        return endOffset;
    }

    static interface WidthProvider {
        public double getWidth(char[] var1, int var2, int var3, double var4);
    }
}

