/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.hint.ShowParameterInfoContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.Language;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.LanguageParameterInfo;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import gnu.trove.THashSet;
import java.awt.Point;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowParameterInfoHandler
implements CodeInsightActionHandler {
    private final boolean myRequestFocus;

    public ShowParameterInfoHandler() {
        this(false);
    }

    public ShowParameterInfoHandler(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(2);
        }
        ShowParameterInfoHandler.invoke(project, editor, file2, -1, null, this.myRequestFocus);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static PsiElement findAnyElementAt(@NotNull PsiFile file2, int offset) {
        PsiElement element;
        if (file2 == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(3);
        }
        if ((element = file2.findElementAt(offset)) == null && offset > 0) {
            element = file2.findElementAt(offset - 1);
        }
        return element;
    }

    public static void invoke(Project project, Editor editor, PsiFile file2, int lbraceOffset, PsiElement highlightedElement) {
        ShowParameterInfoHandler.invoke(project, editor, file2, lbraceOffset, highlightedElement, false);
    }

    public static void invoke(Project project, Editor editor, PsiFile file2, int lbraceOffset, PsiElement highlightedElement, boolean requestFocus) {
        ShowParameterInfoHandler.invoke(project, editor, file2, lbraceOffset, highlightedElement, requestFocus, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invoke(Project project, Editor editor, PsiFile file2, int lbraceOffset, PsiElement highlightedElement, boolean requestFocus, boolean singleParameterHint) {
        LookupEx lookup;
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = ShowParameterInfoHandler.findAnyElementAt(file2, offset);
        if (psiElement == null) {
            return;
        }
        ShowParameterInfoContext context = new ShowParameterInfoContext(editor, project, file2, offset, lbraceOffset, requestFocus, singleParameterHint);
        context.setHighlightedElement(highlightedElement);
        context.setRequestFocus(requestFocus);
        Language language = psiElement.getLanguage();
        ParameterInfoHandler[] handlers = ShowParameterInfoHandler.getHandlers(project, language, file2.getViewProvider().getBaseLanguage());
        if (handlers == null) {
            handlers = new ParameterInfoHandler[]{};
        }
        if ((lookup = LookupManager.getInstance(project).getActiveLookup()) != null) {
            LookupElement item = lookup.getCurrentItem();
            if (item != null) {
                for (ParameterInfoHandler handler2 : handlers) {
                    if (!handler2.couldShowInLookup()) continue;
                    Object[] items = handler2.getParametersForLookup(item, (ParameterInfoContext)context);
                    if (items != null && items.length > 0) {
                        ShowParameterInfoHandler.showLookupEditorHint(items, editor, project, handler2, requestFocus);
                    }
                    return;
                }
            }
            return;
        }
        DumbService.getInstance((Project)project).setAlternativeResolveEnabled(true);
        try {
            for (ParameterInfoHandler handler3 : handlers) {
                Object element = handler3.findElementForParameterInfo((CreateParameterInfoContext)context);
                if (element == null) continue;
                handler3.showParameterInfo(element, (CreateParameterInfoContext)context);
            }
        }
        finally {
            DumbService.getInstance((Project)project).setAlternativeResolveEnabled(false);
        }
    }

    private static void showLookupEditorHint(Object[] descriptors, Editor editor, Project project, ParameterInfoHandler handler2, boolean requestFocus) {
        ParameterInfoComponent component = new ParameterInfoComponent(descriptors, editor, handler2, requestFocus, false);
        component.update(false);
        LightweightHint hint = new LightweightHint(component);
        hint.setSelectingHint(true);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        Pair<Point, Short> pos = ParameterInfoController.chooseBestHintPosition(project, editor, null, hint, true, (short)6, true);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!editor.getComponent().isShowing()) {
                return;
            }
            hintManager.showEditorHint(hint, editor, (Point)pos.getFirst(), 134, 0, false, (Short)pos.getSecond());
        });
    }

    @Nullable
    public static ParameterInfoHandler[] getHandlers(Project project, Language ... languages) {
        THashSet handlers = new THashSet();
        for (Language language : languages) {
            handlers.addAll(DumbService.getInstance((Project)project).filterByDumbAwareness((Collection)LanguageParameterInfo.INSTANCE.allForLanguage(language)));
        }
        if (handlers.isEmpty()) {
            return null;
        }
        return handlers.toArray(new ParameterInfoHandler[handlers.size()]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/ShowParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findAnyElementAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

