/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.SchemeNameToFileName;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.project.ProjectKt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.MessageBus;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u00012\u00020\u0002:\u0003,-.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016Jr\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u0014\"\b\b\u0001\u0010\u0015*\u0002H\u00132\u0006\u0010\u0016\u001a\u00020\u000f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00150\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#J\u0014\u0010$\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u000fH&J&\u0010)\u001a\u00020%2\u001e\u0010\u0017\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020%0*J\u0006\u0010+\u001a\u00020%R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R`\u0010\b\u001aT\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b \f*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n \f*(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b \f*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n0\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003/01\u00a8\u00062"}, d2={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "Lcom/intellij/openapi/options/SchemeManagerFactory;", "Lcom/intellij/openapi/components/SettingsSavingComponent;", "()V", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "managers", "", "Lcom/intellij/configurationStore/SchemeManagerImpl;", "Lcom/intellij/openapi/options/Scheme;", "kotlin.jvm.PlatformType", "", "checkPath", "", "originalPath", "create", "Lcom/intellij/openapi/options/SchemeManager;", "T", "", "MutableT", "directoryName", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "presentableName", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "schemeNameToFileName", "Lcom/intellij/configurationStore/SchemeNameToFileName;", "streamProvider", "Lcom/intellij/configurationStore/StreamProvider;", "directoryPath", "Ljava/nio/file/Path;", "autoSave", "", "dispose", "", "schemeManager", "pathToFile", "path", "process", "Lkotlin/Function1;", "save", "ApplicationSchemeManagerFactory", "ProjectSchemeManagerFactory", "TestSchemeManagerFactory", "Lcom/intellij/configurationStore/SchemeManagerFactoryBase$ApplicationSchemeManagerFactory;", "Lcom/intellij/configurationStore/SchemeManagerFactoryBase$ProjectSchemeManagerFactory;", "Lcom/intellij/configurationStore/SchemeManagerFactoryBase$TestSchemeManagerFactory;", "configuration-store-impl"})
public abstract class SchemeManagerFactoryBase
extends SchemeManagerFactory
implements SettingsSavingComponent {
    private final List<SchemeManagerImpl<Scheme, Scheme>> managers = ContainerUtil.createLockFreeCopyOnWriteList();
    @Nullable
    private final ComponentManager componentManager;

    @Nullable
    protected ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @NotNull
    public final <T, MutableT extends T> SchemeManager<T> create(@NotNull String directoryName, @NotNull SchemeProcessor<T, ? super MutableT> processor2, @Nullable String presentableName, @NotNull RoamingType roamingType, @NotNull SchemeNameToFileName schemeNameToFileName, @Nullable StreamProvider streamProvider, @Nullable Path directoryPath2, boolean autoSave) {
        Path path;
        Intrinsics.checkParameterIsNotNull((Object)directoryName, (String)"directoryName");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull((Object)schemeNameToFileName, (String)"schemeNameToFileName");
        String path2 = this.checkPath(directoryName);
        StreamProvider streamProvider2 = streamProvider;
        if (streamProvider2 == null) {
            StateStorageManager stateStorageManager;
            Object object = this.getComponentManager();
            if (!((object != null && (object = ServiceKt.getStateStore((ComponentManager)object)) != null ? object.getStateStorageManager() : (stateStorageManager = null)) instanceof StateStorageManagerImpl)) {
                stateStorageManager = null;
            }
            StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
            streamProvider2 = stateStorageManagerImpl != null ? stateStorageManagerImpl.getCompoundStreamProvider() : null;
        }
        if ((path = directoryPath2) == null) {
            path = this.pathToFile(path2);
        }
        ComponentManager componentManager = this.getComponentManager();
        SchemeManagerImpl<T, ? super MutableT> manager = new SchemeManagerImpl<T, MutableT>(path2, processor2, streamProvider2, path, roamingType, presentableName, schemeNameToFileName, (MessageBus)(componentManager != null ? componentManager.getMessageBus() : null));
        if (autoSave) {
            this.managers.add(manager);
        }
        return manager;
    }

    @Override
    public void dispose(@NotNull SchemeManager<?> schemeManager2) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull(schemeManager2, (String)"schemeManager");
        Collection collection2 = collection = (Collection)this.managers;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection2).remove(schemeManager2);
    }

    @NotNull
    public String checkPath(@NotNull String originalPath) {
        Intrinsics.checkParameterIsNotNull((Object)originalPath, (String)"originalPath");
        checkPath.1 error$ = checkPath.1.INSTANCE;
        if (StringsKt.contains$default((CharSequence)originalPath, (char)'\\', (boolean)false, (int)2, null)) {
            error$.invoke("Path must be system-independent, use forward slash instead of backslash");
        } else {
            CharSequence charSequence = originalPath;
            if (charSequence.length() == 0) {
                error$.invoke("Path must not be empty");
            }
        }
        return originalPath;
    }

    @NotNull
    public abstract Path pathToFile(@NotNull String var1);

    public final void process(@NotNull Function1<? super SchemeManagerImpl<Scheme, ? super Scheme>, Unit> processor2) {
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        for (SchemeManagerImpl<Scheme, Scheme> manager : this.managers) {
            try {
                SchemeManagerImpl<Scheme, Scheme> schemeManagerImpl = manager;
                Intrinsics.checkExpressionValueIsNotNull(schemeManagerImpl, (String)"manager");
                processor2.invoke(schemeManagerImpl);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().error("Cannot reload settings for " + manager.getClass().getName(), e);
            }
        }
    }

    public final void save() {
        SmartList errors = new SmartList();
        for (SchemeManagerImpl<Scheme, Scheme> registeredManager : this.managers) {
            try {
                registeredManager.save((List)errors);
            }
            catch (Throwable e) {
                errors.add((Object)e);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty((List)((List)errors));
    }

    private SchemeManagerFactoryBase() {
    }

    public /* synthetic */ SchemeManagerFactoryBase(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase$ApplicationSchemeManagerFactory;", "Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "()V", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "checkPath", "", "originalPath", "pathToFile", "Ljava/nio/file/Path;", "path", "configuration-store-impl"})
    private static final class ApplicationSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        @Override
        @NotNull
        protected ComponentManager getComponentManager() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            return (ComponentManager)application;
        }

        @Override
        @NotNull
        public String checkPath(@NotNull String originalPath) {
            Intrinsics.checkParameterIsNotNull((Object)originalPath, (String)"originalPath");
            String path = super.checkPath(originalPath);
            if (StringsKt.startsWith$default((String)path, (String)"$ROOT_CONFIG$", (boolean)false, (int)2, null)) {
                String string = path;
                int n = 14;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                path = string3;
                String message = "Path must not contains ROOT_CONFIG macro, corrected: " + path;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                ComponentStoreImplKt.getLOG().warn(message);
            }
            return path;
        }

        @Override
        @NotNull
        public Path pathToFile(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Path path2 = Paths.get(ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).getStateStorageManager().expandMacros("$ROOT_CONFIG$"), path);
            if (path2 == null) {
                Intrinsics.throwNpe();
            }
            return path2;
        }

        public ApplicationSchemeManagerFactory() {
            super(null);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase$ProjectSchemeManagerFactory;", "Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "componentManager", "getComponentManager", "()Lcom/intellij/openapi/project/Project;", "pathToFile", "Ljava/nio/file/Path;", "path", "", "configuration-store-impl"})
    private static final class ProjectSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        @NotNull
        private final Project componentManager;
        private final Project project;

        @NotNull
        protected Project getComponentManager() {
            return this.componentManager;
        }

        @Override
        @NotNull
        public Path pathToFile(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Path path2 = Paths.get(this.project.getBasePath(), ProjectKt.isDirectoryBased(this.project) ? ".idea/" + path : '.' + path);
            if (path2 == null) {
                Intrinsics.throwNpe();
            }
            return path2;
        }

        public ProjectSchemeManagerFactory(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            super(null);
            this.componentManager = this.project = project;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/configurationStore/SchemeManagerFactoryBase$TestSchemeManagerFactory;", "Lcom/intellij/configurationStore/SchemeManagerFactoryBase;", "basePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "pathToFile", "path", "", "configuration-store-impl"})
    public static final class TestSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        private final Path basePath;

        @Override
        @NotNull
        public Path pathToFile(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Path path2 = this.basePath.resolve(path);
            if (path2 == null) {
                Intrinsics.throwNpe();
            }
            return path2;
        }

        public TestSchemeManagerFactory(@NotNull Path basePath) {
            Intrinsics.checkParameterIsNotNull((Object)basePath, (String)"basePath");
            super(null);
            this.basePath = basePath;
        }
    }
}

