/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeContentChangedHandler;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.execution.impl.RunConfigurationSchemeManagerKt;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.util.JdomKt;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ<\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J(\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000f2\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0002J&\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/execution/impl/RunConfigurationSchemeManager;", "Lcom/intellij/configurationStore/LazySchemeProcessor;", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;", "Lcom/intellij/configurationStore/SchemeContentChangedHandler;", "manager", "Lcom/intellij/execution/impl/RunManagerImpl;", "isShared", "", "(Lcom/intellij/execution/impl/RunManagerImpl;Z)V", "createScheme", "dataHolder", "Lcom/intellij/configurationStore/SchemeDataHolder;", "name", "", "attributeProvider", "Ljava/util/function/Function;", "isBundled", "getSchemeKey", "scheme", "fileNameWithoutExtension", "isExternalizable", "onSchemeAdded", "", "onSchemeDeleted", "readData", "Lorg/jdom/Element;", "settings", "schemeContentChanged", "writeScheme", "lang-impl"})
public final class RunConfigurationSchemeManager
extends LazySchemeProcessor<RunnerAndConfigurationSettingsImpl, RunnerAndConfigurationSettingsImpl>
implements SchemeContentChangedHandler<RunnerAndConfigurationSettingsImpl> {
    private final RunManagerImpl manager;
    private final boolean isShared;

    @Override
    @NotNull
    public String getSchemeKey(@NotNull RunnerAndConfigurationSettingsImpl scheme2) {
        Intrinsics.checkParameterIsNotNull((Object)scheme2, (String)"scheme");
        return this.isShared ? scheme2.getName() : "" + scheme2.getType().getId() + '-' + scheme2.getName();
    }

    @Override
    @NotNull
    public RunnerAndConfigurationSettingsImpl createScheme(@NotNull SchemeDataHolder<? super RunnerAndConfigurationSettingsImpl> dataHolder, @NotNull String name, @NotNull Function<String, String> attributeProvider2, boolean isBundled) {
        Intrinsics.checkParameterIsNotNull(dataHolder, (String)"dataHolder");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(attributeProvider2, (String)"attributeProvider");
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(this.manager, null, false, false, null, 30, null);
        Element element = this.readData(settings, dataHolder);
        this.manager.addConfiguration$lang_impl(element, settings);
        return settings;
    }

    private final Element readData(RunnerAndConfigurationSettingsImpl settings, SchemeDataHolder<? super RunnerAndConfigurationSettingsImpl> dataHolder) {
        Element element = dataHolder.read();
        if (this.isShared && Intrinsics.areEqual((Object)element.getName(), (Object)"component")) {
            Element element2 = element.getChild("configuration");
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element.getChild(\"configuration\")");
            element = element2;
        }
        try {
            settings.readExternal(element, this.isShared);
        }
        catch (InvalidDataException e) {
            RunManagerImpl.Companion.getLOG$lang_impl().error((Throwable)e);
        }
        Element elementAfterStateLoaded = element;
        try {
            elementAfterStateLoaded = this.writeScheme(settings);
        }
        catch (Throwable e) {
            RunConfigurationSchemeManagerKt.access$getLOG$p().error("Cannot compute digest for RC using state after load", e);
        }
        dataHolder.updateDigest(elementAfterStateLoaded);
        return element;
    }

    @Override
    @Nullable
    public String getSchemeKey(@NotNull Function<String, String> attributeProvider2, @NotNull String fileNameWithoutExtension) {
        Intrinsics.checkParameterIsNotNull(attributeProvider2, (String)"attributeProvider");
        Intrinsics.checkParameterIsNotNull((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
        String name = attributeProvider2.apply("name");
        if (Intrinsics.areEqual((Object)name, (Object)"<template>") || name == null) {
            String string = attributeProvider2.apply("type");
            if (string != null) {
                String string2;
                String it = string2 = string;
                if (name == null) {
                    name = "<template>";
                }
                name = Intrinsics.stringPlus((String)name, (Object)(" of type " + it));
            }
        } else if (name != null && !this.isShared) {
            String typeId = attributeProvider2.apply("type");
            RunConfigurationSchemeManagerKt.access$getLOG$p().assertTrue(typeId != null);
            return "" + typeId + '-' + name;
        }
        return name;
    }

    @Override
    public boolean isExternalizable(@NotNull RunnerAndConfigurationSettingsImpl scheme2) {
        Intrinsics.checkParameterIsNotNull((Object)scheme2, (String)"scheme");
        return true;
    }

    @Override
    public void schemeContentChanged(@NotNull RunnerAndConfigurationSettingsImpl scheme2, @NotNull String name, @NotNull SchemeDataHolder<? super RunnerAndConfigurationSettingsImpl> dataHolder) {
        Intrinsics.checkParameterIsNotNull((Object)scheme2, (String)"scheme");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(dataHolder, (String)"dataHolder");
        this.readData(scheme2, dataHolder);
        this.manager.getEventPublisher$lang_impl().runConfigurationChanged(scheme2);
    }

    @Override
    public void onSchemeAdded(@NotNull RunnerAndConfigurationSettingsImpl scheme2) {
        Intrinsics.checkParameterIsNotNull((Object)scheme2, (String)"scheme");
    }

    @Override
    public void onSchemeDeleted(@NotNull RunnerAndConfigurationSettingsImpl scheme2) {
        Intrinsics.checkParameterIsNotNull((Object)scheme2, (String)"scheme");
        this.manager.removeConfiguration(scheme2);
    }

    @Override
    @NotNull
    public Element writeScheme(@NotNull RunnerAndConfigurationSettingsImpl scheme2) {
        Intrinsics.checkParameterIsNotNull((Object)scheme2, (String)"scheme");
        Element result2 = super.writeScheme(scheme2);
        if (this.isShared) {
            Element element = JdomKt.attribute((Element)new Element("component"), (String)"name", (String)"ProjectRunConfigurationManager").addContent(result2);
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"Element(\"component\")\n   \u2026      .addContent(result)");
            return element;
        }
        return result2;
    }

    public RunConfigurationSchemeManager(@NotNull RunManagerImpl manager, boolean isShared) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)manager), (String)"manager");
        super(null, 1, null);
        this.manager = manager;
        this.isShared = isShared;
    }
}

