/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositePrintable
implements Printable,
Disposable {
    public static final String NEW_LINE = "\n";
    protected final List<Printable> myNestedPrintables = new ArrayList<Printable>();
    private final PrintablesWrapper myWrapper = new PrintablesWrapper();
    protected int myExceptionMark;
    private int myCurrentSize = 0;
    private String myOutputFile = null;
    private String myFrameworkOutputFile;
    private static final ExecutorService ourTestExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"tests", (int)1);
    private static final Logger LOG = Logger.getInstance(PrintablesWrapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            this.myWrapper.flush(this.myNestedPrintables);
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOutputFile() {
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            ArrayList<Printable> printables = new ArrayList<Printable>(this.myNestedPrintables);
            CompositePrintable.invokeInAlarm(() -> this.printOutputFile(printables));
        }
    }

    public static void invokeInAlarm(Runnable runnable2) {
        CompositePrintable.invokeInAlarm(runnable2, !ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
    }

    public static void invokeInAlarm(Runnable runnable2, boolean sync) {
        if (sync) {
            runnable2.run();
        } else {
            ourTestExecutorService.execute(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printOn(Printer printer) {
        ArrayList<Printable> printables;
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            printables = new ArrayList<Printable>(this.myNestedPrintables);
        }
        this.myWrapper.printOn(printer, printables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printOwnPrintablesOn(Printer printer) {
        ArrayList<Printable> printables = new ArrayList<Printable>();
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            for (Printable printable : this.myNestedPrintables) {
                if (printable instanceof AbstractTestProxy) continue;
                printables.add(printable);
            }
        }
        this.myWrapper.printOn(printer, printables, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(@NotNull Printable printable) {
        if (printable == null) {
            CompositePrintable.$$$reportNull$$$0(0);
        }
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            this.myNestedPrintables.add(printable);
            if (this.myNestedPrintables.size() > 500) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(@NotNull Printable printable, int i) {
        if (printable == null) {
            CompositePrintable.$$$reportNull$$$0(1);
        }
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            if (i >= this.myNestedPrintables.size()) {
                this.myNestedPrintables.add(printable);
            } else {
                this.myNestedPrintables.add(i, printable);
            }
            if (this.myNestedPrintables.size() > 500) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            this.myCurrentSize += this.myNestedPrintables.size();
            this.myNestedPrintables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            return this.myCurrentSize + this.myNestedPrintables.size();
        }
    }

    public void dispose() {
        this.clear();
        this.myWrapper.dispose();
    }

    public int getExceptionMark() {
        return this.myExceptionMark;
    }

    public void setExceptionMark(int exceptionMark) {
        this.myExceptionMark = exceptionMark;
    }

    public void setOutputFilePath(String outputFile) {
        this.myOutputFile = outputFile;
    }

    public void setFrameworkOutputFile(String frameworkOutputFile) {
        this.myFrameworkOutputFile = frameworkOutputFile;
    }

    public void printFromFrameworkOutputFile(Printer console) {
        if (this.myFrameworkOutputFile != null) {
            Runnable runnable2 = () -> {
                File inputFile = new File(this.myFrameworkOutputFile);
                if (inputFile.exists()) {
                    try {
                        String fileText = FileUtil.loadFile((File)inputFile);
                        console.print(fileText, ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            };
            CompositePrintable.invokeInAlarm(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printOutputFile(List<Printable> currentPrintables) {
        if (this.myOutputFile != null && new File(this.myOutputFile).exists()) {
            try (final PrintStream printStream = new PrintStream(new FileOutputStream(new File(this.myOutputFile), true));){
                for (Printable currentPrintable : currentPrintables) {
                    currentPrintable.printOn(new Printer(){

                        @Override
                        public void print(String text, ConsoleViewContentType contentType) {
                            if (contentType != ConsoleViewContentType.SYSTEM_OUTPUT) {
                                printStream.print(text);
                            }
                        }

                        @Override
                        public void printHyperlink(String text, HyperlinkInfo info) {
                            printStream.print(text);
                        }

                        @Override
                        public void onNewAvailable(@NotNull Printable printable) {
                            if (printable == null) {
                                1.$$$reportNull$$$0(0);
                            }
                        }

                        @Override
                        public void mark() {
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printable", "com/intellij/execution/testframework/CompositePrintable$1", "onNewAvailable"));
                        }
                    });
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "printable";
        objectArray2[1] = "com/intellij/execution/testframework/CompositePrintable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addLast";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "insert";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class PrintablesWrapper {
        private static final String HYPERLINK = "hyperlink";
        private File myFile;
        private final MyFlushToFilePrinter myPrinter = new MyFlushToFilePrinter();
        private final Object myFileLock = new Object();

        private PrintablesWrapper() {
        }

        @Nullable
        private synchronized File getFile() {
            if (this.myFile == null) {
                try {
                    File tempFile = FileUtil.createTempFile((String)"idea_test_", (String)".out");
                    if (tempFile.exists()) {
                        this.myFile = tempFile;
                        return this.myFile;
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
            return this.myFile;
        }

        public synchronized void dispose() {
            if (this.myFile != null) {
                FileUtil.delete((File)this.myFile);
            }
        }

        public synchronized boolean hasOutput() {
            return this.myFile != null;
        }

        public void flush(List<Printable> printables) {
            if (printables.isEmpty()) {
                return;
            }
            ArrayList<Printable> currentPrintables = new ArrayList<Printable>(printables);
            Runnable request = () -> {
                Object object = this.myFileLock;
                synchronized (object) {
                    for (Printable printable : currentPrintables) {
                        printable.printOn(this.myPrinter);
                    }
                    this.myPrinter.close();
                }
                CompositePrintable.this.printOutputFile(currentPrintables);
            };
            CompositePrintable.invokeInAlarm(request, ApplicationManager.getApplication().isUnitTestMode());
        }

        public void printOn(Printer console, List<Printable> printables) {
            this.printOn(console, printables, false);
        }

        public void printOn(Printer console, List<Printable> printables, boolean skipFileContent) {
            Runnable request = () -> {
                if (skipFileContent) {
                    this.readFileContentAndPrint(console, null, printables);
                    return;
                }
                File file2 = this.hasOutput() ? this.getFile() : null;
                Object object = this.myFileLock;
                synchronized (object) {
                    this.readFileContentAndPrint(console, file2, printables);
                }
            };
            CompositePrintable.invokeInAlarm(request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFileContentAndPrint(Printer printer, @Nullable File file2, List<Printable> nestedPrintables) {
            if (file2 != null) {
                try {
                    int lineNum = 0;
                    Map contentTypeByNameMap = ContainerUtil.newMapFromValues(ConsoleViewContentType.getRegisteredTypes().iterator(), contentType -> contentType.toString());
                    try (DataInputStream reader = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));){
                        while (reader.available() > 0 && !this.wasPrintableChanged(printer)) {
                            String firstToken;
                            if (lineNum == CompositePrintable.this.getExceptionMark() && lineNum > 0) {
                                printer.mark();
                            }
                            if ((firstToken = IOUtil.readString((DataInput)reader)) == null) {
                                break;
                            }
                            if (firstToken.equals(HYPERLINK)) {
                                new DiffHyperlink(IOUtil.readString((DataInput)reader), IOUtil.readString((DataInput)reader), IOUtil.readString((DataInput)reader), false).printOn(printer);
                            } else {
                                ConsoleViewContentType contentType2 = contentTypeByNameMap.getOrDefault(firstToken, ConsoleViewContentType.NORMAL_OUTPUT);
                                String text = IOUtil.readString((DataInput)reader);
                                this.printText(printer, text, contentType2);
                            }
                            ++lineNum;
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    LOG.info((Throwable)e);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            for (int i = 0; i < nestedPrintables.size(); ++i) {
                if (i == CompositePrintable.this.getExceptionMark() && i > 0) {
                    printer.mark();
                }
                nestedPrintables.get(i).printOn(printer);
            }
        }

        private void printText(Printer printer, String text, ConsoleViewContentType contentType) {
            if (ConsoleViewContentType.NORMAL_OUTPUT.equals(contentType)) {
                printer.printWithAnsiColoring(text, contentType);
            } else {
                printer.print(text, contentType);
            }
        }

        private boolean wasPrintableChanged(Printer printer) {
            return printer instanceof TestsOutputConsolePrinter && !((TestsOutputConsolePrinter)printer).isCurrent(CompositePrintable.this);
        }

        private class MyFlushToFilePrinter
        implements Printer {
            private DataOutputStream myFileWriter;

            private MyFlushToFilePrinter() {
            }

            private DataOutputStream getFileWriter() {
                if (this.myFileWriter == null) {
                    try {
                        File file2 = PrintablesWrapper.this.getFile();
                        LOG.assertTrue(file2 != null);
                        this.myFileWriter = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2, true)));
                    }
                    catch (FileNotFoundException e) {
                        LOG.info((Throwable)e);
                        return null;
                    }
                }
                return this.myFileWriter;
            }

            private void close() {
                if (this.myFileWriter != null) {
                    try {
                        this.myFileWriter.close();
                    }
                    catch (FileNotFoundException e) {
                        LOG.info((Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                    this.myFileWriter = null;
                }
            }

            @Override
            public void print(String text, ConsoleViewContentType contentType) {
                try {
                    DataOutputStream writer = this.getFileWriter();
                    if (writer != null) {
                        IOUtil.writeString((String)contentType.toString(), (DataOutput)writer);
                        IOUtil.writeString((String)text, (DataOutput)writer);
                    }
                }
                catch (FileNotFoundException e) {
                    LOG.info((Throwable)e);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }

            @Override
            public void printHyperlink(String text, HyperlinkInfo info) {
                if (info instanceof DiffHyperlink.DiffHyperlinkInfo) {
                    DiffHyperlink diffHyperlink = ((DiffHyperlink.DiffHyperlinkInfo)info).getPrintable();
                    try {
                        DataOutputStream fileWriter = this.getFileWriter();
                        if (fileWriter != null) {
                            IOUtil.writeString((String)PrintablesWrapper.HYPERLINK, (DataOutput)fileWriter);
                            IOUtil.writeString((String)diffHyperlink.getLeft(), (DataOutput)fileWriter);
                            IOUtil.writeString((String)diffHyperlink.getRight(), (DataOutput)fileWriter);
                            IOUtil.writeString((String)diffHyperlink.getFilePath(), (DataOutput)fileWriter);
                        }
                    }
                    catch (FileNotFoundException e) {
                        LOG.info((Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                } else {
                    this.print(text, ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }

            @Override
            public void onNewAvailable(@NotNull Printable printable) {
                if (printable == null) {
                    MyFlushToFilePrinter.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void mark() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printable", "com/intellij/execution/testframework/CompositePrintable$PrintablesWrapper$MyFlushToFilePrinter", "onNewAvailable"));
            }
        }
    }
}

