/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.StringTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestsLocationProviderUtil {
    private static final int MIN_PROXIMITY_THRESHOLD = 1;

    private TestsLocationProviderUtil() {
    }

    public static String extractPath(@NotNull String locationUrl) {
        int index;
        if (locationUrl == null) {
            TestsLocationProviderUtil.$$$reportNull$$$0(0);
        }
        return (index = locationUrl.indexOf("://")) >= 0 ? locationUrl.substring(index + "://".length()) : null;
    }

    public static List<VirtualFile> findSuitableFilesFor(String filePath, Project project) {
        boolean inProjectContent;
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile file2 = TestsLocationProviderUtil.getByFullPath(filePath);
        boolean bl = inProjectContent = file2 != null && index.isInContent(file2);
        if (inProjectContent) {
            return Collections.singletonList(file2);
        }
        LinkedList<String> folders = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(filePath, "/", false);
        String fileName = null;
        while (st.hasMoreTokens()) {
            String pathComponent = st.nextToken();
            if (st.hasMoreTokens()) {
                folders.addFirst(pathComponent);
                continue;
            }
            fileName = pathComponent;
        }
        if (fileName == null) {
            return Collections.emptyList();
        }
        List<VirtualFile> target2 = TestsLocationProviderUtil.findFilesClosestToTarget(folders, TestsLocationProviderUtil.collectCandidates(project, fileName, true), 1);
        return target2.isEmpty() && file2 != null ? Collections.singletonList(file2) : target2;
    }

    public static List<VirtualFile> findFilesClosestToTarget(@NotNull List<String> targetParentFolders, List<FileInfo> candidates, int minProximityThreshold) {
        if (targetParentFolders == null) {
            TestsLocationProviderUtil.$$$reportNull$$$0(1);
        }
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        for (String string : targetParentFolders) {
            for (FileInfo info : candidates) {
                info.processRelativePathComponent(string);
            }
        }
        int maxProximity = 0;
        for (FileInfo fileInfo : candidates) {
            int proximity = fileInfo.getProximity();
            if (proximity <= maxProximity) continue;
            maxProximity = proximity;
        }
        if (maxProximity >= minProximityThreshold) {
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
            for (FileInfo info : candidates) {
                if (info.getProximity() != maxProximity) continue;
                arrayList.add(info.getFile());
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static List<FileInfo> collectCandidates(Project project, String fileName, boolean includeNonProjectItems) {
        ChooseByNameContributor[] contributors;
        ArrayList<FileInfo> filesInfo = new ArrayList<FileInfo>();
        for (ChooseByNameContributor contributor : contributors = (ChooseByNameContributor[])Extensions.getExtensions((ExtensionPointName)ChooseByNameContributor.FILE_EP_NAME)) {
            NavigationItem[] navigationItems;
            for (NavigationItem navigationItem : navigationItems = contributor.getItemsByName(fileName, fileName, project, includeNonProjectItems)) {
                if (!(navigationItem instanceof PsiFile)) continue;
                VirtualFile itemFile = ((PsiFile)navigationItem).getVirtualFile();
                assert (itemFile != null);
                filesInfo.add(new FileInfo(itemFile));
            }
        }
        return filesInfo;
    }

    @Nullable
    private static VirtualFile getByFullPath(String filePath) {
        VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (fileByPath != null) {
            return fileByPath;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TempFileSystem.getInstance().findFileByPath(filePath);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationUrl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetParentFolders";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/sm/TestsLocationProviderUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extractPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findFilesClosestToTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FileInfo {
        private final VirtualFile myFile;
        private VirtualFile myCurrentFolder;
        private int myProximity = 0;

        public FileInfo(VirtualFile file2) {
            this.myFile = file2;
            this.myCurrentFolder = this.myFile.getParent();
        }

        public void processRelativePathComponent(String folderName) {
            if (this.myCurrentFolder == null) {
                return;
            }
            if (!folderName.equals(this.myCurrentFolder.getName())) {
                this.myCurrentFolder = null;
                return;
            }
            ++this.myProximity;
            this.myCurrentFolder = this.myCurrentFolder.getParent();
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public int getProximity() {
            return this.myProximity;
        }
    }
}

