/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class OutputLineSplitter {
    private static final String TEAMCITY_SERVICE_MESSAGE_PREFIX = "##teamcity[";
    public static final int TC_MESSAGE_LENGTH = "##teamcity[".length();
    private final boolean myStdinSupportEnabled;
    private final Map<Key, StringBuilder> myBuffers = new THashMap();
    private final List<OutputChunk> myStdOutChunks = new ArrayList<OutputChunk>();

    public OutputLineSplitter(boolean stdinEnabled) {
        this.myBuffers.put(ProcessOutputTypes.SYSTEM, new StringBuilder());
        this.myBuffers.put(ProcessOutputTypes.STDERR, new StringBuilder());
        this.myStdinSupportEnabled = stdinEnabled;
    }

    public void process(String text, Key outputType) {
        int from = 0;
        int inMessageBlockPosition = 0;
        boolean justProcessed = true;
        for (int to = 0; to < text.length(); ++to) {
            char currentChar = text.charAt(to);
            if (currentChar == '\n') {
                this.processLine(text.substring(from, to + 1), outputType);
                from = to + 1;
                justProcessed = true;
                continue;
            }
            if (!justProcessed && currentChar == TEAMCITY_SERVICE_MESSAGE_PREFIX.charAt(inMessageBlockPosition)) {
                if (++inMessageBlockPosition != TC_MESSAGE_LENGTH) continue;
                int tcMessageStart = to + 1 - TC_MESSAGE_LENGTH;
                this.processLine(text.substring(from, tcMessageStart), outputType);
                this.flush();
                from = tcMessageStart;
                inMessageBlockPosition = 0;
                continue;
            }
            inMessageBlockPosition = currentChar == TEAMCITY_SERVICE_MESSAGE_PREFIX.charAt(0) ? 1 : 0;
            justProcessed = false;
        }
        if (from < text.length()) {
            this.processLine(text.substring(from), outputType);
        }
    }

    private void processLine(String text, Key outputType) {
        if (!this.myBuffers.keySet().contains(outputType)) {
            this.processStdOutConsistently(text, outputType);
        } else {
            StringBuilder buffer = this.myBuffers.get(outputType);
            if (!text.endsWith("\n")) {
                buffer.append(text);
                return;
            }
            if (buffer.length() > 0) {
                buffer.append(text);
                text = buffer.toString();
                buffer.setLength(0);
            }
            this.onLineAvailable(text, outputType, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStdOutConsistently(String text, Key outputType) {
        int textLength = text.length();
        if (textLength == 0) {
            return;
        }
        List<OutputChunk> list2 = this.myStdOutChunks;
        synchronized (list2) {
            this.myStdOutChunks.add(new OutputChunk(outputType, text));
        }
        char lastChar = text.charAt(textLength - 1);
        if (lastChar == '\n' || lastChar == '\r') {
            this.flushStdOutBuffer();
        } else if (this.myStdinSupportEnabled && !this.isInTeamcityMessage()) {
            this.flushStdOutBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushStdOutBuffer() {
        ArrayList<OutputChunk> chunks = new ArrayList<OutputChunk>();
        OutputChunk lastChunk = null;
        List<OutputChunk> list2 = this.myStdOutChunks;
        synchronized (list2) {
            for (OutputChunk chunk : this.myStdOutChunks) {
                if (lastChunk != null && chunk.getKey() == lastChunk.getKey()) {
                    lastChunk.append(chunk.getText());
                    continue;
                }
                lastChunk = chunk;
                chunks.add(chunk);
            }
            this.myStdOutChunks.clear();
        }
        boolean isTCLikeFakeOutput = chunks.size() == 1;
        for (OutputChunk chunk : chunks) {
            this.onLineAvailable(chunk.getText(), chunk.getKey(), isTCLikeFakeOutput);
        }
    }

    public void flush() {
        this.flushStdOutBuffer();
        for (Map.Entry<Key, StringBuilder> each : this.myBuffers.entrySet()) {
            StringBuilder buffer = each.getValue();
            if (buffer.length() <= 0) continue;
            this.onLineAvailable(buffer.toString(), each.getKey(), false);
            buffer.setLength(0);
        }
    }

    protected boolean isInTeamcityMessage() {
        return this.myStdOutChunks.stream().anyMatch(chunk -> chunk.getText().startsWith(TEAMCITY_SERVICE_MESSAGE_PREFIX));
    }

    protected abstract void onLineAvailable(@NotNull String var1, @NotNull Key var2, boolean var3);

    private static class OutputChunk {
        private final Key myKey;
        private String myText;
        private StringBuilder myBuilder;

        private OutputChunk(Key key, String text) {
            this.myKey = key;
            this.myText = text;
        }

        public Key getKey() {
            return this.myKey;
        }

        public String getText() {
            if (this.myBuilder != null) {
                this.myText = this.myBuilder.toString();
                this.myBuilder = null;
            }
            return this.myText;
        }

        public void append(String text) {
            if (this.myBuilder == null) {
                this.myBuilder = new StringBuilder(this.myText);
                this.myText = null;
            }
            this.myBuilder.append(text);
        }
    }
}

