/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.history.ImportTestOutputExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportedToGeneralTestEventsConverter
extends OutputToGeneralTestEventsConverter {
    @NotNull
    private final TestConsoleProperties myConsoleProperties;
    @NotNull
    private final File myFile;
    @NotNull
    private final ProcessHandler myHandler;

    public ImportedToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull File file2, @NotNull ProcessHandler handler2) {
        if (testFrameworkName == null) {
            ImportedToGeneralTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            ImportedToGeneralTestEventsConverter.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ImportedToGeneralTestEventsConverter.$$$reportNull$$$0(2);
        }
        if (handler2 == null) {
            ImportedToGeneralTestEventsConverter.$$$reportNull$$$0(3);
        }
        super(testFrameworkName, consoleProperties);
        this.myConsoleProperties = consoleProperties;
        this.myFile = file2;
        this.myHandler = handler2;
    }

    @Override
    public void onStartTesting() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.parseTestResults();
            this.myHandler.detachProcess();
        });
    }

    private void parseTestResults() {
        try {
            ImportedToGeneralTestEventsConverter.parseTestResults(() -> {
                try {
                    return new InputStreamReader((InputStream)new FileInputStream(this.myFile), CharsetToolkit.UTF8_CHARSET);
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }, this.getProcessor());
        }
        catch (IOException e) {
            String message = e.getMessage();
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myConsoleProperties.getProject(), (String)message, (String)("Failed to Parse " + this.myFile.getName())));
        }
    }

    public static void parseTestResults(Supplier<Reader> readerSupplier, GeneralTestEventsProcessor processor2) throws IOException {
        ImportedToGeneralTestEventsConverter.parseTestResults(readerSupplier.get(), ImportTestOutputExtension.findHandler(readerSupplier, processor2));
    }

    public static void parseTestResults(Reader reader, DefaultHandler contentHandler) throws IOException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new InputSource(reader), contentHandler);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        finally {
            reader.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consoleProperties";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "handler";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/testframework/sm/runner/history/ImportedToGeneralTestEventsConverter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

