/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private Utils() {
    }

    public static void showCompletionPopup(JComponent toolbarComponent, JList list2, String title, JTextComponent textField2, String ad) {
        Runnable callback = () -> {
            String selectedValue = (String)list2.getSelectedValue();
            if (selectedValue != null) {
                textField2.setText(selectedValue);
            }
        };
        PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder(list2);
        if (title != null) {
            builder.setTitle(title);
        }
        JBPopup popup2 = builder.setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(callback).createPopup();
        if (ad != null) {
            popup2.setAdText(ad, 2);
        }
        if (toolbarComponent != null) {
            popup2.showUnderneathOf((Component)toolbarComponent);
        } else {
            popup2.showUnderneathOf((Component)textField2);
        }
    }

    public static void setSmallerFont(JComponent component) {
        if (SystemInfo.isMac) {
            component.setFont((Font)JBUI.Fonts.smallFont());
        }
    }

    public static void setSmallerFontForChildren(JComponent component) {
        for (Component c : component.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            Utils.setSmallerFont((JComponent)c);
        }
    }

    @NotNull
    public static CustomShortcutSet shortcutSetOf(@NotNull List<Shortcut> shortcuts) {
        if (shortcuts == null) {
            Utils.$$$reportNull$$$0(0);
        }
        CustomShortcutSet customShortcutSet = new CustomShortcutSet(shortcuts.toArray(new Shortcut[shortcuts.size()]));
        if (customShortcutSet == null) {
            Utils.$$$reportNull$$$0(1);
        }
        return customShortcutSet;
    }

    @NotNull
    public static List<Shortcut> shortcutsOf(@NotNull String actionId) {
        AnAction action;
        if (actionId == null) {
            Utils.$$$reportNull$$$0(2);
        }
        List list2 = (action = ActionManager.getInstance().getAction(actionId)) == null ? ContainerUtil.emptyList() : ContainerUtil.immutableList((Object[])action.getShortcutSet().getShortcuts());
        if (list2 == null) {
            Utils.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/editorHeaderActions/Utils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/editorHeaderActions/Utils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "shortcutSetOf";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "shortcutsOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shortcutSetOf";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shortcutsOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

