/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.TooltipEvent;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.update.ComparableObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComponent;

public class IdeTooltip
extends ComparableObject.Impl {
    public static final Object TOOLTIP_DISMISS_DELAY_KEY = "TOOLTIP_DISMISS_DELAY_KEY";
    private Component myComponent;
    private Point myPoint;
    private Balloon.Position myPreferredPosition;
    private Balloon.Layer myLayer;
    private JComponent myTipComponent;
    private boolean myToCenter = false;
    private boolean myToCenterIfSmall = true;
    private boolean myHighlighter;
    private boolean myRequestFocus;
    private Color myTextBackground;
    private Color myTextForeground;
    private Color myBorderColor;
    private Insets myBorderInsets;
    private Font myFont;
    private int myCalloutShift = 4;
    private boolean myExplicitClose;
    private int myPositionChangeX;
    private int myPositionChangeY;
    private Ui myUi;
    private boolean myHint = false;

    public IdeTooltip(Component component, Point point, JComponent tipComponent, Object ... identity) {
        super(identity);
        this.myComponent = component;
        this.myPoint = point;
        this.myTipComponent = tipComponent;
        this.setPreferredPosition(Balloon.Position.above);
    }

    public IdeTooltip setPreferredPosition(Balloon.Position position) {
        this.myPreferredPosition = position;
        return this;
    }

    public Component getComponent() {
        return this.myComponent;
    }

    public Point getPoint() {
        return this.myPoint;
    }

    public RelativePoint getShowingPoint() {
        return this.myUi != null ? this.myUi.getShowingPoint() : new RelativePoint(this.getComponent(), this.getPoint());
    }

    public Balloon.Position getPreferredPosition() {
        return this.myPreferredPosition;
    }

    public JComponent getTipComponent() {
        return this.myTipComponent;
    }

    public IdeTooltip setToCenter(boolean toCenter) {
        this.myToCenter = toCenter;
        return this;
    }

    public boolean isToCenter() {
        return this.myToCenter;
    }

    public boolean isToCenterIfSmall() {
        return this.myToCenterIfSmall;
    }

    public IdeTooltip setToCenterIfSmall(boolean mayCenter) {
        this.myToCenterIfSmall = mayCenter;
        return this;
    }

    protected boolean canAutohideOn(TooltipEvent event) {
        return true;
    }

    protected void onHidden() {
    }

    protected boolean beforeShow() {
        return true;
    }

    public void hide() {
        IdeTooltipManager.getInstance().hide(this);
    }

    public boolean canBeDismissedOnTimeout() {
        return true;
    }

    public int getShowDelay() {
        return this.myHighlighter ? Registry.intValue((String)"ide.tooltip.initialDelay.highlighter") : Registry.intValue((String)"ide.tooltip.initialDelay");
    }

    public int getInitialReshowDelay() {
        return Registry.intValue((String)"ide.tooltip.initialReshowDelay");
    }

    public int getDismissDelay() {
        Object value;
        if (this.myComponent instanceof JComponent && (value = ((JComponent)this.myComponent).getClientProperty(TOOLTIP_DISMISS_DELAY_KEY)) instanceof Integer) {
            return (Integer)value;
        }
        return Registry.intValue((String)"ide.tooltip.dismissDelay");
    }

    public IdeTooltip setHighlighterType(boolean isHighlighter) {
        this.myHighlighter = isHighlighter;
        return this;
    }

    void setTipComponent(JComponent tipComponent) {
        this.myTipComponent = tipComponent;
    }

    public IdeTooltip setTextBackground(Color textBackground) {
        this.myTextBackground = textBackground;
        return this;
    }

    public IdeTooltip setTextForeground(Color textForeground) {
        this.myTextForeground = textForeground;
        return this;
    }

    public IdeTooltip setBorderColor(Color borderColor) {
        this.myBorderColor = borderColor;
        return this;
    }

    public IdeTooltip setBorderInsets(Insets insets) {
        this.myBorderInsets = insets;
        return this;
    }

    public Color getTextBackground() {
        return this.myTextBackground;
    }

    public Font getFont() {
        return this.myFont;
    }

    public Color getTextForeground() {
        return this.myTextForeground;
    }

    public Color getBorderColor() {
        return this.myBorderColor;
    }

    public Insets getBorderInsets() {
        return this.myBorderInsets;
    }

    public IdeTooltip setFont(Font font) {
        this.myFont = font;
        return this;
    }

    public int getCalloutShift() {
        return this.myCalloutShift;
    }

    public IdeTooltip setCalloutShift(int calloutShift) {
        this.myCalloutShift = calloutShift;
        return this;
    }

    public void setComponent(Component component) {
        this.myComponent = component;
    }

    public void setPoint(Point point) {
        this.myPoint = point;
    }

    public IdeTooltip setExplicitClose(boolean explicitClose) {
        this.myExplicitClose = explicitClose;
        return this;
    }

    public boolean isExplicitClose() {
        return this.myExplicitClose;
    }

    public IdeTooltip setPositionChangeShift(int positionChangeX, int positionChangeY) {
        this.myPositionChangeX = positionChangeX;
        this.myPositionChangeY = positionChangeY;
        return this;
    }

    public int getPositionChangeX() {
        return this.myPositionChangeX;
    }

    public int getPositionChangeY() {
        return this.myPositionChangeY;
    }

    public void setUi(Ui ui) {
        this.myUi = ui;
    }

    public IdeTooltip setLayer(Balloon.Layer layer) {
        this.myLayer = layer;
        return this;
    }

    public Balloon.Layer getLayer() {
        return this.myLayer;
    }

    public IdeTooltip setHint(boolean hint) {
        this.myHint = hint;
        return this;
    }

    public boolean isHint() {
        return this.myHint;
    }

    public boolean isInside(RelativePoint target2) {
        return this.myUi != null && this.myUi.isInside(target2);
    }

    public boolean isRequestFocus() {
        return this.myRequestFocus;
    }

    public IdeTooltip setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        return this;
    }

    public static interface Ui {
        public boolean isInside(RelativePoint var1);

        public RelativePoint getShowingPoint();
    }
}

