/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;

public class DeleteAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.DeleteAction");

    public DeleteAction() {
    }

    public DeleteAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        DeleteProvider provider = this.getDeleteProvider(dataContext);
        if (provider == null) {
            return;
        }
        try {
            provider.deleteElement(dataContext);
        }
        catch (Throwable t) {
            LOG.error(t);
        }
    }

    @Nullable
    protected DeleteProvider getDeleteProvider(DataContext dataContext) {
        return (DeleteProvider)PlatformDataKeys.DELETE_ELEMENT_PROVIDER.getData(dataContext);
    }

    public void update(AnActionEvent e) {
        boolean canDelete;
        Presentation presentation = e.getPresentation();
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setText(IdeBundle.message((String)"action.delete.ellipsis", (Object[])new Object[0]));
        } else {
            presentation.setText(IdeBundle.message((String)"action.delete", (Object[])new Object[0]));
        }
        if (e.getProject() == null) {
            presentation.setEnabled(false);
            return;
        }
        DataContext dataContext = e.getDataContext();
        DeleteProvider provider = this.getDeleteProvider(dataContext);
        if (e.getInputEvent() instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)e.getInputEvent();
            Object component = PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            if (component instanceof JTextComponent) {
                provider = null;
            }
            if (keyEvent.getKeyCode() == 8) {
                String activeSpeedSearchFilter;
                SpeedSearchSupply searchSupply;
                if (component instanceof JComponent && (searchSupply = SpeedSearchSupply.getSupply((JComponent)((JComponent)component))) != null) {
                    provider = null;
                }
                if (!StringUtil.isEmpty((String)(activeSpeedSearchFilter = (String)SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.getData(dataContext)))) {
                    provider = null;
                }
            }
        }
        if (provider instanceof TitledHandler) {
            presentation.setText(((TitledHandler)provider).getActionTitle());
        }
        boolean bl = canDelete = provider != null && provider.canDeleteElement(dataContext);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setVisible(canDelete);
        } else {
            presentation.setEnabled(canDelete);
        }
    }
}

