/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BooleanFunction;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

class EditorSettingsStatisticsCollector
extends UsagesCollector {
    private static final GroupDescriptor GROUP_DESCRIPTOR = GroupDescriptor.create("Editor");

    EditorSettingsStatisticsCollector() {
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GROUP_DESCRIPTOR;
        if (groupDescriptor == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(0);
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        HashSet<UsageDescriptor> set2 = new HashSet<UsageDescriptor>();
        EditorSettingsExternalizable es = EditorSettingsExternalizable.getInstance();
        EditorSettingsExternalizable esDefault = new EditorSettingsExternalizable();
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isVirtualSpace(), "caretAfterLineEnd");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isCaretInsideTabs(), "caretInsideTabs");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isAdditionalPageAtBottom(), "virtualSpaceAtFileBottom");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR), "softWraps");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE), "softWraps.console");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.PREVIEW), "softWraps.preview");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isUseCustomSoftWrapIndent(), "softWraps.relativeIndent");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isAllSoftWrapsShown(), "softWraps.showAll");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es, esDefault, s -> s.getStripTrailingSpaces(), "stripTrailingSpaces");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isEnsureNewLineAtEOF(), "ensureNewlineAtEOF");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowQuickDocOnMouseOverElement(), "quickDocOnMouseHover");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBlinkCaret(), "blinkingCaret");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBlockCursor(), "blockCaret");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isRightMarginShown(), "rightMargin");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isLineNumbersShown(), "lineNumbers");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.areGutterIconsShown(), "gutterIcons");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isFoldingOutlineShown(), "foldingOutline");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWhitespacesShown() && s.isLeadingWhitespacesShown(), "showLeadingWhitespace");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWhitespacesShown() && s.isInnerWhitespacesShown(), "showInnerWhitespace");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWhitespacesShown() && s.isTrailingWhitespacesShown(), "showTrailingWhitespace");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isIndentGuidesShown(), "indentGuides");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isSmoothScrolling(), "animatedScroll");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isDndEnabled(), "dragNDrop");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isWheelFontChangeEnabled(), "wheelZoom");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isMouseClickSelectionHonorsCamelWords(), "mouseCamel");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isVariableInplaceRenameEnabled(), "inplaceRename");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isPreselectRename(), "preselectOnRename");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowInlineLocalDialog(), "inlineDialog");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isRefrainFromScrolling(), "minimizeScrolling");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.getOptions().SHOW_NOTIFICATION_AFTER_REFORMAT_CODE_ACTION, "afterReformatNotification");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.getOptions().SHOW_NOTIFICATION_AFTER_OPTIMIZE_IMPORTS_ACTION, "afterOptimizeNotification");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isSmartHome(), "smartHome");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isCamelWords(), "camelWords");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isShowParameterNameHints(), "editor.inlay.parameter.hints");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBreadcrumbsAbove(), "noBreadcrumbsBelow");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBreadcrumbsShown(), "breadcrumbs");
        for (String language : es.getOptions().getLanguageBreadcrumbsMap().keySet()) {
            EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, es, esDefault, s -> s.isBreadcrumbsShownFor(language), "breadcrumbsFor" + language);
        }
        RichCopySettings rcs = RichCopySettings.getInstance();
        RichCopySettings rcsDefault = new RichCopySettings();
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, rcs, rcsDefault, s -> s.isEnabled(), "richCopy");
        CodeInsightSettings cis = CodeInsightSettings.getInstance();
        CodeInsightSettings cisDefault = new CodeInsightSettings();
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTO_POPUP_PARAMETER_INFO, "parameterAutoPopup");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTO_POPUP_JAVADOC_INFO, "javadocAutoPopup");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTO_POPUP_COMPLETION_LOOKUP, "completionAutoPopup");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis, cisDefault, s -> s.COMPLETION_CASE_SENSITIVE, "completionCaseSensitivity");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS, "autoPopupCharComplete");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOCOMPLETE_ON_CODE_COMPLETION, "autoCompleteBasic");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION, "autoCompleteSmart");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO, "parameterInfoFullSignature");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis, cisDefault, s -> s.getBackspaceMode(), "smartBackspace");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SMART_INDENT_ON_ENTER, "indentOnEnter");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.INSERT_BRACE_ON_ENTER, "braceOnEnter");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.JAVADOC_STUB_ON_ENTER, "javadocOnEnter");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SMART_END_ACTION, "smartEnd");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.JAVADOC_GENERATE_CLOSING_TAG, "autoCloseJavadocTags");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SURROUND_SELECTION_ON_QUOTE_TYPED, "surroundByQuoteOrBrace");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOINSERT_PAIR_BRACKET, "pairBracketAutoInsert");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.AUTOINSERT_PAIR_QUOTE, "pairQuoteAutoInsert");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.REFORMAT_BLOCK_ON_RBRACE, "reformatOnRBrace");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis, cisDefault, s -> s.REFORMAT_ON_PASTE, "reformatOnPaste");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis, cisDefault, s -> s.ADD_IMPORTS_ON_PASTE, "importsOnPaste");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.HIGHLIGHT_BRACES, "bracesHighlight");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.HIGHLIGHT_SCOPE, "scopeHighlight");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.HIGHLIGHT_IDENTIFIER_UNDER_CARET, "identifierUnderCaretHighlight");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY, "autoAddImports");
        EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, cis, cisDefault, s -> s.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION, "completionHints");
        HashSet<UsageDescriptor> hashSet = set2;
        if (hashSet == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static <T> void addBoolIfDiffers(Set<UsageDescriptor> set2, T settingsBean, T defaultSettingsBean, BooleanFunction<T> valueFunction, String featureId) {
        boolean defaultValue;
        boolean value = valueFunction.fun(settingsBean);
        if (value != (defaultValue = valueFunction.fun(defaultSettingsBean))) {
            set2.add(new UsageDescriptor(defaultValue ? "no" + StringUtil.capitalize((String)featureId) : featureId, 1));
        }
    }

    private static <T> void addIfDiffers(Set<UsageDescriptor> set2, T settingsBean, T defaultSettingsBean, Function<T, Object> valueFunction, String featureIdPrefix) {
        Object defaultValue;
        Object value = valueFunction.apply(settingsBean);
        if (!Comparing.equal((Object)value, (Object)(defaultValue = valueFunction.apply(defaultSettingsBean)))) {
            set2.add(new UsageDescriptor(featureIdPrefix + "." + value, 1));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class ProjectUsages
    extends AbstractProjectsUsagesCollector {
        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP_DESCRIPTOR;
            if (groupDescriptor == null) {
                ProjectUsages.$$$reportNull$$$0(0);
            }
            return groupDescriptor;
        }

        @Override
        @NotNull
        public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
            if (project == null) {
                ProjectUsages.$$$reportNull$$$0(1);
            }
            HashSet<UsageDescriptor> set2 = new HashSet<UsageDescriptor>();
            CodeInsightWorkspaceSettings ciws = CodeInsightWorkspaceSettings.getInstance(project);
            CodeInsightWorkspaceSettings ciwsDefault = new CodeInsightWorkspaceSettings();
            EditorSettingsStatisticsCollector.addBoolIfDiffers(set2, ciws, ciwsDefault, s -> s.optimizeImportsOnTheFly, "autoOptimizeImports");
            HashSet<UsageDescriptor> hashSet = set2;
            if (hashSet == null) {
                ProjectUsages.$$$reportNull$$$0(2);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector$ProjectUsages";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector$ProjectUsages";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getProjectUsages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

