/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NotificationConfiguration", storages={@Storage(value="notifications.xml")})
public class NotificationsConfigurationImpl
extends NotificationsConfiguration
implements PersistentStateComponent<Element>,
Disposable,
ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(NotificationsConfiguration.class);
    private static final String SHOW_BALLOONS_ATTRIBUTE = "showBalloons";
    private static final String SYSTEM_NOTIFICATIONS_ATTRIBUTE = "systemNotifications";
    private static final Comparator<NotificationSettings> NOTIFICATION_SETTINGS_COMPARATOR = (o1, o2) -> o1.getGroupId().compareToIgnoreCase(o2.getGroupId());
    private final Map<String, NotificationSettings> myIdToSettingsMap;
    private final Map<String, String> myToolWindowCapable;
    private final MessageBus myMessageBus;
    public boolean SHOW_BALLOONS;
    public boolean SYSTEM_NOTIFICATIONS;

    public NotificationsConfigurationImpl(@NotNull MessageBus bus) {
        if (bus == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(0);
        }
        this.myIdToSettingsMap = new THashMap();
        this.myToolWindowCapable = new THashMap();
        this.SHOW_BALLOONS = true;
        this.SYSTEM_NOTIFICATIONS = true;
        this.myMessageBus = bus;
    }

    public static NotificationsConfigurationImpl getInstanceImpl() {
        return (NotificationsConfigurationImpl)NotificationsConfigurationImpl.getNotificationsConfiguration();
    }

    public synchronized boolean hasToolWindowCapability(@NotNull String groupId) {
        if (groupId == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(1);
        }
        return this.getToolWindowId(groupId) != null || this.myToolWindowCapable.containsKey(groupId);
    }

    @Nullable
    public String getToolWindowId(@NotNull String groupId) {
        NotificationGroup group;
        if (groupId == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(2);
        }
        return (group = NotificationGroup.findRegisteredGroup((String)groupId)) == null ? null : group.getToolWindowId();
    }

    public synchronized NotificationSettings[] getAllSettings() {
        THashSet settings = new THashSet(this.myIdToSettingsMap.values());
        for (NotificationGroup group : NotificationGroup.getAllRegisteredGroups()) {
            if (group.getDisplayId().startsWith("LIGHTWEIGHT")) continue;
            settings.add(NotificationsConfigurationImpl.getSettings(group.getDisplayId()));
        }
        NotificationSettings[] result2 = settings.toArray(new NotificationSettings[settings.size()]);
        Arrays.sort(result2, NOTIFICATION_SETTINGS_COMPARATOR);
        return result2;
    }

    public static void remove(String ... toRemove2) {
        NotificationsConfigurationImpl.getInstanceImpl().doRemove(toRemove2);
    }

    private synchronized void doRemove(String ... toRemove2) {
        for (String groupId : toRemove2) {
            this.myIdToSettingsMap.remove(groupId);
            this.myToolWindowCapable.remove(groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static NotificationSettings getSettings(@NotNull String groupId) {
        NotificationSettings settings;
        NotificationsConfigurationImpl impl;
        if (groupId == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(3);
        }
        NotificationsConfigurationImpl notificationsConfigurationImpl = impl = NotificationsConfigurationImpl.getInstanceImpl();
        synchronized (notificationsConfigurationImpl) {
            settings = impl.myIdToSettingsMap.get(groupId);
        }
        NotificationSettings notificationSettings = settings == null ? NotificationsConfigurationImpl.getDefaultSettings(groupId) : settings;
        if (notificationSettings == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(4);
        }
        return notificationSettings;
    }

    @NotNull
    private static NotificationSettings getDefaultSettings(String groupId) {
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId);
        if (group != null) {
            NotificationSettings notificationSettings = new NotificationSettings(groupId, group.getDisplayType(), group.isLogByDefault(), false);
            if (notificationSettings == null) {
                NotificationsConfigurationImpl.$$$reportNull$$$0(5);
            }
            return notificationSettings;
        }
        NotificationSettings notificationSettings = new NotificationSettings(groupId, NotificationDisplayType.BALLOON, true, false);
        if (notificationSettings == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(6);
        }
        return notificationSettings;
    }

    public void initComponent() {
        this.myMessageBus.connect((Disposable)this).subscribe(TOPIC, (Object)this);
    }

    public synchronized void dispose() {
        this.myIdToSettingsMap.clear();
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType) {
        if (groupDisplayName == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(7);
        }
        if (displayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(8);
        }
        this.register(groupDisplayName, displayType, true);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog) {
        if (groupDisplayName == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(9);
        }
        if (displayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(10);
        }
        this.register(groupDisplayName, displayType, shouldLog, false);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        if (groupDisplayName == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(11);
        }
        if (displayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(12);
        }
        if (!this.isRegistered(groupDisplayName)) {
            new NotificationGroup(groupDisplayName, displayType, shouldLog);
            this.changeSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud);
        } else if (displayType == NotificationDisplayType.TOOL_WINDOW && !this.hasToolWindowCapability(groupDisplayName)) {
            this.changeSettings(NotificationsConfigurationImpl.getSettings(groupDisplayName).withDisplayType(NotificationDisplayType.TOOL_WINDOW));
            this.myToolWindowCapable.put(groupDisplayName, null);
        }
    }

    public void changeSettings(String groupDisplayName, NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        this.changeSettings(new NotificationSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud));
    }

    public synchronized void changeSettings(NotificationSettings settings) {
        String groupDisplayName = settings.getGroupId();
        if (settings.equals(NotificationsConfigurationImpl.getDefaultSettings(groupDisplayName))) {
            this.myIdToSettingsMap.remove(groupDisplayName);
        } else {
            this.myIdToSettingsMap.put(groupDisplayName, settings);
        }
    }

    public synchronized boolean isRegistered(@NotNull String id) {
        if (id == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(13);
        }
        return this.myIdToSettingsMap.containsKey(id) || NotificationGroup.findRegisteredGroup((String)id) != null;
    }

    public synchronized Element getState() {
        Element element = new Element("NotificationsConfiguration");
        NotificationSettings[] sortedNotifications = this.myIdToSettingsMap.values().toArray(new NotificationSettings[this.myIdToSettingsMap.size()]);
        Arrays.sort(sortedNotifications, NOTIFICATION_SETTINGS_COMPARATOR);
        for (NotificationSettings settings : sortedNotifications) {
            element.addContent(settings.save());
        }
        if (!this.SHOW_BALLOONS) {
            element.setAttribute(SHOW_BALLOONS_ATTRIBUTE, "false");
        }
        if (!this.SYSTEM_NOTIFICATIONS) {
            element.setAttribute(SYSTEM_NOTIFICATIONS_ATTRIBUTE, "false");
        }
        return element;
    }

    public synchronized void loadState(Element state2) {
        this.myIdToSettingsMap.clear();
        for (Element child : state2.getChildren("notification")) {
            NotificationSettings settings = NotificationSettings.load(child);
            if (settings == null) continue;
            String id = settings.getGroupId();
            LOG.assertTrue(!this.myIdToSettingsMap.containsKey(id), (Object)String.format("Settings for '%s' already loaded!", id));
            this.myIdToSettingsMap.put(id, settings);
        }
        this.doRemove("Log Only");
        if ("false".equals(state2.getAttributeValue(SHOW_BALLOONS_ATTRIBUTE))) {
            this.SHOW_BALLOONS = false;
        }
        if ("false".equals(state2.getAttributeValue(SYSTEM_NOTIFICATIONS_ATTRIBUTE))) {
            this.SYSTEM_NOTIFICATIONS = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationsConfigurationImpl";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDisplayName";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationsConfigurationImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasToolWindowCapability";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isRegistered";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

