/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.impl.EditorChangeAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import org.jetbrains.annotations.Nullable;

public class DocumentUndoProvider
implements Disposable {
    private static final Key<Boolean> UNDOING_EDITOR_CHANGE = Key.create((String)"DocumentUndoProvider.UNDOING_EDITOR_CHANGE");
    private final Project myProject;

    DocumentUndoProvider(Project project) {
        MyEditorDocumentListener documentListener = new MyEditorDocumentListener();
        this.myProject = project;
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)documentListener, (Disposable)this);
    }

    public void dispose() {
    }

    private UndoManagerImpl getUndoManager() {
        return (UndoManagerImpl)(this.myProject == null ? UndoManager.getGlobalInstance() : UndoManager.getInstance((Project)this.myProject));
    }

    public static void startDocumentUndo(@Nullable Document doc) {
        if (doc != null) {
            doc.putUserData(UNDOING_EDITOR_CHANGE, (Object)Boolean.TRUE);
        }
    }

    public static void finishDocumentUndo(@Nullable Document doc) {
        if (doc != null) {
            doc.putUserData(UNDOING_EDITOR_CHANGE, null);
        }
    }

    private class MyEditorDocumentListener
    implements DocumentListener {
        private MyEditorDocumentListener() {
        }

        public void beforeDocumentChange(DocumentEvent e) {
            Document document = e.getDocument();
            if (!this.shouldProcess(document)) {
                return;
            }
            UndoManagerImpl undoManager = DocumentUndoProvider.this.getUndoManager();
            if (undoManager.isActive() && this.isUndoable(document) && (undoManager.isUndoInProgress() || undoManager.isRedoInProgress()) && document.getUserData(UNDOING_EDITOR_CHANGE) != Boolean.TRUE) {
                throw new IllegalStateException("Do not change documents during undo as it will break undo sequence.");
            }
        }

        public void documentChanged(DocumentEvent e) {
            Document document = e.getDocument();
            if (!this.shouldProcess(document)) {
                return;
            }
            UndoManagerImpl undoManager = DocumentUndoProvider.this.getUndoManager();
            if (undoManager.isActive() && this.isUndoable(document)) {
                this.registerUndoableAction(e);
            } else {
                this.registerNonUndoableAction(document);
            }
        }

        private boolean shouldProcess(Document document) {
            if (DocumentUndoProvider.this.myProject != null && DocumentUndoProvider.this.myProject.isDisposed()) {
                return false;
            }
            return !UndoManagerImpl.isCopy(document) && this.shouldRecordActions(document);
        }

        private boolean shouldRecordActions(Document document) {
            if (document.getUserData(UndoConstants.DONT_RECORD_UNDO) == Boolean.TRUE) {
                return false;
            }
            VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
            if (vFile == null) {
                return true;
            }
            return vFile.getUserData(AbstractFileViewProvider.FREE_THREADED) != Boolean.TRUE && vFile.getUserData(UndoConstants.DONT_RECORD_UNDO) != Boolean.TRUE;
        }

        private void registerUndoableAction(DocumentEvent e) {
            DocumentUndoProvider.this.getUndoManager().undoableActionPerformed((UndoableAction)new EditorChangeAction(e));
        }

        private void registerNonUndoableAction(Document document) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
            DocumentUndoProvider.this.getUndoManager().nonundoableActionPerformed(ref, false);
        }

        private boolean isUndoable(Document document) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
            VirtualFile file2 = ref.getFile();
            if (file2 != null && file2.getUserData(UndoConstants.FORCE_RECORD_UNDO) == Boolean.TRUE) {
                return true;
            }
            return !UndoManagerImpl.isRefresh() || DocumentUndoProvider.this.getUndoManager().isUndoOrRedoAvailable(ref);
        }
    }
}

