/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.JarFileDiffElement;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.DirDiffManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;

public class ArchiveDiffTool
implements DiffTool {
    public static final ArchiveDiffTool INSTANCE = new ArchiveDiffTool();

    private ArchiveDiffTool() {
    }

    public void show(DiffRequest request) {
        DiffContent[] contents = request.getContents();
        VirtualFile file1 = contents[0].getFile();
        VirtualFile file2 = contents[1].getFile();
        assert (file1 != null && file2 != null);
        JarFileDiffElement element = new JarFileDiffElement(file1);
        JarFileDiffElement element1 = new JarFileDiffElement(file2);
        DirDiffSettings settings = new DirDiffSettings();
        settings.showInFrame = false;
        settings.enableChoosers = false;
        DirDiffManager.getInstance((Project)request.getProject()).showDiff((DiffElement)element, (DiffElement)element1, settings);
    }

    public boolean canShow(DiffRequest request) {
        DiffContent[] contents = request.getContents();
        DialogWrapper instance = DialogWrapper.findInstance((Component)IdeFocusManager.getInstance((Project)request.getProject()).getFocusOwner());
        if (instance != null && instance.isModal()) {
            return false;
        }
        if (contents.length == 2) {
            VirtualFile file1 = contents[0].getFile();
            VirtualFile file2 = contents[1].getFile();
            if (file1 != null && file2 != null) {
                FileType type2;
                FileType type1 = contents[0].getContentType();
                return type1 == (type2 = contents[1].getContentType()) && type1 instanceof ArchiveFileType;
            }
        }
        return false;
    }

    public DiffViewer createComponent(String title, DiffRequest request, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ArchiveDiffTool.$$$reportNull$$$0(0);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/external/ArchiveDiffTool", "createComponent"));
    }
}

