/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.CaretStateTransferableData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClipboardTextPerCaretSplitter {
    @NotNull
    public List<String> split(@NotNull String input, @Nullable CaretStateTransferableData caretData, int caretCount) {
        if (input == null) {
            ClipboardTextPerCaretSplitter.$$$reportNull$$$0(0);
        }
        if (caretCount <= 0) {
            throw new IllegalArgumentException("Caret count must be positive");
        }
        if (caretCount == 1) {
            List<String> list2 = Collections.singletonList(input);
            if (list2 == null) {
                ClipboardTextPerCaretSplitter.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList<String> result2 = new ArrayList<String>(caretCount);
        if (caretData == null) {
            String[] lines2 = input.split("\n", -1);
            int sourceCaretCount = lines2.length == 2 && lines2[1].isEmpty() ? 1 : lines2.length;
            for (int i = 0; i < caretCount; ++i) {
                if (sourceCaretCount == 1) {
                    result2.add(lines2[0]);
                    continue;
                }
                result2.add(i < lines2.length ? lines2[i] : "");
            }
        } else {
            int sourceCaretCount = caretData.startOffsets.length;
            for (int i = 0; i < caretCount; ++i) {
                if (sourceCaretCount == 1) {
                    result2.add(input);
                    continue;
                }
                result2.add(i < sourceCaretCount ? input.substring(caretData.startOffsets[i], caretData.endOffsets[i]) : "");
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ClipboardTextPerCaretSplitter.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ClipboardTextPerCaretSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ClipboardTextPerCaretSplitter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

