/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateAction
extends EditorAction {
    public DuplicateAction() {
        super((EditorActionHandler)new Handler());
    }

    private static void duplicateLineOrSelectedBlockAtCaret(Editor editor) {
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (editor.getSelectionModel().hasSelection()) {
            int start = editor.getSelectionModel().getSelectionStart();
            int end = editor.getSelectionModel().getSelectionEnd();
            String s = document.getCharsSequence().subSequence(start, end).toString();
            document.insertString(end, (CharSequence)s);
            caretModel.moveToOffset(end + s.length());
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
            editor.getSelectionModel().setSelection(end, end + s.length());
        } else {
            DuplicateAction.duplicateLinesRange(editor, document, caretModel.getVisualPosition(), caretModel.getVisualPosition());
        }
    }

    @Nullable
    static Couple<Integer> duplicateLinesRange(Editor editor, Document document, VisualPosition rangeStart, VisualPosition rangeEnd) {
        Pair<LogicalPosition, LogicalPosition> lines2 = EditorUtil.calcSurroundingRange(editor, rangeStart, rangeEnd);
        int offset = editor.getCaretModel().getOffset();
        LogicalPosition lineStart = (LogicalPosition)lines2.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines2.second;
        int start = editor.logicalPositionToOffset(lineStart);
        int end = editor.logicalPositionToOffset(nextLineStart);
        if (end <= start) {
            return null;
        }
        String s = document.getCharsSequence().subSequence(start, end).toString();
        int lineToCheck = nextLineStart.line - 1;
        int newOffset = end + offset - start;
        if (lineToCheck == document.getLineCount() || lineStart.line == document.getLineCount() - 1 || document.getLineSeparatorLength(lineToCheck) == 0) {
            s = "\n" + s;
            ++newOffset;
        }
        document.insertString(end, (CharSequence)s);
        editor.getCaretModel().moveToOffset(newOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return Couple.of((Object)end, (Object)(end + s.length()));
    }

    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        super.update(editor, presentation, dataContext);
        if (editor.getSelectionModel().hasSelection()) {
            presentation.setText(EditorBundle.message((String)"action.duplicate.selection", (Object[])new Object[0]), true);
        } else {
            presentation.setText(EditorBundle.message((String)"action.duplicate.line", (Object[])new Object[0]), true);
        }
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            DuplicateAction.duplicateLineOrSelectedBlockAtCaret(editor);
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            return !editor.isOneLineMode() || editor.getSelectionModel().hasSelection();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/DuplicateAction$Handler";
            objectArray[2] = "isEnabledForCaret";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

