/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.KillRingUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.util.text.CharArrayUtil;

public class KillToWordEndAction
extends TextComponentEditorAction {
    public KillToWordEndAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            Document document;
            CaretModel caretModel = editor.getCaretModel();
            int caretOffset = caretModel.getOffset();
            if (caretOffset >= (document = editor.getDocument()).getTextLength()) {
                return;
            }
            int caretLine = caretModel.getLogicalPosition().line;
            int lineEndOffset = document.getLineEndOffset(caretLine);
            boolean camel = editor.getSettings().isCamelWords();
            for (int i = caretOffset + 1; i < lineEndOffset; ++i) {
                if (!EditorActionUtil.isWordOrLexemeEnd(editor, i, camel)) continue;
                KillRingUtil.cut(editor, caretOffset, i);
                return;
            }
            int end = lineEndOffset;
            if (caretLine < document.getLineCount() - 1 && CharArrayUtil.isEmptyOrSpaces((CharSequence)document.getImmutableCharSequence(), (int)caretOffset, (int)end)) {
                ++end;
            }
            if (end > caretOffset) {
                KillRingUtil.cut(editor, caretOffset, end);
            }
        }
    }
}

