/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.view.LineFragment;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

abstract class TextFragment
implements LineFragment {
    @NotNull
    final float[] myCharPositions;

    TextFragment(int charCount) {
        assert (charCount > 0);
        this.myCharPositions = new float[charCount];
    }

    @Override
    public int getLength() {
        return this.myCharPositions.length;
    }

    abstract boolean isRtl();

    @Override
    @NotNull
    public LineFragment subFragment(int startOffset, int endOffset) {
        assert (startOffset >= 0);
        assert (endOffset <= this.myCharPositions.length);
        assert (startOffset < endOffset);
        if (startOffset == 0 && endOffset == this.myCharPositions.length) {
            TextFragment textFragment = this;
            if (textFragment == null) {
                TextFragment.$$$reportNull$$$0(0);
            }
            return textFragment;
        }
        TextFragmentWindow textFragmentWindow = new TextFragmentWindow(startOffset, endOffset);
        if (textFragmentWindow == null) {
            TextFragment.$$$reportNull$$$0(1);
        }
        return textFragmentWindow;
    }

    abstract int offsetToLogicalColumn(int var1);

    @Override
    public float offsetToX(float startX, int startOffset, int offset) {
        return startX + this.getX(offset) - this.getX(startOffset);
    }

    float getX(int offset) {
        return offset <= 0 ? 0.0f : this.myCharPositions[Math.min(this.myCharPositions.length, offset) - 1];
    }

    @Override
    public int logicalToVisualColumn(float startX, int startColumn, int column) {
        return column;
    }

    @Override
    public int visualToLogicalColumn(float startX, int startColumn, int column) {
        return column;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TextFragment", "subFragment"));
    }

    private class TextFragmentWindow
    implements LineFragment {
        private final int myStartOffset;
        private final int myEndOffset;
        private final int myStartColumn;
        private final int myEndColumn;

        private TextFragmentWindow(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myStartColumn = TextFragment.this.offsetToLogicalColumn(startOffset);
            this.myEndColumn = TextFragment.this.offsetToLogicalColumn(endOffset);
        }

        @Override
        public int getLength() {
            return this.myEndOffset - this.myStartOffset;
        }

        @Override
        public int getLogicalColumnCount(int startColumn) {
            return this.myEndColumn - this.myStartColumn;
        }

        @Override
        public int getVisualColumnCount(float startX) {
            return this.myEndColumn - this.myStartColumn;
        }

        @Override
        public int logicalToVisualColumn(float startX, int startColumn, int column) {
            return column;
        }

        @Override
        public int visualToLogicalColumn(float startX, int startColumn, int column) {
            return column;
        }

        @Override
        public float offsetToX(float startX, int startOffset, int offset) {
            return TextFragment.this.offsetToX(startX, this.visualOffsetToParent(startOffset), this.visualOffsetToParent(offset));
        }

        @Override
        public float visualColumnToX(float startX, int column) {
            int startColumnInParent = this.visualColumnToParent(0);
            float parentStartX = startX - TextFragment.this.visualColumnToX(0.0f, startColumnInParent);
            int columnInParent = this.visualColumnToParent(column);
            return TextFragment.this.visualColumnToX(parentStartX, columnInParent);
        }

        @Override
        public int[] xToVisualColumn(float startX, float x) {
            int[] nArray;
            int startColumnInParent = this.visualColumnToParent(0);
            float parentStartX = startX - TextFragment.this.visualColumnToX(0.0f, startColumnInParent);
            int[] parentColumn = TextFragment.this.xToVisualColumn(parentStartX, x);
            int column = parentColumn[0] - startColumnInParent;
            int columnCount = this.getVisualColumnCount(startX);
            if (column < 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 0;
            } else if (column > columnCount) {
                int[] nArray3 = new int[2];
                nArray3[0] = columnCount;
                nArray = nArray3;
                nArray3[1] = 1;
            } else {
                int[] nArray4 = new int[2];
                nArray4[0] = column;
                nArray = nArray4;
                nArray4[1] = parentColumn[1];
            }
            return nArray;
        }

        private int visualOffsetToParent(int offset) {
            return offset + (TextFragment.this.isRtl() ? TextFragment.this.myCharPositions.length - this.myEndOffset : this.myStartOffset);
        }

        private int visualColumnToParent(int column) {
            return column + (TextFragment.this.isRtl() ? TextFragment.this.getVisualColumnCount(0.0f) - this.myEndColumn : this.myStartColumn);
        }

        @Override
        public void draw(Graphics2D g, float x, float y, int startOffset, int endOffset) {
            TextFragment.this.draw(g, x, y, this.visualOffsetToParent(startOffset), this.visualOffsetToParent(endOffset));
        }

        @Override
        @NotNull
        public LineFragment subFragment(int startOffset, int endOffset) {
            LineFragment lineFragment = TextFragment.this.subFragment(startOffset + this.myStartOffset, endOffset + this.myStartOffset);
            if (lineFragment == null) {
                TextFragmentWindow.$$$reportNull$$$0(0);
            }
            return lineFragment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TextFragment$TextFragmentWindow", "subFragment"));
        }
    }
}

