/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FontMapper {
    private static final Logger LOG = Logger.getInstance(FontMapper.class);
    private static final String[] logicalFontsToMap = new String[]{"Dialog", "DialogInput", "Monospaced", "Serif", "SansSerif"};
    private static final Map<String, String> logicalToPhysicalMapping = new HashMap<String, String>();

    @NotNull
    public static String getPhysicalFontName(@NotNull String logicalFontName) {
        String mapped;
        if (logicalFontName == null) {
            FontMapper.$$$reportNull$$$0(0);
        }
        String string = (mapped = logicalToPhysicalMapping.get(logicalFontName)) == null ? logicalFontName : mapped;
        if (string == null) {
            FontMapper.$$$reportNull$$$0(1);
        }
        return string;
    }

    static {
        try {
            Object fontManager = null;
            try {
                fontManager = Class.forName("sun.font.FontManagerFactory").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Method findFontMethod = Class.forName("sun.font.FontManager").getMethod("findFont2D", String.class, Integer.TYPE, Integer.TYPE);
            for (String logicalFont : logicalFontsToMap) {
                Object font2D = findFontMethod.invoke(fontManager, logicalFont, 0, 0);
                if (font2D == null) continue;
                String fontClassName = font2D.getClass().getName();
                String physicalFont = null;
                if ("sun.font.CompositeFont".equals(fontClassName)) {
                    Object physicalFontObject = Class.forName("sun.font.CompositeFont").getMethod("getSlotFont", Integer.TYPE).invoke(font2D, 0);
                    physicalFont = (String)Class.forName("sun.font.Font2D").getMethod("getFamilyName", Locale.class).invoke(physicalFontObject, Locale.getDefault());
                } else if ("sun.font.CFont".equals(fontClassName)) {
                    physicalFont = (String)ReflectionUtil.getField(Class.forName("sun.font.CFont"), (Object)font2D, String.class, (String)"nativeFontName");
                }
                if (physicalFont == null) continue;
                logicalToPhysicalMapping.put(logicalFont, physicalFont);
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed to determine logical to physical font mappings");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalFontName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/richcopy/FontMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/richcopy/FontMapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysicalFontName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPhysicalFontName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

