/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class SdkListCellRenderer
extends ColoredListCellRendererWrapper<Sdk> {
    private final String myNullText;
    private final boolean myShowHomePath;

    public SdkListCellRenderer(@NotNull String nullText) {
        if (nullText == null) {
            SdkListCellRenderer.$$$reportNull$$$0(0);
        }
        this(nullText, false);
    }

    public SdkListCellRenderer(@NotNull String nullText, boolean showHomePath) {
        if (nullText == null) {
            SdkListCellRenderer.$$$reportNull$$$0(1);
        }
        this.myNullText = nullText;
        this.myShowHomePath = showHomePath;
    }

    protected void doCustomize(JList list2, Sdk sdk, int index, boolean selected, boolean hasFocus) {
        if (sdk != null) {
            this.setIcon(this.getSdkIcon(sdk));
            this.append(sdk.getName());
            if (this.myShowHomePath) {
                this.append(" (" + FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)sdk.getHomePath())) + ")", selected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else {
            this.append(this.myNullText);
        }
    }

    protected Icon getSdkIcon(Sdk sdk) {
        return ((SdkType)sdk.getSdkType()).getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullText", "com/intellij/openapi/projectRoots/impl/SdkListCellRenderer", "<init>"));
    }
}

