/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DescindingFilesFilter {
    private DescindingFilesFilter() {
    }

    @NotNull
    public static FilePath[] filterDescindingFiles(@NotNull FilePath[] roots, Project project) {
        if (roots == null) {
            DescindingFilesFilter.$$$reportNull$$$0(0);
        }
        LinkedList<FilePath> result2 = new LinkedList<FilePath>();
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        Arrays.sort(roots, FilePathComparator.getInstance());
        HashMap chains = new HashMap();
        for (FilePath root : roots) {
            AbstractVcs vcs = manager.getVcsFor(root);
            if (vcs == null) continue;
            if (vcs.allowsNestedRoots()) {
                result2.add(root);
                continue;
            }
            List chain = (List)chains.get(vcs.getKeyInstanceMethod());
            if (chain == null) {
                LinkedList<FilePath> newList = new LinkedList<FilePath>();
                newList.add(root);
                chains.put(vcs.getKeyInstanceMethod(), newList);
                continue;
            }
            boolean failed = false;
            for (FilePath chainedPath : chain) {
                if (!VfsUtilCore.isAncestor((File)chainedPath.getIOFile(), (File)root.getIOFile(), (boolean)false)) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            chain.add(root);
        }
        for (List filePaths : chains.values()) {
            result2.addAll(filePaths);
        }
        FilePath[] filePathArray = result2.toArray(new FilePath[result2.size()]);
        if (filePathArray == null) {
            DescindingFilesFilter.$$$reportNull$$$0(1);
        }
        return filePathArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/DescindingFilesFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/DescindingFilesFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDescindingFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterDescindingFiles";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilePathComparator
    implements Comparator<FilePath> {
        private static final FilePathComparator ourInstance = new FilePathComparator();

        private FilePathComparator() {
        }

        public static FilePathComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(@NotNull FilePath fp1, @NotNull FilePath fp2) {
            if (fp1 == null) {
                FilePathComparator.$$$reportNull$$$0(0);
            }
            if (fp2 == null) {
                FilePathComparator.$$$reportNull$$$0(1);
            }
            return fp1.getPath().length() - fp2.getPath().length();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fp1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fp2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/DescindingFilesFilter$FilePathComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

