/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.ui.Refreshable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ShowMessageHistoryAction
extends AnAction
implements DumbAware {
    public ShowMessageHistoryAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        DataContext dc = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        Object panel2 = CheckinProjectPanel.PANEL_KEY.getData(dc);
        if (!(panel2 instanceof CommitMessageI)) {
            panel2 = VcsDataKeys.COMMIT_MESSAGE_CONTROL.getData(dc);
        }
        if (project == null || panel2 == null) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setVisible(true);
            ArrayList recentMessages = VcsConfiguration.getInstance((Project)project).getRecentMessages();
            e.getPresentation().setEnabled(!recentMessages.isEmpty());
        }
    }

    public void actionPerformed(AnActionEvent e) {
        int selectedIndex;
        ContentChooser<String> contentChooser;
        VcsConfiguration configuration;
        CommitMessageI commitMessageI;
        DataContext dc = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        Refreshable panel2 = (Refreshable)CheckinProjectPanel.PANEL_KEY.getData(dc);
        CommitMessageI commitMessageI2 = commitMessageI = panel2 instanceof CommitMessageI ? (CommitMessageI)panel2 : (CommitMessageI)VcsDataKeys.COMMIT_MESSAGE_CONTROL.getData(dc);
        if (commitMessageI != null && project != null && !(configuration = VcsConfiguration.getInstance((Project)project)).getRecentMessages().isEmpty() && (contentChooser = new ContentChooser<String>(project, VcsBundle.message((String)"dialog.title.choose.commit.message.from.history", (Object[])new Object[0]), false){

            @Override
            protected void removeContentAt(String content) {
                configuration.removeMessage(content);
            }

            @Override
            protected String getStringRepresentationFor(String content) {
                return content;
            }

            @Override
            protected List<String> getContents() {
                ArrayList recentMessages = configuration.getRecentMessages();
                Collections.reverse(recentMessages);
                return recentMessages;
            }
        }).showAndGet() && (selectedIndex = contentChooser.getSelectedIndex()) >= 0) {
            commitMessageI.setCommitMessage((String)contentChooser.getAllContents().get(selectedIndex));
        }
    }
}

