/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;

public class CheckoutAction
extends AnAction
implements DumbAware {
    private final CheckoutProvider myProvider;

    public CheckoutAction(CheckoutProvider provider) {
        super(provider.getVcsName());
        this.myProvider = provider;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        project = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        this.myProvider.doCheckout(project, this.getListener(project));
    }

    protected CheckoutProvider.Listener getListener(Project project) {
        return ProjectLevelVcsManager.getInstance((Project)project).getCompositeCheckoutListener();
    }
}

