/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;

public class DependenciesToolWindow {
    private final Project myProject;
    private ContentManager myContentManager;

    public static DependenciesToolWindow getInstance(Project project) {
        return (DependenciesToolWindow)ServiceManager.getService((Project)project, DependenciesToolWindow.class);
    }

    public DependenciesToolWindow(Project project) {
        this.myProject = project;
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
            if (toolWindowManager == null) {
                return;
            }
            ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.DEPENDENCIES, true, ToolWindowAnchor.BOTTOM, (Disposable)project);
            toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
            this.myContentManager = toolWindow.getContentManager();
            toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowInspection);
            new ContentManagerWatcher(toolWindow, this.myContentManager);
        });
    }

    public void addContent(Content content) {
        Runnable runnable2 = () -> {
            this.myContentManager.addContent(content);
            this.myContentManager.setSelectedContent(content);
            ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.DEPENDENCIES).activate(null);
        };
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(runnable2);
    }

    public void closeContent(Content content) {
        this.myContentManager.removeContent(content, true);
    }
}

