/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependentNSReference
extends BasicAttributeValueReference {
    @NotNull
    private final URLReference myReference;
    private final boolean myForceFetchResultValid;

    public DependentNSReference(PsiElement element, TextRange range, @NotNull URLReference ref) {
        if (ref == null) {
            DependentNSReference.$$$reportNull$$$0(0);
        }
        this(element, range, ref, false);
    }

    public DependentNSReference(PsiElement element, TextRange range, @NotNull URLReference ref, boolean valid) {
        if (ref == null) {
            DependentNSReference.$$$reportNull$$$0(1);
        }
        super(element, range);
        this.myReference = ref;
        this.myForceFetchResultValid = valid;
    }

    @Nullable
    public PsiElement resolve() {
        String canonicalText = this.getCanonicalText();
        PsiFile file2 = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, this.myElement.getContainingFile(), null);
        if (file2 != null) {
            return file2;
        }
        PsiElement element = this.myReference.resolve();
        if (element == null && !this.myForceFetchResultValid && !XmlUtil.isUrlText(canonicalText, this.myElement.getProject())) {
            return this.myElement;
        }
        return element;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            DependentNSReference.$$$reportNull$$$0(2);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    public boolean isForceFetchResultValid() {
        return this.myForceFetchResultValid;
    }

    @NotNull
    public URLReference getNamespaceReference() {
        URLReference uRLReference = this.myReference;
        if (uRLReference == null) {
            DependentNSReference.$$$reportNull$$$0(3);
        }
        return uRLReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/DependentNSReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/DependentNSReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

