/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LanguageChangeSignatureDetector<C extends ChangeInfo> {
    @NotNull
    public C createInitialChangeInfo(@NotNull PsiElement var1);

    public boolean ignoreChanges(PsiElement var1);

    @Nullable
    public C createNextChangeInfo(String var1, @NotNull C var2, boolean var3);

    public void performChange(C var1, Editor var2, @NotNull String var3);

    public boolean isChangeSignatureAvailableOnElement(@NotNull PsiElement var1, C var2);

    public TextRange getHighlightingRange(@NotNull C var1);

    @NotNull
    default public String extractSignature(@NotNull C initialChangeInfo) {
        if (initialChangeInfo == null) {
            LanguageChangeSignatureDetector.$$$reportNull$$$0(0);
        }
        TextRange signatureRange = this.getHighlightingRange(initialChangeInfo);
        String string = signatureRange.shiftRight(-signatureRange.getStartOffset()).substring(initialChangeInfo.getMethod().getText());
        if (string == null) {
            LanguageChangeSignatureDetector.$$$reportNull$$$0(1);
        }
        return string;
    }

    default public String getMethodSignaturePreview(C info, List<TextRange> deleteRanges, List<TextRange> newRanges) {
        return this.extractSignature(info);
    }

    public FileType getFileType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialChangeInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/inplace/LanguageChangeSignatureDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/inplace/LanguageChangeSignatureDetector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractSignature";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

