/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.agent.RemoteAgent;
import com.intellij.remoteServer.agent.RemoteAgentManager;
import com.intellij.remoteServer.agent.RemoteAgentProxyFactory;
import com.intellij.remoteServer.agent.impl.RemoteAgentClassLoaderCache;
import com.intellij.remoteServer.agent.impl.RemoteAgentReflectiveThreadProxyFactory;
import com.intellij.util.Base64;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class RemoteAgentManagerImpl
extends RemoteAgentManager {
    private final RemoteAgentClassLoaderCache myClassLoaderCache = new RemoteAgentClassLoaderCache();

    public <T extends RemoteAgent> T createAgent(RemoteAgentProxyFactory agentProxyFactory, List<File> instanceLibraries, List<Class<?>> commonJarClasses, String specificsRuntimeModuleName, String specificsBuildJarPath, Class<T> agentInterface, String agentClassName, Class<?> pluginClass) throws Exception {
        ArrayList allCommonJarClasses = new ArrayList(commonJarClasses);
        allCommonJarClasses.add(RemoteAgent.class);
        allCommonJarClasses.add(Base64.class);
        allCommonJarClasses.add(agentInterface);
        ArrayList<File> libraries = new ArrayList<File>(instanceLibraries);
        for (Class clazz : allCommonJarClasses) {
            libraries.add(new File(PathUtil.getJarPathForClass((Class)clazz)));
        }
        File plugin = new File(PathUtil.getJarPathForClass(pluginClass));
        String string = plugin.getParent();
        if (plugin.isDirectory()) {
            File specificsModule = new File(string, specificsRuntimeModuleName);
            libraries.add(specificsModule);
        } else {
            File specificsDir = new File(string, FileUtil.toSystemDependentName((String)specificsBuildJarPath));
            libraries.add(specificsDir);
        }
        return (T)((RemoteAgent)agentProxyFactory.createProxy(libraries, agentInterface, agentClassName));
    }

    public RemoteAgentProxyFactory createReflectiveThreadProxyFactory(ClassLoader callerClassLoader) {
        return new RemoteAgentReflectiveThreadProxyFactory(this.myClassLoaderCache, callerClassLoader);
    }
}

