/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.WindowMouseListener;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class WindowResizeListener
extends WindowMouseListener {
    private final Insets myBorder;
    private final Icon myCorner;

    public WindowResizeListener(Component content, Insets border, Icon corner) {
        super(content);
        this.myBorder = border;
        this.myCorner = corner;
    }

    public WindowResizeListener(Component content, Icon corner) {
        super(content);
        this.myBorder = null;
        this.myCorner = corner;
    }

    protected Insets getResizeOffset(Component view) {
        return null;
    }

    protected Insets getResizeBorder(Component view) {
        return this.myBorder;
    }

    @Override
    protected boolean isDisabled(Component view) {
        if (view instanceof Dialog && !((Dialog)view).isResizable()) {
            return true;
        }
        if (view instanceof Frame && !((Frame)view).isResizable()) {
            return true;
        }
        return super.isDisabled(view);
    }

    @Override
    int getCursorType(Component view, Point location) {
        Container parent;
        Container container = parent = view instanceof Window ? null : view.getParent();
        if (parent != null) {
            SwingUtilities.convertPointFromScreen(location, parent);
        }
        Rectangle bounds = view.getBounds();
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getResizeOffset(view));
        int top = location.y - bounds.y;
        if (top < 0) {
            return -1;
        }
        int left = location.x - bounds.x;
        if (left < 0) {
            return -1;
        }
        int right = bounds.width - left;
        if (right < 0) {
            return -1;
        }
        int bottom = bounds.height - top;
        if (bottom < 0) {
            return -1;
        }
        if (this.myCorner != null && right < this.myCorner.getIconWidth() && bottom < this.myCorner.getIconHeight()) {
            return 0;
        }
        Insets expected = this.getResizeBorder(view);
        if (expected != null) {
            if (view instanceof Frame) {
                int state2 = ((Frame)view).getExtendedState();
                if (WindowResizeListener.isStateSet(2, state2)) {
                    left = Integer.MAX_VALUE;
                    right = Integer.MAX_VALUE;
                }
                if (WindowResizeListener.isStateSet(4, state2)) {
                    top = Integer.MAX_VALUE;
                    bottom = Integer.MAX_VALUE;
                }
            }
            if (top < expected.top) {
                if (left < expected.left * 2) {
                    return 6;
                }
                if (right < expected.right * 2) {
                    return 7;
                }
                return 8;
            }
            if (bottom < expected.bottom) {
                if (left < expected.left * 2) {
                    return 4;
                }
                if (right < expected.right * 2) {
                    return 5;
                }
                return 9;
            }
            if (left < expected.left) {
                if (top < expected.top * 2) {
                    return 6;
                }
                if (bottom < expected.bottom * 2) {
                    return 4;
                }
                return 10;
            }
            if (right < expected.right) {
                if (top < expected.top * 2) {
                    return 7;
                }
                if (bottom < expected.bottom * 2) {
                    return 5;
                }
                return 11;
            }
        }
        return -1;
    }

    @Override
    void updateBounds(Rectangle bounds, Component view, int dx, int dy) {
        Dimension minimum = view.getMinimumSize();
        if (this.myType == 7 || this.myType == 11 || this.myType == 5 || this.myType == 0) {
            bounds.width += WindowResizeListener.fixMinSize(dx, bounds.width, minimum.width);
        } else if (this.myType == 6 || this.myType == 10 || this.myType == 4) {
            dx = WindowResizeListener.fixMinSize(-dx, bounds.width, minimum.width);
            bounds.x -= dx;
            bounds.width += dx;
        }
        if (this.myType == 4 || this.myType == 9 || this.myType == 5 || this.myType == 0) {
            bounds.height += WindowResizeListener.fixMinSize(dy, bounds.height, minimum.height);
        } else if (this.myType == 6 || this.myType == 8 || this.myType == 7) {
            dy = WindowResizeListener.fixMinSize(-dy, bounds.height, minimum.height);
            bounds.y -= dy;
            bounds.height += dy;
        }
    }

    private static int fixMinSize(int delta, int value, int min) {
        return delta + value < min ? min - value : delta;
    }
}

