/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import java.lang.reflect.Array;
import java.util.function.Function;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class TreePathUtil {
    @NotNull
    public static TreePath createTreePath(TreePath parent, @NotNull Object component) {
        if (component == null) {
            TreePathUtil.$$$reportNull$$$0(0);
        }
        TreePath treePath = parent != null ? parent.pathByAddingChild(component) : new TreePath(component);
        if (treePath == null) {
            TreePathUtil.$$$reportNull$$$0(1);
        }
        return treePath;
    }

    public static String[] convertTreePathToStrings(@NotNull TreePath path) {
        if (path == null) {
            TreePathUtil.$$$reportNull$$$0(2);
        }
        return TreePathUtil.convertTreePathToArray(path, Object::toString, String.class);
    }

    public static Object[] convertTreePathToArray(@NotNull TreePath path) {
        if (path == null) {
            TreePathUtil.$$$reportNull$$$0(3);
        }
        return TreePathUtil.convertTreePathToArray(path, Function.identity(), Object.class);
    }

    public static Object[] convertTreePathToArray(@NotNull TreePath path, @NotNull Function<Object, Object> converter2) {
        if (path == null) {
            TreePathUtil.$$$reportNull$$$0(4);
        }
        if (converter2 == null) {
            TreePathUtil.$$$reportNull$$$0(5);
        }
        return TreePathUtil.convertTreePathToArray(path, converter2, Object.class);
    }

    public static <T> T[] convertTreePathToArray(@NotNull TreePath path, @NotNull Function<Object, T> converter2, @NotNull Class<T> type) {
        int count;
        if (path == null) {
            TreePathUtil.$$$reportNull$$$0(6);
        }
        if (converter2 == null) {
            TreePathUtil.$$$reportNull$$$0(7);
        }
        if (type == null) {
            TreePathUtil.$$$reportNull$$$0(8);
        }
        if ((count = path.getPathCount()) <= 0) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(type, count);
        while (path != null && count > 0) {
            Object component = path.getLastPathComponent();
            if (component == null) {
                return null;
            }
            T object = TreePathUtil.convert(component, converter2);
            if (object == null) {
                return null;
            }
            array[--count] = object;
            path = path.getParentPath();
        }
        return path != null || count > 0 ? null : array;
    }

    public static <T> TreePath convertArrayToTreePath(T ... array) {
        if (array == null) {
            TreePathUtil.$$$reportNull$$$0(9);
        }
        return TreePathUtil.convertArrayToTreePath(array, Function.identity());
    }

    public static <T> TreePath convertArrayToTreePath(@NotNull T[] array, @NotNull Function<T, Object> converter2) {
        int count;
        if (array == null) {
            TreePathUtil.$$$reportNull$$$0(10);
        }
        if (converter2 == null) {
            TreePathUtil.$$$reportNull$$$0(11);
        }
        if ((count = array.length) <= 0) {
            return null;
        }
        TreePath path = null;
        for (T object : array) {
            Object component = TreePathUtil.convert(object, converter2);
            if (component == null) {
                return null;
            }
            path = TreePathUtil.createTreePath(path, component);
        }
        return path;
    }

    private static <I, O> O convert(I object, @NotNull Function<I, O> converter2) {
        if (converter2 == null) {
            TreePathUtil.$$$reportNull$$$0(12);
        }
        return object == null ? null : (O)converter2.apply(object);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/TreePathUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/TreePathUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTreePath";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertTreePathToStrings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertTreePathToArray";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertArrayToTreePath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

