/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexScanRunnableCollector;
import com.intellij.util.indexing.IndexableSetContributor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileBasedIndexScanRunnableCollectorImpl
extends FileBasedIndexScanRunnableCollector {
    private final Project myProject;
    private final ProjectFileIndex myProjectFileIndex;
    private final FileTypeManager myFileTypeManager;

    public FileBasedIndexScanRunnableCollectorImpl(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        this.myFileTypeManager = FileTypeManager.getInstance();
    }

    @Override
    public boolean shouldCollect(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(1);
        }
        if (this.myProjectFileIndex.isInContent(file2) || this.myProjectFileIndex.isInLibraryClasses(file2) || this.myProjectFileIndex.isInLibrarySource(file2)) {
            return !this.myFileTypeManager.isFileIgnored(file2);
        }
        return false;
    }

    @Override
    public List<Runnable> collectScanRootRunnables(@NotNull ContentIterator processor2, ProgressIndicator indicator) {
        if (processor2 == null) {
            FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(2);
        }
        try (AccessToken ignore = ReadAction.start();){
            if (this.myProject.isDisposed()) {
                List<Runnable> list2 = Collections.emptyList();
                return list2;
            }
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            Set visitedRoots = ContainerUtil.newConcurrentSet();
            tasks.add(() -> {
                if (processor2 == null) {
                    FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(6);
                }
                this.myProjectFileIndex.iterateContent(processor2, file2 -> !file2.isDirectory() || visitedRoots.add(file2));
            });
            JBIterable contributedRoots = JBIterable.empty();
            for (IndexableSetContributor contributor : (IndexableSetContributor[])Extensions.getExtensions((ExtensionPointName)IndexableSetContributor.EP_NAME)) {
                if (this.myProject.isDisposed()) {
                    ArrayList<Runnable> arrayList = tasks;
                    return arrayList;
                }
                contributedRoots = contributedRoots.append((Iterable)IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor));
                contributedRoots = contributedRoots.append((Iterable)IndexableSetContributor.getProjectRootsToIndex((IndexableSetContributor)contributor, (Project)this.myProject));
            }
            for (VirtualFile root : contributedRoots) {
                if (!visitedRoots.add(root)) continue;
                tasks.add(() -> {
                    if (processor2 == null) {
                        FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(5);
                    }
                    if (this.myProject.isDisposed() || !root.isValid()) {
                        return;
                    }
                    FileBasedIndex.iterateRecursively((VirtualFile)root, (ContentIterator)processor2, (ProgressIndicator)indicator, (Set)visitedRoots, null);
                });
            }
            for (AdditionalLibraryRootsProvider provider : (AdditionalLibraryRootsProvider[])Extensions.getExtensions(AdditionalLibraryRootsProvider.EP_NAME)) {
                if (this.myProject.isDisposed()) {
                    ArrayList<Runnable> arrayList = tasks;
                    return arrayList;
                }
                for (SyntheticLibrary library : provider.getAdditionalProjectLibraries(this.myProject)) {
                    for (VirtualFile root : library.getSourceRoots()) {
                        if (!visitedRoots.add(root)) continue;
                        tasks.add(() -> {
                            if (processor2 == null) {
                                FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(4);
                            }
                            if (this.myProject.isDisposed() || !root.isValid()) {
                                return;
                            }
                            FileBasedIndex.iterateRecursively((VirtualFile)root, (ContentIterator)processor2, (ProgressIndicator)indicator, (Set)visitedRoots, (ProjectFileIndex)this.myProjectFileIndex);
                        });
                    }
                }
            }
            for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                OrderEntry[] orderEntries;
                for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
                    if (!(orderEntry instanceof LibraryOrSdkOrderEntry) || !orderEntry.isValid()) continue;
                    LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                    VirtualFile[] libSources = entry.getRootFiles(OrderRootType.SOURCES);
                    VirtualFile[] libClasses = entry.getRootFiles(OrderRootType.CLASSES);
                    VirtualFile[][] virtualFileArrayArray = new VirtualFile[][]{libSources, libClasses};
                    int n = virtualFileArrayArray.length;
                    for (int i = 0; i < n; ++i) {
                        VirtualFile[] roots;
                        for (VirtualFile root : roots = virtualFileArrayArray[i]) {
                            if (!visitedRoots.add(root)) continue;
                            tasks.add(() -> {
                                if (processor2 == null) {
                                    FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(3);
                                }
                                if (this.myProject.isDisposed() || module2.isDisposed() || !root.isValid()) {
                                    return;
                                }
                                FileBasedIndex.iterateRecursively((VirtualFile)root, (ContentIterator)processor2, (ProgressIndicator)indicator, (Set)visitedRoots, (ProjectFileIndex)this.myProjectFileIndex);
                            });
                        }
                    }
                }
            }
            ArrayList<Runnable> arrayList = tasks;
            return arrayList;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexScanRunnableCollectorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldCollect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectScanRootRunnables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$collectScanRootRunnables$4";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$collectScanRootRunnables$3";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$collectScanRootRunnables$2";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$collectScanRootRunnables$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

