/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomAnchorImpl<T extends DomElement>
implements DomAnchor<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.DomAnchorImpl");

    public static <T extends DomElement> DomAnchor<T> createAnchor(@NotNull T t) {
        if (t == null) {
            DomAnchorImpl.$$$reportNull$$$0(0);
        }
        return DomAnchorImpl.createAnchor(t, true);
    }

    public static <T extends DomElement> DomAnchor<T> createAnchor(@NotNull T t, boolean usePsi) {
        int index;
        XmlElement element;
        DomInvocationHandler handler2;
        if (t == null) {
            DomAnchorImpl.$$$reportNull$$$0(1);
        }
        if ((handler2 = DomManagerImpl.getNotNullHandler(t)).getStub() != null) {
            return new StubAnchor(handler2);
        }
        if (usePsi && (element = t.getXmlElement()) != null) {
            return new PsiBasedDomAnchor(PsiAnchor.create((PsiElement)element), element.getProject());
        }
        DomElement parent = t.getParent();
        if (parent == null) {
            LOG.error("Parent null: " + t);
        }
        if (parent instanceof DomFileElementImpl) {
            DomFileElementImpl fileElement = (DomFileElementImpl)parent;
            return new RootAnchor(fileElement.getFile(), fileElement.getRootElementClass());
        }
        DomAnchor<DomElement> parentAnchor = DomAnchorImpl.createAnchor(parent);
        String name = t.getGenericInfo().getElementName(t);
        AbstractDomChildrenDescription description = t.getChildDescription();
        List values = description.getValues(parent);
        if (name != null) {
            int i = 0;
            for (DomElement value : values) {
                if (value.equals(t)) {
                    return new NamedAnchor(parentAnchor, description, name, i);
                }
                if (!name.equals(value.getGenericInfo().getElementName(value))) continue;
                ++i;
            }
        }
        if ((index = values.indexOf(t)) < 0) {
            DomAnchorImpl.diagnoseNegativeIndex2(t, parent, description, values);
        }
        return new IndexedAnchor(parentAnchor, description, index);
    }

    private static <T extends DomElement> void diagnoseNegativeIndex2(T t, DomElement parent, AbstractDomChildrenDescription description, List<? extends DomElement> values) {
        XmlTag parentTag = parent.getXmlTag();
        StringBuilder diag = new StringBuilder("Index<0: description=" + description + "\nparent=" + parent + "\nt=" + t + "\nvalues=" + values + "\n");
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            DomElement value = values.get(i);
            if (!value.toString().equals(t.toString())) continue;
            XmlElement tElement = t.getXmlElement();
            XmlElement valElement = value.getXmlElement();
            diag.append(" hasSame, i=" + i + "; same=" + (value == t) + ", equal=" + value.equals(t) + ", equal2=" + t.equals(value) + ", t.physical=" + (tElement == null ? "null" : String.valueOf(tElement.isPhysical())) + ", value.physical=" + (valElement == null ? "null" : String.valueOf(valElement.isPhysical())) + ", sameElements=" + (tElement == value.getXmlElement()) + "\n");
            if (tElement == null || valElement == null) continue;
            diag.append("  sameFile=" + (tElement.getContainingFile() == valElement.getContainingFile()) + ", sameParent=" + (tElement.getParent() == valElement.getParent()) + "\n");
        }
        if (parentTag != null) {
            diag.append("Parent tag: ").append(parentTag.getName()).append("\n");
            if (t instanceof GenericAttributeValue) {
                for (XmlAttribute attribute : parentTag.getAttributes()) {
                    diag.append(", attr: ").append(attribute.getName());
                }
                diag.append("\n");
            } else {
                for (XmlTag tag : parentTag.getSubTags()) {
                    diag.append("\n subtag: ").append(tag.getName());
                }
                diag.append("\n");
            }
        }
        diag.append("Child name: ").append(t.getXmlElementName()).append(";").append(t.getXmlElementNamespaceKey());
        LOG.error((Object)diag);
    }

    public PsiElement getPsiElement() {
        T t = this.retrieveDomElement();
        return t == null ? null : t.getXmlElement();
    }

    @Nullable
    public abstract T retrieveDomElement();

    @NotNull
    public abstract XmlFile getContainingFile();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/xml/impl/DomAnchorImpl", "createAnchor"));
    }

    private static class StubAnchor<T extends DomElement>
    implements DomAnchor<T> {
        private final DomInvocationHandler myHandler;

        private StubAnchor(DomInvocationHandler handler2) {
            this.myHandler = handler2;
        }

        @Nullable
        public T retrieveDomElement() {
            return (T)this.myHandler.getProxy();
        }

        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = this.myHandler.getFile();
            if (xmlFile == null) {
                StubAnchor.$$$reportNull$$$0(0);
            }
            return xmlFile;
        }

        @Nullable
        public PsiElement getPsiElement() {
            return this.myHandler.getXmlElement();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StubAnchor anchor = (StubAnchor)o;
            return !(this.myHandler != null ? !this.myHandler.equals((Object)anchor.myHandler) : anchor.myHandler != null);
        }

        public int hashCode() {
            return this.myHandler != null ? this.myHandler.hashCode() : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomAnchorImpl$StubAnchor", "getContainingFile"));
        }
    }

    private static class PsiBasedDomAnchor<T extends DomElement>
    extends DomAnchorImpl<T> {
        private final PsiAnchor myAnchor;
        private final Project myProject;

        public PsiBasedDomAnchor(PsiAnchor anchor, Project project) {
            this.myAnchor = anchor;
            this.myProject = project;
        }

        @Override
        public T retrieveDomElement() {
            PsiElement psi = this.myAnchor.retrieve();
            if (psi == null) {
                return null;
            }
            if (psi instanceof XmlTag) {
                return (T)DomManager.getDomManager((Project)this.myProject).getDomElement((XmlTag)psi);
            }
            if (psi instanceof XmlAttribute) {
                return (T)DomManager.getDomManager((Project)this.myProject).getDomElement((XmlAttribute)psi);
            }
            return null;
        }

        @Override
        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = (XmlFile)this.myAnchor.getFile();
            if (xmlFile == null) {
                PsiBasedDomAnchor.$$$reportNull$$$0(0);
            }
            return xmlFile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PsiBasedDomAnchor anchor = (PsiBasedDomAnchor)o;
            if (this.myAnchor != null ? !this.myAnchor.equals(anchor.myAnchor) : anchor.myAnchor != null) {
                return false;
            }
            return !(this.myProject != null ? !this.myProject.equals(anchor.myProject) : anchor.myProject != null);
        }

        public int hashCode() {
            int result2 = this.myAnchor != null ? this.myAnchor.hashCode() : 0;
            result2 = 31 * result2 + (this.myProject != null ? this.myProject.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomAnchorImpl$PsiBasedDomAnchor", "getContainingFile"));
        }
    }

    private static class RootAnchor<T extends DomElement>
    extends DomAnchorImpl<T> {
        private final XmlFile myFile;
        private final Class<T> myClass;

        private RootAnchor(XmlFile file2, Class<T> aClass) {
            this.myFile = file2;
            this.myClass = aClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RootAnchor)) {
                return false;
            }
            RootAnchor that = (RootAnchor)o;
            if (this.myClass != null ? !this.myClass.equals(that.myClass) : that.myClass != null) {
                return false;
            }
            return !(this.myFile != null ? !this.myFile.equals(that.myFile) : that.myFile != null);
        }

        public int hashCode() {
            int result2 = this.myFile != null ? this.myFile.hashCode() : 0;
            result2 = 31 * result2 + (this.myClass != null ? this.myClass.hashCode() : 0);
            return result2;
        }

        @Override
        public T retrieveDomElement() {
            DomFileElement fileElement = DomManager.getDomManager((Project)this.myFile.getProject()).getFileElement(this.myFile, this.myClass);
            return (T)(fileElement == null ? null : fileElement.getRootElement());
        }

        @Override
        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = this.myFile;
            if (xmlFile == null) {
                RootAnchor.$$$reportNull$$$0(0);
            }
            return xmlFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomAnchorImpl$RootAnchor", "getContainingFile"));
        }
    }

    private static class IndexedAnchor<T extends DomElement>
    extends DomAnchorImpl<T> {
        private final DomAnchor myParent;
        private final AbstractDomChildrenDescription myDescr;
        private final int myIndex;

        private IndexedAnchor(DomAnchor parent, AbstractDomChildrenDescription descr, int index) {
            this.myParent = parent;
            this.myDescr = descr;
            this.myIndex = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexedAnchor)) {
                return false;
            }
            IndexedAnchor that = (IndexedAnchor)o;
            if (this.myIndex != that.myIndex) {
                return false;
            }
            if (this.myDescr != null ? !this.myDescr.equals(that.myDescr) : that.myDescr != null) {
                return false;
            }
            return !(this.myParent != null ? !this.myParent.equals(that.myParent) : that.myParent != null);
        }

        public int hashCode() {
            int result2 = this.myParent != null ? this.myParent.hashCode() : 0;
            result2 = 31 * result2 + (this.myDescr != null ? this.myDescr.hashCode() : 0);
            result2 = 31 * result2 + this.myIndex;
            return result2;
        }

        @Override
        public T retrieveDomElement() {
            DomElement parent = this.myParent.retrieveDomElement();
            if (parent == null) {
                return null;
            }
            List list2 = this.myDescr.getValues(parent);
            if (this.myIndex < 0 || this.myIndex >= list2.size()) {
                return null;
            }
            return (T)((DomElement)list2.get(this.myIndex));
        }

        @Override
        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = this.myParent.getContainingFile();
            if (xmlFile == null) {
                IndexedAnchor.$$$reportNull$$$0(0);
            }
            return xmlFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomAnchorImpl$IndexedAnchor", "getContainingFile"));
        }
    }

    private static class NamedAnchor<T extends DomElement>
    extends DomAnchorImpl<T> {
        private final DomAnchor myParent;
        private final AbstractDomChildrenDescription myDescr;
        private final String myName;
        private final int myIndex;

        private NamedAnchor(DomAnchor parent, AbstractDomChildrenDescription descr, String id, int index) {
            this.myParent = parent;
            this.myDescr = descr;
            this.myName = id;
            this.myIndex = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NamedAnchor)) {
                return false;
            }
            NamedAnchor that = (NamedAnchor)o;
            if (this.myDescr != null ? !this.myDescr.equals(that.myDescr) : that.myDescr != null) {
                return false;
            }
            if (this.myName != null ? !this.myName.equals(that.myName) : that.myName != null) {
                return false;
            }
            if (this.myParent != null ? !this.myParent.equals(that.myParent) : that.myParent != null) {
                return false;
            }
            return this.myIndex == that.myIndex;
        }

        public int hashCode() {
            int result2 = this.myParent != null ? this.myParent.hashCode() : 0;
            result2 = 31 * result2 + (this.myDescr != null ? this.myDescr.hashCode() : 0);
            result2 = 31 * result2 + (this.myName != null ? this.myName.hashCode() : 0);
            result2 = 31 * result2 + this.myIndex;
            return result2;
        }

        @Override
        public T retrieveDomElement() {
            DomElement parent = this.myParent.retrieveDomElement();
            if (parent == null) {
                return null;
            }
            List list2 = this.myDescr.getValues(parent);
            int i = 0;
            for (DomElement element : list2) {
                String s = element.getGenericInfo().getElementName(element);
                if (!this.myName.equals(s)) continue;
                if (i == this.myIndex) {
                    return (T)element;
                }
                ++i;
            }
            return null;
        }

        @Override
        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = this.myParent.getContainingFile();
            if (xmlFile == null) {
                NamedAnchor.$$$reportNull$$$0(0);
            }
            return xmlFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomAnchorImpl$NamedAnchor", "getContainingFile"));
        }
    }
}

