/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.FullIntList;
import com.intellij.vcs.log.graph.utils.impl.SmartDeltaCompressor;
import org.jetbrains.annotations.NotNull;

public class CompressedIntList
implements IntList {
    public static final int DEFAULT_BLOCK_SIZE = 30;
    private final int myBlockSize;
    @NotNull
    private final int[] myStrongValues;
    @NotNull
    private final IntList myCompressedDeltas;

    @NotNull
    public static IntList newInstance(int[] delegateArray) {
        IntList intList = CompressedIntList.newInstance(delegateArray, 30);
        if (intList == null) {
            CompressedIntList.$$$reportNull$$$0(0);
        }
        return intList;
    }

    @NotNull
    public static IntList newInstance(final int[] delegateArray, int blockSize) {
        IntList intList = CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return delegateArray.length;
            }

            @Override
            public int get(int index) {
                return delegateArray[index];
            }
        }, blockSize);
        if (intList == null) {
            CompressedIntList.$$$reportNull$$$0(1);
        }
        return intList;
    }

    @NotNull
    public static IntList newInstance(final IntList delegateList, final int blockSize) {
        if (blockSize < 1) {
            throw new IllegalArgumentException("Unsupported blockSize:" + blockSize);
        }
        if (delegateList.size() == 0) {
            FullIntList fullIntList = new FullIntList(new int[0]);
            if (fullIntList == null) {
                CompressedIntList.$$$reportNull$$$0(2);
            }
            return fullIntList;
        }
        SmartDeltaCompressor intDeltaCompressor = SmartDeltaCompressor.newInstance(new IntList(){

            @Override
            public int size() {
                return delegateList.size();
            }

            @Override
            public int get(int index) {
                return delegateList.get(index) - delegateList.get(index - index % blockSize);
            }
        });
        int[] strongValues = new int[(delegateList.size() - 1) / blockSize + 1];
        for (int i = 0; i < strongValues.length; ++i) {
            strongValues[i] = delegateList.get(i * blockSize);
        }
        CompressedIntList compressedIntList = new CompressedIntList(blockSize, strongValues, intDeltaCompressor);
        if (compressedIntList == null) {
            CompressedIntList.$$$reportNull$$$0(3);
        }
        return compressedIntList;
    }

    private CompressedIntList(int blockSize, @NotNull int[] strongValues, @NotNull IntList compressedDeltas) {
        if (strongValues == null) {
            CompressedIntList.$$$reportNull$$$0(4);
        }
        if (compressedDeltas == null) {
            CompressedIntList.$$$reportNull$$$0(5);
        }
        this.myBlockSize = blockSize;
        this.myStrongValues = strongValues;
        this.myCompressedDeltas = compressedDeltas;
    }

    @Override
    public int size() {
        return this.myCompressedDeltas.size();
    }

    @Override
    public int get(int index) {
        int strongIndex = index / this.myBlockSize;
        return this.myStrongValues[strongIndex] + this.myCompressedDeltas.get(index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/utils/impl/CompressedIntList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strongValues";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compressedDeltas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/utils/impl/CompressedIntList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

