/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.SimpleGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SnapshotVisiblePackBuilder {
    @NotNull
    private final VcsLogStorage myStorage;

    public SnapshotVisiblePackBuilder(@NotNull VcsLogStorage storage2) {
        if (storage2 == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(0);
        }
        this.myStorage = storage2;
    }

    @NotNull
    public VisiblePack build(@NotNull VisiblePack visiblePack) {
        if (visiblePack == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(1);
        }
        if (visiblePack.getVisibleGraph() instanceof VisibleGraphImpl && visiblePack.getVisibleGraph().getVisibleCommitCount() > 0) {
            VisiblePack visiblePack2 = this.build(visiblePack.getDataPack(), (VisibleGraphImpl)visiblePack.getVisibleGraph(), visiblePack.getFilters());
            if (visiblePack2 == null) {
                SnapshotVisiblePackBuilder.$$$reportNull$$$0(2);
            }
            return visiblePack2;
        }
        VisibleGraph<Integer> newGraph = EmptyVisibleGraph.getInstance();
        DataPackBase newPack = new DataPackBase(visiblePack.getDataPack().getLogProviders(), this.createEmptyRefsModel(), false);
        VisiblePack visiblePack3 = new VisiblePack(newPack, newGraph, true, visiblePack.getFilters());
        if (visiblePack3 == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(3);
        }
        return visiblePack3;
    }

    @NotNull
    private VisiblePack build(@NotNull DataPackBase oldPack, @NotNull VisibleGraphImpl<Integer> oldGraph, @NotNull VcsLogFilterCollection filters) {
        if (oldPack == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(4);
        }
        if (oldGraph == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(5);
        }
        if (filters == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(6);
        }
        SimpleGraphInfo<Integer> info = oldGraph.buildSimpleGraphInfo();
        Set heads = ContainerUtil.map2Set(info.getPermanentGraphLayout().getHeadNodeIndex(), integer -> (Integer)info.getPermanentCommitsInfo().getCommitId((int)integer));
        RefsModel newRefsModel = this.createRefsModel(oldPack.getRefsModel(), heads, oldGraph, oldPack.getLogProviders());
        DataPackBase newPack = new DataPackBase(oldPack.getLogProviders(), newRefsModel, false);
        GraphColorManagerImpl colorManager = new GraphColorManagerImpl(newRefsModel, VcsLogStorageImpl.createHashGetter(this.myStorage), DataPack.getRefManagerMap(oldPack.getLogProviders()));
        VisibleGraphImpl<Integer> newGraph = new VisibleGraphImpl<Integer>(new CollapsedController(new BaseController(info), info, null), info, colorManager);
        VisiblePack visiblePack = new VisiblePack(newPack, newGraph, true, filters);
        if (visiblePack == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(7);
        }
        return visiblePack;
    }

    @NotNull
    private RefsModel createEmptyRefsModel() {
        RefsModel refsModel = new RefsModel(ContainerUtil.newHashMap(), ContainerUtil.newHashSet(), this.myStorage, ContainerUtil.newHashMap());
        if (refsModel == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(8);
        }
        return refsModel;
    }

    private RefsModel createRefsModel(@NotNull RefsModel refsModel, @NotNull Set<Integer> heads, @NotNull VisibleGraph<Integer> visibleGraph, @NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (refsModel == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(9);
        }
        if (heads == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(10);
        }
        if (visibleGraph == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(11);
        }
        if (providers == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(12);
        }
        HashSet branchesAndHeads = ContainerUtil.newHashSet();
        refsModel.getBranches().stream().filter(ref -> {
            int index;
            Integer row;
            if (visibleGraph == null) {
                SnapshotVisiblePackBuilder.$$$reportNull$$$0(14);
            }
            return (row = visibleGraph.getVisibleRowIndex((Object)(index = this.myStorage.getCommitIndex(ref.getCommitHash(), ref.getRoot())))) != null && row >= 0;
        }).forEach(branchesAndHeads::add);
        heads.stream().flatMap(head -> {
            if (refsModel == null) {
                SnapshotVisiblePackBuilder.$$$reportNull$$$0(13);
            }
            return refsModel.refsToCommit((int)head).stream();
        }).forEach(branchesAndHeads::add);
        Map<VirtualFile, Set<VcsRef>> map2 = VcsLogUtil.groupRefsByRoot(branchesAndHeads);
        HashMap refs = ContainerUtil.newHashMap();
        Iterator<VirtualFile> iterator = providers.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile root;
            Set<VcsRef> refsForRoot = map2.get(root = iterator.next());
            refs.put(root, new CompressedRefs((Set<VcsRef>)(refsForRoot == null ? ContainerUtil.newHashSet() : refsForRoot), this.myStorage));
        }
        return new RefsModel(refs, heads, this.myStorage, providers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPack";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldGraph";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heads";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleGraph";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyRefsModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRefsModel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRefsModel$2";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRefsModel$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

