/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NonNls;

public class FileUtils {
    @NonNls
    public static final String CLASS_RESOURCE_STRING = "*?.class";
    @NonNls
    private static final String SOAP_ADDRESS = "soap:address";

    private FileUtils() {
    }

    public static File saveStreamContentAsFile(String fullFileName, InputStream stream) throws IOException {
        int read2;
        fullFileName = FileUtils.findFreeFileName(fullFileName);
        FileOutputStream ostream = new FileOutputStream(fullFileName);
        byte[] buf = new byte[8192];
        while ((read2 = stream.read(buf, 0, buf.length)) != -1) {
            ((OutputStream)ostream).write(buf, 0, read2);
        }
        ostream.flush();
        ((OutputStream)ostream).close();
        return new File(fullFileName);
    }

    private static String findFreeFileName(String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            return filename;
        }
        int dot = filename.lastIndexOf(46);
        String name = filename.substring(0, dot);
        String ext = filename.substring(dot);
        int num = 0;
        while ((f = new File(name + ++num + ext)).exists()) {
        }
        return name + num + ext;
    }

    public static boolean copyFile(File in, File out) {
        try {
            int i;
            FileInputStream fis = new FileInputStream(in);
            FileOutputStream fos = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            fis.close();
            fos.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

