/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.Nullable;

public enum ResourceRelevance {
    STANDARD,
    LIBRARY,
    SOURCE,
    MAPPED;


    public static ResourceRelevance getRelevance(VirtualFile resource, @Nullable Module module2, ProjectFileIndex fileIndex, @Nullable GlobalSearchScope additionalScope) {
        ExternalResourceManagerEx resourceManager;
        boolean inTest = fileIndex.isInTestSourceContent(resource);
        if (module2 != null) {
            GlobalSearchScope scope = module2.getModuleRuntimeScope(inTest);
            Module resourceModule = fileIndex.getModuleForFile(resource);
            if (resourceModule != null && (resourceModule == module2 || scope.isSearchInModuleContent(resourceModule)) || scope.contains(resource) || additionalScope != null && additionalScope.contains(resource)) {
                return inTest || fileIndex.isInSource(resource) ? SOURCE : LIBRARY;
            }
        } else {
            if (inTest || fileIndex.isInSource(resource)) {
                return SOURCE;
            }
            if (fileIndex.isInLibraryClasses(resource)) {
                return LIBRARY;
            }
        }
        return (resourceManager = (ExternalResourceManagerEx)ExternalResourceManager.getInstance()).isUserResource(resource) ? MAPPED : STANDARD;
    }
}

