/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.ui.EmptyIcon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ColorIconCache {
    private static final ColorIconCache INSTANCE = new ColorIconCache();
    private static final SoftFactoryMap<Color, Map<Integer, Icon>> ourCache = new SoftFactoryMap<Color, Map<Integer, Icon>>(){

        protected Map<Integer, Icon> create(Color key) {
            return new HashMap();
        }
    };

    private ColorIconCache() {
    }

    public static ColorIconCache getIconCache() {
        return INSTANCE;
    }

    public Icon getIcon(@NotNull Color color, int size) {
        if (color == null) {
            ColorIconCache.$$$reportNull$$$0(0);
        }
        return ((Map)ourCache.get((Object)color)).computeIfAbsent(size, s -> {
            if (color == null) {
                ColorIconCache.$$$reportNull$$$0(1);
            }
            return new ColorIcon((int)s, color);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "color";
        objectArray2[1] = "com/intellij/xml/util/ColorIconCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getIcon$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ColorIcon
    extends EmptyIcon {
        private Color myColor;
        private Color[] myColours;

        public ColorIcon(int size, Color color) {
            super(size);
            this.myColor = color;
        }

        public ColorIcon(int size, Color[] colours) {
            super(size);
            this.myColours = colours;
        }

        protected ColorIcon(ColorIcon icon) {
            super((EmptyIcon)icon);
            this.myColor = icon.myColor;
            if (icon.myColours != null) {
                this.myColours = Arrays.copyOf(icon.myColours, icon.myColours.length);
            }
        }

        @NotNull
        protected ColorIcon copy() {
            ColorIcon colorIcon = new ColorIcon(this);
            if (colorIcon == null) {
                ColorIcon.$$$reportNull$$$0(0);
            }
            return colorIcon;
        }

        public void paintIcon(Component component, Graphics g, int i, int j) {
            int iconWidth = this.getIconWidth();
            int iconHeight = this.getIconHeight();
            if (this.myColor != null) {
                g.setColor(this.myColor);
                g.fillRect(i, j, iconWidth, iconHeight);
            } else if (this.myColours != null) {
                Color top = this.myColours[0];
                g.setColor(top);
                g.fillRect(i, j, iconWidth, 2);
                Color right = this.myColours[1];
                g.setColor(right);
                g.fillRect(i + iconWidth / 2, j + 2, iconWidth / 2, iconHeight / 2);
                Color bottom = this.myColours[2];
                g.setColor(bottom);
                g.fillRect(i, j + iconHeight - 2, iconWidth, 2);
                Color left = this.myColours[3];
                g.setColor(left);
                g.fillRect(i, j + 2, iconWidth / 2, iconHeight / 2);
            }
            Composite old = ((Graphics2D)g).getComposite();
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.1f));
            g.setColor(Color.BLACK);
            g.drawRect(i, j, iconWidth - 1, iconHeight - 1);
            ((Graphics2D)g).setComposite(old);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/ColorIconCache$ColorIcon", "copy"));
        }
    }
}

