/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.PyUnindentingInsertHandler;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.Nullable;

public class PyKeywordTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result beforeCharTyped(char character, Project project, Editor editor, PsiFile file2, FileType fileType) {
        if (!(fileType instanceof PythonFileType)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (character == ':') {
            TypedHandlerDelegate.Result res = this.getOverTypeResult(editor, file2);
            if (res == TypedHandlerDelegate.Result.STOP) {
                return res;
            }
            PyUnindentingInsertHandler.unindentAsNeeded(project, editor, file2);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @Nullable
    public TypedHandlerDelegate.Result getOverTypeResult(Editor editor, PsiFile file2) {
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        PsiElement token = file2.findElementAt(offset - 1);
        if (token == null || offset >= document.getTextLength()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiElement here_elt = file2.findElementAt(offset);
        if (here_elt == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (here_elt instanceof PyStringLiteralExpression || here_elt.getParent() instanceof PyStringLiteralExpression) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        String here_text = here_elt.getText();
        if (":".equals(here_text)) {
            editor.getCaretModel().moveToOffset(offset + 1);
            return TypedHandlerDelegate.Result.STOP;
        }
        return null;
    }
}

