/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Processor;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.imports.AutoImportQuickFix;
import com.jetbrains.python.codeInsight.imports.ImportFromExistingAction;
import com.jetbrains.python.codeInsight.imports.PyImportCandidateProvider;
import com.jetbrains.python.inspections.unresolvedReference.PyPackageAliasesProvider;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonImportUtils {
    private PythonImportUtils() {
    }

    @Nullable
    public static AutoImportQuickFix proposeImportFix(PyElement node, PsiReference reference) {
        String text = reference.getElement().getText();
        String refText = reference.getRangeInElement().substring(text);
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
        if (module2 != null && PythonSdkType.findPythonSdk(module2) == null) {
            return null;
        }
        ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)node, ScopeOwner.class);
        if (scopeOwner != null && ControlFlowCache.getScope(scopeOwner).containsDeclaration(refText)) {
            return null;
        }
        AutoImportQuickFix fix = PythonImportUtils.addCandidates(node, reference, refText, null);
        if (fix != null) {
            return fix;
        }
        String packageName = PyPackageAliasesProvider.commonImportAliases.get(refText);
        if (packageName != null && (fix = PythonImportUtils.addCandidates(node, reference, packageName, refText)) != null) {
            return fix;
        }
        return null;
    }

    @Nullable
    private static AutoImportQuickFix addCandidates(PyElement node, PsiReference reference, String refText, @Nullable String asName) {
        boolean qualify = !PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT;
        AutoImportQuickFix fix = new AutoImportQuickFix((PsiElement)node, reference.getClass(), refText, qualify);
        HashSet<String> seenCandidateNames = new HashSet<String>();
        PsiFile existingImportFile = PythonImportUtils.addCandidatesFromExistingImports(node, refText, fix, seenCandidateNames);
        if (fix.getCandidates().isEmpty() || fix.hasProjectImports() || Registry.is((String)"python.import.always.ask")) {
            ProgressManager.checkCanceled();
            PythonImportUtils.addSymbolImportCandidates(node, refText, asName, fix, seenCandidateNames, existingImportFile);
        }
        for (PyImportCandidateProvider provider : (PyImportCandidateProvider[])Extensions.getExtensions(PyImportCandidateProvider.EP_NAME)) {
            provider.addImportCandidates(reference, refText, fix);
        }
        if (!fix.getCandidates().isEmpty()) {
            fix.sortCandidates();
            return fix;
        }
        return null;
    }

    @Nullable
    private static PsiFile addCandidatesFromExistingImports(PyElement node, String refText, AutoImportQuickFix fix, Set<String> seenCandidateNames) {
        PsiFile existingImportFile = null;
        PsiFile file2 = node.getContainingFile();
        if (file2 instanceof PyFile) {
            PyFile pyFile = (PyFile)file2;
            for (PyImportElement importElement : pyFile.getImportTargets()) {
                existingImportFile = PythonImportUtils.addImportViaElement(refText, fix, seenCandidateNames, existingImportFile, importElement, importElement.resolve());
            }
            for (PyFromImportStatement fromImportStatement : pyFile.getFromImports()) {
                if (fromImportStatement.isStarImport() || fromImportStatement.getImportElements().length <= 0) continue;
                PsiFileSystemItem source = fromImportStatement.resolveImportSource();
                existingImportFile = PythonImportUtils.addImportViaElement(refText, fix, seenCandidateNames, existingImportFile, fromImportStatement.getImportElements()[0], (PsiElement)source);
            }
        }
        return existingImportFile;
    }

    private static PsiFile addImportViaElement(String refText, AutoImportQuickFix fix, Set<String> seenCandidateNames, PsiFile existingImportFile, PyImportElement importElement, PsiElement source) {
        PyFile sourceFile = PyUtil.as(PyUtil.turnDirIntoInit(source), PyFile.class);
        if (sourceFile instanceof PyFileImpl) {
            String name;
            PsiElement res = sourceFile.findExportedName(refText);
            String string = name = res instanceof PyQualifiedNameOwner ? ((PyQualifiedNameOwner)res).getQualifiedName() : null;
            if (name != null && seenCandidateNames.contains(name)) {
                return existingImportFile;
            }
            if (res != null && !(res instanceof PyFile) && !(res instanceof PyImportElement) && res.getContainingFile() != null && PsiTreeUtil.isAncestor((PsiElement)source, (PsiElement)res.getContainingFile(), (boolean)false)) {
                existingImportFile = sourceFile;
                fix.addImport(res, sourceFile, importElement);
                if (name != null) {
                    seenCandidateNames.add(name);
                }
            }
        }
        return existingImportFile;
    }

    private static void addSymbolImportCandidates(PyElement node, String refText, @Nullable String asName, AutoImportQuickFix fix, Set<String> seenCandidateNames, PsiFile existingImportFile) {
        Project project = node.getProject();
        ArrayList<PyClass> symbols = new ArrayList<PyClass>(PyClassNameIndex.find(refText, project, true));
        GlobalSearchScope scope = PyProjectScopeBuilder.excludeSdkTestsScope((PsiElement)node);
        if (!PythonImportUtils.isQualifier(node)) {
            symbols.addAll(PyFunctionNameIndex.find(refText, project, scope));
        }
        symbols.addAll(PyVariableNameIndex.find(refText, project, scope));
        if (PythonImportUtils.isPossibleModuleReference(node)) {
            symbols.addAll(PythonImportUtils.findImportableModules(node.getContainingFile(), refText, project, scope));
        }
        if (!symbols.isEmpty()) {
            for (PsiElement psiElement : symbols) {
                String symbolImportQName;
                QualifiedName importPath;
                PsiFile srcfile;
                if (!PythonImportUtils.isIndexableTopLevel(psiElement) || (srcfile = psiElement instanceof PsiFileSystemItem ? ((PsiFileSystemItem)psiElement).getParent() : psiElement.getContainingFile()) == null || !PythonImportUtils.isAcceptableForImport(node, existingImportFile, (PsiFileSystemItem)srcfile) || (importPath = QualifiedNameFinder.findCanonicalImportPath(psiElement, (PsiElement)node)) == null) continue;
                if (psiElement instanceof PsiFileSystemItem) {
                    importPath = importPath.removeTail(1);
                }
                if (seenCandidateNames.contains(symbolImportQName = importPath.append(refText).toString())) continue;
                fix.addImport(psiElement, (PsiFileSystemItem)srcfile, importPath, asName);
                seenCandidateNames.add(symbolImportQName);
            }
        }
    }

    private static boolean isAcceptableForImport(PyElement node, PsiFile existingImportFile, PsiFileSystemItem srcfile) {
        return srcfile != existingImportFile && srcfile != node.getContainingFile() && (ImportFromExistingAction.isRoot(srcfile) || PyNames.isIdentifier(FileUtil.getNameWithoutExtension((String)srcfile.getName()))) && !PythonImportUtils.isShadowedModule(srcfile);
    }

    private static boolean isShadowedModule(PsiFileSystemItem file2) {
        if (file2.isDirectory() || file2.getName().equals("__init__.py")) {
            return false;
        }
        String name = FileUtil.getNameWithoutExtension((String)file2.getName());
        PsiDirectory directory2 = ((PsiFile)file2).getContainingDirectory();
        if (directory2 == null) {
            return false;
        }
        PsiDirectory packageDir = directory2.findSubdirectory(name);
        return packageDir != null && packageDir.findFile("__init__.py") != null;
    }

    private static boolean isQualifier(PyElement node) {
        return node.getParent() instanceof PyReferenceExpression && node == ((PyReferenceExpression)node.getParent()).getQualifier();
    }

    private static boolean isPossibleModuleReference(PyElement node) {
        PyClass pyClass;
        PyArgumentList argumentList;
        if (node.getParent() instanceof PyCallExpression && node == ((PyCallExpression)node.getParent()).getCallee()) {
            return false;
        }
        return !(node.getParent() instanceof PyArgumentList) || !((argumentList = (PyArgumentList)node.getParent()).getParent() instanceof PyClass) || (pyClass = (PyClass)argumentList.getParent()).getSuperClassExpressionList() != argumentList;
    }

    private static Collection<PsiElement> findImportableModules(PsiFile targetFile, String refText, Project project, GlobalSearchScope scope) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        FilenameIndex.processFilesByName(refText, true, (Processor<? super PsiFileSystemItem>)((Processor)item -> {
            ProgressManager.checkCanceled();
            PsiDirectory candidatePackageDir = PyUtil.as(item, PsiDirectory.class);
            if (candidatePackageDir != null && candidatePackageDir.findFile("__init__.py") != null) {
                result2.add((PsiElement)candidatePackageDir);
            }
            return true;
        }), scope, project, null);
        FilenameIndex.processFilesByName(refText + ".py", false, true, (Processor<? super PsiFileSystemItem>)((Processor)item -> {
            ProgressManager.checkCanceled();
            if (PythonImportUtils.isImportableModule(targetFile, item)) {
                result2.add((PsiElement)item);
            }
            return true;
        }), scope, project, null);
        return result2;
    }

    public static boolean isImportableModule(PsiFile targetFile, @NotNull PsiFileSystemItem file2) {
        PsiDirectory parent;
        if (file2 == null) {
            PythonImportUtils.$$$reportNull$$$0(0);
        }
        return (parent = (PsiDirectory)file2.getParent()) != null && file2 != targetFile && (parent.findFile("__init__.py") != null || ImportFromExistingAction.isRoot((PsiFileSystemItem)parent) || parent == targetFile.getParent());
    }

    private static boolean isIndexableTopLevel(PsiElement symbol) {
        if (symbol instanceof PsiFileSystemItem) {
            return true;
        }
        if (symbol instanceof PyClass || symbol instanceof PyFunction) {
            return PyUtil.isTopLevel(symbol);
        }
        return symbol instanceof PyTargetExpression;
    }

    public static boolean isImportable(PsiElement ref_element) {
        PyStatement parentStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)ref_element, PyStatement.class);
        if (parentStatement instanceof PyGlobalStatement || parentStatement instanceof PyNonlocalStatement || parentStatement instanceof PyImportStatementBase) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)ref_element, PyStringLiteralExpression.class, (boolean)false, (Class[])new Class[]{PyStatement.class}) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/imports/PythonImportUtils", "isImportableModule"));
    }
}

