/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.ArrayChunkBuilder;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class AsyncArrayTableModel
extends AbstractTableModel {
    private static final int CHUNK_COL_SIZE = 30;
    private static final int CHUNK_ROW_SIZE = 30;
    public static final String EMPTY_CELL_VALUE = "";
    private int myRows;
    private int myColumns;
    private final PyDataViewerPanel myDataProvider;
    private final ExecutorService myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)"Python async table");
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("Python async table queue", 100, true, null);
    private PyDebugValue myDebugValue;
    private final DataViewStrategy myStrategy;
    private LoadingCache<Pair<Integer, Integer>, ListenableFuture<ArrayChunk>> myChunkCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Pair<Integer, Integer>, ListenableFuture<ArrayChunk>>(){

        public ListenableFuture<ArrayChunk> load(@NotNull Pair<Integer, Integer> key) throws Exception {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            return ListenableFutureTask.create(() -> {
                if (key == null) {
                    1.$$$reportNull$$$0(1);
                }
                ArrayChunk chunk = AsyncArrayTableModel.this.myDebugValue.getFrameAccessor().getArrayItems(AsyncArrayTableModel.this.myDebugValue, ((Integer)key.first).intValue(), ((Integer)key.second).intValue(), Math.min(30, AsyncArrayTableModel.this.getRowCount() - (Integer)key.first), Math.min(30, AsyncArrayTableModel.this.getColumnCount() - (Integer)key.second), AsyncArrayTableModel.this.myDataProvider.getFormat());
                AsyncArrayTableModel.this.handleChunkAdded((Integer)key.first, (Integer)key.second, chunk);
                return chunk;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "key";
            objectArray2[1] = "com/jetbrains/python/debugger/array/AsyncArrayTableModel$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$load$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    });

    public AsyncArrayTableModel(int rows, int columns, PyDataViewerPanel provider, PyDebugValue debugValue, DataViewStrategy strategy) {
        this.myRows = rows;
        this.myColumns = columns;
        this.myDataProvider = provider;
        this.myDebugValue = debugValue;
        this.myStrategy = strategy;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Pair<Integer, Integer> key = AsyncArrayTableModel.itemToChunkKey(row, col);
        try {
            final ListenableFuture chunk = (ListenableFuture)this.myChunkCache.get(key);
            if (chunk.isDone()) {
                Object[][] data = ((ArrayChunk)chunk.get()).getData();
                int r = row % 30;
                int c = col % 30;
                if (r < data.length && c < data[r].length) {
                    return this.correctStringValue(data[r][c]);
                }
            } else {
                this.myQueue.queue(new Update("get chunk from debugger"){

                    public void run() {
                        chunk.addListener(() -> UIUtil.invokeLaterIfNeeded(() -> AsyncArrayTableModel.this.fireTableDataChanged()), (Executor)AsyncArrayTableModel.this.myExecutorService);
                        AsyncArrayTableModel.this.myExecutorService.execute((Runnable)((ListenableFutureTask)chunk));
                    }
                });
            }
            return EMPTY_CELL_VALUE;
        }
        catch (Exception e) {
            return EMPTY_CELL_VALUE;
        }
    }

    public String correctStringValue(@NotNull Object value) {
        if (value == null) {
            AsyncArrayTableModel.$$$reportNull$$$0(0);
        }
        if (value instanceof String) {
            String corrected = (String)value;
            if (this.myStrategy.isNumeric(this.myDebugValue.getType()) && (corrected.startsWith("'") || corrected.startsWith("\""))) {
                corrected = corrected.substring(1, corrected.length() - 1);
            }
            return corrected;
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        return value.toString();
    }

    private static Pair<Integer, Integer> itemToChunkKey(int row, int col) {
        return Pair.create((Object)AsyncArrayTableModel.getPageRowStart(row), (Object)AsyncArrayTableModel.getPageColStart(col));
    }

    private static int getPageRowStart(int rowOffset) {
        return rowOffset - rowOffset % 30;
    }

    private static int getPageColStart(int colOffset) {
        return colOffset - colOffset % 30;
    }

    @Override
    public int getColumnCount() {
        return this.myColumns;
    }

    @Override
    public String getColumnName(int col) {
        return String.valueOf(col);
    }

    @Override
    public int getRowCount() {
        return this.myRows;
    }

    public void changeValue(int row, int col, Object value) {
        Future chunk = (Future)this.myChunkCache.getIfPresent(AsyncArrayTableModel.itemToChunkKey(row, col));
        if (chunk != null && chunk.isDone()) {
            try {
                ((ArrayChunk)chunk.get()).getData()[row - AsyncArrayTableModel.getPageRowStart((int)row)][col - AsyncArrayTableModel.getPageColStart((int)col)] = value;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            throw new IllegalArgumentException("Forced to change empty cell in " + row + " row and " + col + " column.");
        }
    }

    public void addToCache(final ArrayChunk chunk) {
        Object[][] data = chunk.getData();
        int rows = data.length;
        int cols = data[0].length;
        for (int roffset = 0; roffset < rows / 30; ++roffset) {
            for (int coffset = 0; coffset < cols / 30; ++coffset) {
                Pair<Integer, Integer> key = AsyncArrayTableModel.itemToChunkKey(roffset * 30, coffset * 30);
                final Object[][] chunkData = new Object[30][30];
                for (int r = 0; r < 30; ++r) {
                    System.arraycopy(data[roffset * 30 + r], coffset * 30, chunkData[r], 0, 30);
                }
                this.myChunkCache.put(key, (Object)new ListenableFuture<ArrayChunk>(){

                    public void addListener(@NotNull Runnable listener2, @NotNull Executor executor) {
                        if (listener2 == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (executor == null) {
                            3.$$$reportNull$$$0(1);
                        }
                    }

                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return false;
                    }

                    public boolean isCancelled() {
                        return false;
                    }

                    public boolean isDone() {
                        return true;
                    }

                    public ArrayChunk get() throws InterruptedException, ExecutionException {
                        return new ArrayChunkBuilder().setValue(chunk.getValue()).setSlicePresentation(null).setRows(0).setColumns(0).setMax(null).setMin(null).setFormat(null).setType(null).setData(chunkData).createArrayChunk();
                    }

                    public ArrayChunk get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return new ArrayChunkBuilder().setValue(chunk.getValue()).setSlicePresentation(null).setRows(0).setColumns(0).setMax(null).setMin(null).setFormat(null).setType(null).setData(chunkData).createArrayChunk();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "listener";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "executor";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/python/debugger/array/AsyncArrayTableModel$3";
                        objectArray[2] = "addListener";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
        this.handleChunkAdded(0, 0, chunk);
    }

    protected void handleChunkAdded(Integer rowOffset, Integer colOffset, ArrayChunk chunk) {
    }

    public TableModel getRowHeaderModel() {
        return new RowNumberHeaderModel();
    }

    public void invalidateCache() {
        this.myChunkCache.invalidateAll();
    }

    public PyDebugValue getDebugValue() {
        return this.myDebugValue;
    }

    public void setDebugValue(PyDebugValue debugValue) {
        this.myDebugValue = debugValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/python/debugger/array/AsyncArrayTableModel", "correctStringValue"));
    }

    private class RowNumberHeaderModel
    extends AbstractTableModel {
        private RowNumberHeaderModel() {
        }

        @Override
        public int getRowCount() {
            return AsyncArrayTableModel.this.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "   ";
            }
            throw new IllegalArgumentException("Table only has one column");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return Integer.toString(rowIndex);
        }
    }
}

