/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.setupPy;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.ListChooseByNameModel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.setupPy.SetupTask;
import com.jetbrains.python.packaging.setupPy.SetupTaskDialog;
import com.jetbrains.python.packaging.setupPy.SetupTaskIntrospector;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.run.PythonTask;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.List;

public class SetupTaskChooserAction
extends AnAction {
    public SetupTaskChooserAction() {
        super("Run setup.py Task...");
    }

    public void actionPerformed(AnActionEvent e) {
        final Module module2 = (Module)e.getData(LangDataKeys.MODULE);
        if (module2 == null) {
            return;
        }
        Project project = module2.getProject();
        ListChooseByNameModel<SetupTask> model = new ListChooseByNameModel<SetupTask>(project, "Enter setup.py task name", "No tasks found", SetupTaskIntrospector.getTaskList(module2));
        ChooseByNamePopup popup2 = ChooseByNamePopup.createPopup(project, model, GotoActionBase.getPsiContext(e));
        popup2.setShowListForEmptyPattern(true);
        popup2.invoke(new ChooseByNamePopupComponent.Callback(){

            public void onClose() {
            }

            public void elementChosen(Object element) {
                if (element != null) {
                    SetupTask task2 = (SetupTask)element;
                    ApplicationManager.getApplication().invokeLater(() -> SetupTaskChooserAction.runSetupTask(task2.getName(), module2), ModalityState.NON_MODAL);
                }
            }
        }, ModalityState.current(), false);
    }

    public void update(AnActionEvent e) {
        Module module2 = (Module)e.getData(LangDataKeys.MODULE);
        e.getPresentation().setEnabled(module2 != null && PyPackageUtil.hasSetupPy(module2) && PythonSdkType.findPythonSdk(module2) != null);
    }

    public static void runSetupTask(String taskName, Module module2) {
        List<SetupTask.Option> options = SetupTaskIntrospector.getSetupTaskOptions(module2, taskName);
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(taskName);
        if (options != null) {
            SetupTaskDialog dialog2 = new SetupTaskDialog(module2.getProject(), taskName, options);
            if (!dialog2.showAndGet()) {
                return;
            }
            parameters.addAll(dialog2.getCommandLine());
        }
        SetupTaskChooserAction.runSetupTask(taskName, module2, parameters);
    }

    public static void runSetupTask(String taskName, Module module2, List<String> parameters) {
        try {
            PyFile setupPy = PyPackageUtil.findSetupPy(module2);
            if (setupPy == null) {
                return;
            }
            PythonTask task2 = new PythonTask(module2, taskName);
            VirtualFile virtualFile = setupPy.getVirtualFile();
            task2.setRunnerScript(virtualFile.getPath());
            task2.setWorkingDirectory(virtualFile.getParent().getPath());
            task2.setParameters(parameters);
            task2.setAfterCompletion(() -> LocalFileSystem.getInstance().refresh(true));
            task2.run(null, null);
        }
        catch (ExecutionException ee) {
            Messages.showErrorDialog((Project)module2.getProject(), (String)("Failed to run task: " + ee.getMessage()), (String)taskName);
        }
    }
}

