/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.completion.OverwriteEqualsInsertHandler;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.magicLiteral.PyMagicLiteralTools;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyCustomPackageIdentifier;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecoratorProvider;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.StringLiteralExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyExpressionCodeFragmentImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PySetuptoolsNamespaceIndex;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.classes.PyDependenciesComparator;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassHelper;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUtil {
    private static final boolean VERBOSE_MODE = System.getenv().get("_PYCHARM_VERBOSE_MODE") != null;

    private PyUtil() {
    }

    @NotNull
    public static <T extends PyElement> T[] getAllChildrenOfType(@NotNull PsiElement element, @NotNull Class<T> aClass) {
        if (element == null) {
            PyUtil.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            PyUtil.$$$reportNull$$$0(1);
        }
        SmartList result2 = new SmartList();
        for (PsiElement child : element.getChildren()) {
            if (PyUtil.instanceOf(child, aClass)) {
                result2.add((PyElement)child);
                continue;
            }
            ContainerUtil.addAll((Collection)result2, (Object[])PyUtil.getAllChildrenOfType((PsiElement)child, aClass));
        }
        PyElement[] pyElementArray = (PyElement[])ArrayUtil.toObjectArray((Collection)result2, aClass);
        if (pyElementArray == null) {
            PyUtil.$$$reportNull$$$0(2);
        }
        return pyElementArray;
    }

    protected static List<PyExpression> unfoldParentheses(PyExpression[] targets, List<PyExpression> receiver, boolean unfoldListLiterals, boolean unfoldStarExpressions) {
        for (PyExpression exp : targets) {
            if (exp instanceof PyParenthesizedExpression) {
                PyParenthesizedExpression parenExpr = (PyParenthesizedExpression)exp;
                PyUtil.unfoldParentheses(new PyExpression[]{parenExpr.getContainedExpression()}, receiver, unfoldListLiterals, unfoldStarExpressions);
                continue;
            }
            if (exp instanceof PyTupleExpression) {
                PyTupleExpression tupleExpr = (PyTupleExpression)exp;
                PyUtil.unfoldParentheses(tupleExpr.getElements(), receiver, unfoldListLiterals, unfoldStarExpressions);
                continue;
            }
            if (exp instanceof PyListLiteralExpression && unfoldListLiterals) {
                PyListLiteralExpression listLiteral = (PyListLiteralExpression)exp;
                PyUtil.unfoldParentheses(listLiteral.getElements(), receiver, true, unfoldStarExpressions);
                continue;
            }
            if (exp instanceof PyStarExpression && unfoldStarExpressions) {
                PyUtil.unfoldParentheses(new PyExpression[]{((PyStarExpression)exp).getExpression()}, receiver, unfoldListLiterals, true);
                continue;
            }
            if (exp == null) continue;
            receiver.add(exp);
        }
        return receiver;
    }

    @NotNull
    public static List<PyExpression> flattenedParensAndTuples(PyExpression ... targets) {
        List<PyExpression> list2 = PyUtil.unfoldParentheses(targets, new ArrayList<PyExpression>(targets.length), false, false);
        if (list2 == null) {
            PyUtil.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public static List<PyExpression> flattenedParensAndLists(PyExpression ... targets) {
        List<PyExpression> list2 = PyUtil.unfoldParentheses(targets, new ArrayList<PyExpression>(targets.length), true, true);
        if (list2 == null) {
            PyUtil.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public static List<PyExpression> flattenedParensAndStars(PyExpression ... targets) {
        List<PyExpression> list2 = PyUtil.unfoldParentheses(targets, new ArrayList<PyExpression>(targets.length), false, true);
        if (list2 == null) {
            PyUtil.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public static boolean instanceOf(Object obj, Class ... possibleClasses) {
        if (obj == null || possibleClasses == null) {
            return false;
        }
        for (Class cls : possibleClasses) {
            if (!cls.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @NonNls
    public static String getReadableRepr(PsiElement elt, boolean cutAtEOL) {
        if (elt == null) {
            if ("null!" == null) {
                PyUtil.$$$reportNull$$$0(6);
            }
            return "null!";
        }
        ASTNode node = elt.getNode();
        if (node == null) {
            if ("null" == null) {
                PyUtil.$$$reportNull$$$0(7);
            }
            return "null";
        }
        String s = node.getText();
        int cut_pos = cutAtEOL ? s.indexOf(10) : -1;
        if (cut_pos < 0) {
            cut_pos = s.length();
        }
        String string = s.substring(0, Math.min(cut_pos, s.length()));
        if (string == null) {
            PyUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static PyClass getContainingClassOrSelf(PsiElement element) {
        PsiElement current;
        for (current = element; current != null && !(current instanceof PyClass); current = current.getParent()) {
        }
        return (PyClass)current;
    }

    @Nullable
    public static PyFile getContainingPyFile(PyElement element) {
        PsiFile containingFile = element.getContainingFile();
        return containingFile instanceof PyFile ? (PyFile)containingFile : null;
    }

    public static void showBalloon(Project project, String message, MessageType messageType) {
        JFrame frame = WindowManager.getInstance().getFrame(project.isDefault() ? null : project);
        if (frame == null) {
            return;
        }
        JRootPane component = frame.getRootPane();
        if (component == null) {
            return;
        }
        Rectangle rect = component.getVisibleRect();
        Point p = new Point(rect.x + rect.width - 10, rect.y + 10);
        RelativePoint point = new RelativePoint((Component)component, p);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null).setShowCallout(false).setCloseButtonEnabled(true).createBalloon().show(point, Balloon.Position.atLeft);
    }

    @NonNls
    public static String nvl(Object s) {
        if (s != null) {
            return "'" + s.toString() + "'";
        }
        return "null";
    }

    public static void addListNode(PsiElement parent, PsiElement newItem, ASTNode beforeThis, boolean isFirst, boolean isLast, boolean addWhitespace) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite(parent)) {
            return;
        }
        ASTNode node = parent.getNode();
        assert (node != null);
        ASTNode itemNode = newItem.getNode();
        assert (itemNode != null);
        Project project = parent.getProject();
        PyElementGenerator gen = PyElementGenerator.getInstance(project);
        if (!isFirst) {
            node.addChild(gen.createComma(), beforeThis);
        }
        node.addChild(itemNode, beforeThis);
        if (!isLast) {
            node.addChild(gen.createComma(), beforeThis);
        }
        if (addWhitespace) {
            node.addChild((ASTNode)ASTFactory.whitespace(" "), beforeThis);
        }
    }

    @Nullable
    public static PyType getSpecialAttributeType(@Nullable PyReferenceExpression ref, TypeEvalContext context) {
        PyExpression qualifier;
        if (ref != null && (qualifier = ref.getQualifier()) != null) {
            PyType qualifierType;
            String attr_name = ref.getReferencedName();
            if ("__class__".equals(attr_name)) {
                PyType qualifierType2 = context.getType(qualifier);
                if (qualifierType2 instanceof PyClassType) {
                    return new PyClassTypeImpl(((PyClassType)qualifierType2).getPyClass(), true);
                }
            } else if ("__dict__".equals(attr_name) && (qualifierType = context.getType(qualifier)) instanceof PyClassType && ((PyClassType)qualifierType).isDefinition()) {
                return PyBuiltinCache.getInstance((PsiElement)ref).getDictType();
            }
        }
        return null;
    }

    @NotNull
    public static <T> T sure(T thing) {
        if (thing == null) {
            throw new IncorrectOperationException();
        }
        T t = thing;
        if (t == null) {
            PyUtil.$$$reportNull$$$0(9);
        }
        return t;
    }

    public static void sure(boolean thing) {
        if (!thing) {
            throw new IncorrectOperationException();
        }
    }

    public static boolean isAttribute(PyTargetExpression ex) {
        return PyUtil.isInstanceAttribute(ex) || PyUtil.isClassAttribute(ex);
    }

    public static boolean isInstanceAttribute(PyExpression target2) {
        PyFunction method;
        if (!(target2 instanceof PyTargetExpression)) {
            return false;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)target2);
        if (owner instanceof PyFunction && (method = (PyFunction)owner).getContainingClass() != null) {
            if (method.getStub() != null) {
                return true;
            }
            PyParameter[] params = method.getParameterList().getParameters();
            if (params.length > 0) {
                PyTargetExpression targetExpr = (PyTargetExpression)target2;
                PyExpression qualifier = targetExpr.getQualifier();
                return qualifier != null && qualifier.getText().equals(params[0].getName());
            }
        }
        return false;
    }

    public static boolean isClassAttribute(PsiElement element) {
        return element instanceof PyTargetExpression && ScopeUtil.getScopeOwner(element) instanceof PyClass;
    }

    public static boolean isIfNameEqualsMain(PyIfStatement ifStatement) {
        PyExpression condition = ifStatement.getIfPart().getCondition();
        return PyUtil.isNameEqualsMain(condition);
    }

    private static boolean isNameEqualsMain(PyExpression condition) {
        if (condition instanceof PyParenthesizedExpression) {
            return PyUtil.isNameEqualsMain(((PyParenthesizedExpression)condition).getContainedExpression());
        }
        if (condition instanceof PyBinaryExpression) {
            PyBinaryExpression binaryExpression = (PyBinaryExpression)condition;
            if (binaryExpression.getOperator() == PyTokenTypes.OR_KEYWORD) {
                return PyUtil.isNameEqualsMain(binaryExpression.getLeftExpression()) || PyUtil.isNameEqualsMain(binaryExpression.getRightExpression());
            }
            PyExpression rhs = binaryExpression.getRightExpression();
            return binaryExpression.getOperator() == PyTokenTypes.EQEQ && binaryExpression.getLeftExpression().getText().equals("__name__") && rhs != null && rhs.getText().contains("__main__");
        }
        return false;
    }

    @Nullable
    public static List<PsiElement> searchForWrappingMethod(PsiElement start, boolean deep) {
        PsiElement seeker = start;
        ArrayList<PsiElement> ret = new ArrayList<PsiElement>(2);
        while (seeker != null) {
            PyFunction func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)seeker, PyFunction.class, (boolean)true, (Class[])new Class[]{PyClass.class});
            if (func != null) {
                PyClass cls = func.getContainingClass();
                if (cls != null) {
                    ret.add(func);
                    ret.add((PsiElement)cls);
                    return ret;
                }
                if (deep) {
                    ret.add(func);
                    seeker = func;
                    continue;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static boolean inSameFile(@NotNull PsiElement e1, @NotNull PsiElement e2) {
        if (e1 == null) {
            PyUtil.$$$reportNull$$$0(10);
        }
        if (e2 == null) {
            PyUtil.$$$reportNull$$$0(11);
        }
        PsiFile f1 = e1.getContainingFile();
        PsiFile f2 = e2.getContainingFile();
        if (f1 == null || f2 == null) {
            return false;
        }
        return f1 == f2;
    }

    public static boolean onSameLine(@NotNull PsiElement e1, @NotNull PsiElement e2) {
        PsiDocumentManager documentManager;
        Document document;
        if (e1 == null) {
            PyUtil.$$$reportNull$$$0(12);
        }
        if (e2 == null) {
            PyUtil.$$$reportNull$$$0(13);
        }
        if ((document = (documentManager = PsiDocumentManager.getInstance((Project)e1.getProject())).getDocument(e1.getContainingFile())) == null || document != documentManager.getDocument(e2.getContainingFile())) {
            return false;
        }
        return document.getLineNumber(e1.getTextOffset()) == document.getLineNumber(e2.getTextOffset());
    }

    public static boolean isTopLevel(@NotNull PsiElement element) {
        StubElement parentStub;
        StubElement stub;
        if (element == null) {
            PyUtil.$$$reportNull$$$0(14);
        }
        if (element instanceof StubBasedPsiElement && (stub = ((StubBasedPsiElement)element).getStub()) != null && (parentStub = stub.getParentStub()) != null) {
            return parentStub.getPsi() instanceof PsiFile;
        }
        return ScopeUtil.getScopeOwner(element) instanceof PsiFile;
    }

    public static void deletePycFiles(String pyFilePath) {
        if (pyFilePath.endsWith(".py")) {
            File file2;
            File pycache;
            File pyo;
            ArrayList<File> filesToDelete = new ArrayList<File>();
            File pyc = new File(pyFilePath + "c");
            if (pyc.exists()) {
                filesToDelete.add(pyc);
            }
            if ((pyo = new File(pyFilePath + "o")).exists()) {
                filesToDelete.add(pyo);
            }
            if ((pycache = new File((file2 = new File(pyFilePath)).getParentFile(), "__pycache__")).isDirectory()) {
                String shortName = FileUtil.getNameWithoutExtension((File)file2);
                Collections.addAll(filesToDelete, pycache.listFiles(pathname -> {
                    if (!FileUtilRt.extensionEquals((String)pathname.getName(), (String)"pyc")) {
                        return false;
                    }
                    String nameWithMagic = FileUtil.getNameWithoutExtension((File)pathname);
                    return FileUtil.getNameWithoutExtension((String)nameWithMagic).equals(shortName);
                }));
            }
            FileUtil.asyncDelete(filesToDelete);
        }
    }

    public static String getElementNameWithoutExtension(PsiNamedElement psiNamedElement) {
        return psiNamedElement instanceof PyFile ? FileUtil.getNameWithoutExtension((String)((PyFile)psiNamedElement).getName()) : psiNamedElement.getName();
    }

    public static boolean hasUnresolvedAncestors(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PyUtil.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PyUtil.$$$reportNull$$$0(16);
        }
        for (PyClassLikeType type : cls.getAncestorTypes(context)) {
            if (type != null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static AccessDirection getPropertyAccessDirection(@NotNull PyFunction function) {
        Property property;
        if (function == null) {
            PyUtil.$$$reportNull$$$0(17);
        }
        if ((property = function.getProperty()) != null) {
            if (property.getGetter().valueOrNull() == function) {
                AccessDirection accessDirection = AccessDirection.READ;
                if (accessDirection == null) {
                    PyUtil.$$$reportNull$$$0(18);
                }
                return accessDirection;
            }
            if (property.getSetter().valueOrNull() == function) {
                AccessDirection accessDirection = AccessDirection.WRITE;
                if (accessDirection == null) {
                    PyUtil.$$$reportNull$$$0(19);
                }
                return accessDirection;
            }
            if (property.getDeleter().valueOrNull() == function) {
                AccessDirection accessDirection = AccessDirection.DELETE;
                if (accessDirection == null) {
                    PyUtil.$$$reportNull$$$0(20);
                }
                return accessDirection;
            }
        }
        AccessDirection accessDirection = AccessDirection.READ;
        if (accessDirection == null) {
            PyUtil.$$$reportNull$$$0(21);
        }
        return accessDirection;
    }

    public static void removeQualifier(@NotNull PyReferenceExpression element) {
        PyExpression calleeQualifier;
        PyExpression callee;
        PyExpression qualifier;
        if (element == null) {
            PyUtil.$$$reportNull$$$0(22);
        }
        if ((qualifier = element.getQualifier()) == null) {
            return;
        }
        if (qualifier instanceof PyCallExpression && (callee = ((PyCallExpression)qualifier).getCallee()) instanceof PyReferenceExpression && (calleeQualifier = ((PyReferenceExpression)callee).getQualifier()) != null) {
            qualifier.replace((PsiElement)calleeQualifier);
            return;
        }
        PsiElement dot = PyPsiUtils.getNextNonWhitespaceSibling((PsiElement)qualifier);
        if (dot != null) {
            dot.delete();
        }
        qualifier.delete();
    }

    @NotNull
    public static String computeElementNameForStringSearch(@NotNull PsiElement element) {
        String name;
        if (element == null) {
            PyUtil.$$$reportNull$$$0(23);
        }
        if (element instanceof PyFile) {
            String string = FileUtil.getNameWithoutExtension((String)((PyFile)element).getName());
            if (string == null) {
                PyUtil.$$$reportNull$$$0(24);
            }
            return string;
        }
        if (element instanceof PsiDirectory) {
            String string = ((PsiDirectory)element).getName();
            if (string == null) {
                PyUtil.$$$reportNull$$$0(25);
            }
            return string;
        }
        if (element instanceof PyStringLiteralExpression && PyMagicLiteralTools.isMagicLiteral(element) && (name = ((StringLiteralExpression)element).getStringValue()) != null) {
            String string = name;
            if (string == null) {
                PyUtil.$$$reportNull$$$0(26);
            }
            return string;
        }
        if (element instanceof PyElement && (name = ((PyElement)element).getName()) != null) {
            String string = name;
            if (string == null) {
                PyUtil.$$$reportNull$$$0(27);
            }
            return string;
        }
        String string = element.getNode() != null ? element.getNode().getText() : element.getText();
        if (string == null) {
            PyUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    public static boolean isOwnScopeComprehension(@NotNull PyComprehensionElement comprehension) {
        if (comprehension == null) {
            PyUtil.$$$reportNull$$$0(29);
        }
        boolean isAtLeast30 = LanguageLevel.forElement(comprehension).isAtLeast(LanguageLevel.PYTHON30);
        boolean isListComprehension = comprehension instanceof PyListCompExpression;
        return !isListComprehension || isAtLeast30;
    }

    public static ASTNode createNewName(PyElement element, String name) {
        return PyElementGenerator.getInstance(element.getProject()).createNameIdentifier(name, LanguageLevel.forElement((PsiElement)element));
    }

    @NotNull
    public static PsiElement resolveToTheTop(@NotNull PsiElement elementToResolve) {
        PsiElement resolve2;
        PsiReference reference;
        if (elementToResolve == null) {
            PyUtil.$$$reportNull$$$0(30);
        }
        PsiElement currentElement = elementToResolve;
        HashSet checkedElements = new HashSet();
        while ((reference = currentElement.getReference()) != null && (resolve2 = reference.resolve()) != null && !checkedElements.contains(resolve2) && !resolve2.equals(currentElement) && PyUtil.inSameFile(resolve2, currentElement)) {
            currentElement = resolve2;
            checkedElements.add(resolve2);
        }
        PsiElement psiElement = currentElement;
        if (psiElement == null) {
            PyUtil.$$$reportNull$$$0(31);
        }
        return psiElement;
    }

    @NotNull
    public static List<PsiElement> multiResolveTopPriority(@NotNull PsiElement element, @NotNull PyResolveContext resolveContext) {
        if (element == null) {
            PyUtil.$$$reportNull$$$0(32);
        }
        if (resolveContext == null) {
            PyUtil.$$$reportNull$$$0(33);
        }
        if (element instanceof PyReferenceOwner) {
            PsiPolyVariantReference ref = ((PyReferenceOwner)element).getReference(resolveContext);
            List<PsiElement> list2 = PyUtil.filterTopPriorityResults(ref.multiResolve(false));
            if (list2 == null) {
                PyUtil.$$$reportNull$$$0(34);
            }
            return list2;
        }
        PsiReference reference = element.getReference();
        List<PsiElement> list3 = reference != null ? Collections.singletonList(reference.resolve()) : Collections.emptyList();
        if (list3 == null) {
            PyUtil.$$$reportNull$$$0(35);
        }
        return list3;
    }

    @NotNull
    public static List<PsiElement> multiResolveTopPriority(@NotNull PsiPolyVariantReference reference) {
        if (reference == null) {
            PyUtil.$$$reportNull$$$0(36);
        }
        List<PsiElement> list2 = PyUtil.filterTopPriorityResults(reference.multiResolve(false));
        if (list2 == null) {
            PyUtil.$$$reportNull$$$0(37);
        }
        return list2;
    }

    @NotNull
    public static List<PsiElement> filterTopPriorityResults(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            PyUtil.$$$reportNull$$$0(38);
        }
        if (resolveResults.length == 0) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                PyUtil.$$$reportNull$$$0(39);
            }
            return list2;
        }
        int maxRate = PyUtil.getMaxRate(Arrays.asList(resolveResults));
        List list3 = ((StreamEx)StreamEx.of((Object[])resolveResults).filter(resolveResult -> PyUtil.getRate(resolveResult) >= maxRate)).map(ResolveResult::getElement).nonNull().toList();
        if (list3 == null) {
            PyUtil.$$$reportNull$$$0(40);
        }
        return list3;
    }

    @NotNull
    public static <E extends ResolveResult> List<E> filterTopPriorityResults(@NotNull List<E> resolveResults) {
        if (resolveResults == null) {
            PyUtil.$$$reportNull$$$0(41);
        }
        if (resolveResults.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                PyUtil.$$$reportNull$$$0(42);
            }
            return list2;
        }
        int maxRate = PyUtil.getMaxRate(resolveResults);
        List list3 = ContainerUtil.filter(resolveResults, resolveResult -> PyUtil.getRate(resolveResult) >= maxRate);
        if (list3 == null) {
            PyUtil.$$$reportNull$$$0(43);
        }
        return list3;
    }

    private static int getMaxRate(@NotNull List<? extends ResolveResult> resolveResults) {
        if (resolveResults == null) {
            PyUtil.$$$reportNull$$$0(44);
        }
        return resolveResults.stream().mapToInt(PyUtil::getRate).max().orElse(Integer.MIN_VALUE);
    }

    private static int getRate(@NotNull ResolveResult resolveResult) {
        if (resolveResult == null) {
            PyUtil.$$$reportNull$$$0(45);
        }
        return resolveResult instanceof RatedResolveResult ? ((RatedResolveResult)resolveResult).getRate() : 0;
    }

    @Nullable
    public static PyFunction getInitMethod(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PyUtil.$$$reportNull$$$0(46);
        }
        return pyClass.findMethodByName("__init__", false, null);
    }

    @NotNull
    public static LanguageLevel getLanguageLevelForVirtualFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        VirtualFile folder;
        if (project == null) {
            PyUtil.$$$reportNull$$$0(47);
        }
        if (virtualFile == null) {
            PyUtil.$$$reportNull$$$0(48);
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        if ((folder = virtualFile.getParent()) != null) {
            LanguageLevel folderLevel = (LanguageLevel)((Object)folder.getUserData(LanguageLevel.KEY));
            if (folderLevel != null) {
                LanguageLevel languageLevel = folderLevel;
                if (languageLevel == null) {
                    PyUtil.$$$reportNull$$$0(49);
                }
                return languageLevel;
            }
            LanguageLevel fileLevel = PythonLanguageLevelPusher.getFileLanguageLevel(project, virtualFile);
            if (fileLevel != null) {
                LanguageLevel languageLevel = fileLevel;
                if (languageLevel == null) {
                    PyUtil.$$$reportNull$$$0(50);
                }
                return languageLevel;
            }
        } else {
            LanguageLevel languageLevel;
            LanguageLevel level = (LanguageLevel)((Object)virtualFile.getUserData(LanguageLevel.KEY));
            if (level != null) {
                LanguageLevel languageLevel2 = level;
                if (languageLevel2 == null) {
                    PyUtil.$$$reportNull$$$0(51);
                }
                return languageLevel2;
            }
            if (ApplicationManager.getApplication().isUnitTestMode() && (languageLevel = LanguageLevel.FORCE_LANGUAGE_LEVEL) != null) {
                LanguageLevel languageLevel3 = languageLevel;
                if (languageLevel3 == null) {
                    PyUtil.$$$reportNull$$$0(52);
                }
                return languageLevel3;
            }
        }
        LanguageLevel languageLevel = PyUtil.guessLanguageLevelWithCaching(project);
        if (languageLevel == null) {
            PyUtil.$$$reportNull$$$0(53);
        }
        return languageLevel;
    }

    public static void invalidateLanguageLevelCache(@NotNull Project project) {
        if (project == null) {
            PyUtil.$$$reportNull$$$0(54);
        }
        project.putUserData(PythonLanguageLevelPusher.PYTHON_LANGUAGE_LEVEL, null);
    }

    @NotNull
    public static LanguageLevel guessLanguageLevelWithCaching(@NotNull Project project) {
        LanguageLevel languageLevel;
        if (project == null) {
            PyUtil.$$$reportNull$$$0(55);
        }
        if ((languageLevel = (LanguageLevel)((Object)project.getUserData(PythonLanguageLevelPusher.PYTHON_LANGUAGE_LEVEL))) == null) {
            languageLevel = PyUtil.guessLanguageLevel(project);
            project.putUserData(PythonLanguageLevelPusher.PYTHON_LANGUAGE_LEVEL, (Object)languageLevel);
        }
        LanguageLevel languageLevel2 = languageLevel;
        if (languageLevel2 == null) {
            PyUtil.$$$reportNull$$$0(56);
        }
        return languageLevel2;
    }

    @NotNull
    public static LanguageLevel guessLanguageLevel(@NotNull Project project) {
        ModuleManager moduleManager;
        if (project == null) {
            PyUtil.$$$reportNull$$$0(57);
        }
        if ((moduleManager = ModuleManager.getInstance((Project)project)) != null) {
            LanguageLevel maxLevel = null;
            for (Module projectModule : moduleManager.getModules()) {
                Sdk sdk = PythonSdkType.findPythonSdk(projectModule);
                if (sdk == null) continue;
                LanguageLevel level = PythonSdkType.getLanguageLevelForSdk(sdk);
                if (maxLevel != null && !maxLevel.isOlderThan(level)) continue;
                maxLevel = level;
            }
            if (maxLevel != null) {
                LanguageLevel languageLevel = maxLevel;
                if (languageLevel == null) {
                    PyUtil.$$$reportNull$$$0(58);
                }
                return languageLevel;
            }
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PyUtil.$$$reportNull$$$0(59);
        }
        return languageLevel;
    }

    @Nullable
    public static <T> T as(@Nullable Object expression, @NotNull Class<T> clazz) {
        if (clazz == null) {
            PyUtil.$$$reportNull$$$0(60);
        }
        return (T)ObjectUtils.tryCast((Object)expression, clazz);
    }

    @Nullable
    public static <T extends PsiElement> T findReference(@NotNull PsiElement element, @NotNull Class<T> expectedClass) {
        if (element == null) {
            PyUtil.$$$reportNull$$$0(61);
        }
        if (expectedClass == null) {
            PyUtil.$$$reportNull$$$0(62);
        }
        for (PsiReference reference : element.getReferences()) {
            PsiElement result2 = (PsiElement)PyUtil.as(reference.resolve(), expectedClass);
            if (result2 == null) continue;
            return (T)result2;
        }
        return null;
    }

    @NotNull
    public static <T> List<T> asList(@Nullable Collection<?> expression, @NotNull Class<T> elementClass) {
        if (elementClass == null) {
            PyUtil.$$$reportNull$$$0(63);
        }
        if (expression == null || expression.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                PyUtil.$$$reportNull$$$0(64);
            }
            return list2;
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (Object element : expression) {
            T toAdd = PyUtil.as(element, elementClass);
            if (toAdd == null) continue;
            result2.add(toAdd);
        }
        ArrayList<T> arrayList = result2;
        if (arrayList == null) {
            PyUtil.$$$reportNull$$$0(65);
        }
        return arrayList;
    }

    public static void rehighlightOpenEditors(@NotNull Project project) {
        if (project == null) {
            PyUtil.$$$reportNull$$$0(66);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                PyUtil.$$$reportNull$$$0(142);
            }
            for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                VirtualFile vFile;
                if (!(editor instanceof EditorEx) || editor.getProject() != project || (vFile = ((EditorEx)editor).getVirtualFile()) == null) continue;
                EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, vFile);
                ((EditorEx)editor).setHighlighter(highlighter);
            }
        });
    }

    @NotNull
    public static <T, P> T getParameterizedCachedValue(@NotNull PsiElement element, @Nullable P param, @NotNull NotNullFunction<P, T> f) {
        if (element == null) {
            PyUtil.$$$reportNull$$$0(67);
        }
        if (f == null) {
            PyUtil.$$$reportNull$$$0(68);
        }
        T result2 = PyUtil.getNullableParameterizedCachedValue(element, param, f);
        assert (result2 != null);
        T t = result2;
        if (t == null) {
            PyUtil.$$$reportNull$$$0(69);
        }
        return t;
    }

    @Nullable
    public static <T, P> T getNullableParameterizedCachedValue(@NotNull PsiElement element, @Nullable P param, @NotNull NullableFunction<P, T> f) {
        Optional<P> wrappedParam;
        CachedValuesManager manager;
        Map cache;
        Optional<Object> value;
        if (element == null) {
            PyUtil.$$$reportNull$$$0(70);
        }
        if (f == null) {
            PyUtil.$$$reportNull$$$0(71);
        }
        if ((value = (Optional<Object>)(cache = (Map)CachedValuesManager.getCachedValue((PsiElement)element, (Key)(manager = CachedValuesManager.getManager((Project)element.getProject())).getKeyForClass(f.getClass()), () -> CachedValueProvider.Result.create((Object)Maps.newConcurrentMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}))).get(wrappedParam = Optional.ofNullable(param))) == null) {
            value = Optional.ofNullable(f.fun(param));
            cache.put(wrappedParam, value);
        }
        return value.orElse(null);
    }

    public static void runWithProgress(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean modal, boolean canBeCancelled, final @NotNull Consumer<ProgressIndicator> function) {
        if (title == null) {
            PyUtil.$$$reportNull$$$0(72);
        }
        if (function == null) {
            PyUtil.$$$reportNull$$$0(73);
        }
        if (modal) {
            ProgressManager.getInstance().run((Task)new Task.Modal(project, title, canBeCancelled){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    function.consume((Object)indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/psi/PyUtil$1", "run"));
                }
            });
        } else {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title, canBeCancelled){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    function.consume((Object)indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/psi/PyUtil$2", "run"));
                }
            });
        }
    }

    public static void verboseOnly(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            PyUtil.$$$reportNull$$$0(74);
        }
        if (VERBOSE_MODE) {
            runnable2.run();
        }
    }

    @Nullable
    public static PsiComment getCommentOnHeaderLine(@NotNull PyStatementListContainer container) {
        if (container == null) {
            PyUtil.$$$reportNull$$$0(75);
        }
        PyStatementList statementList = container.getStatementList();
        return PyUtil.as(PyPsiUtils.getPrevNonWhitespaceSibling((PsiElement)statementList), PsiComment.class);
    }

    public static boolean isPy2ReservedWord(@NotNull PyReferenceExpression node) {
        String name;
        if (node == null) {
            PyUtil.$$$reportNull$$$0(76);
        }
        return LanguageLevel.forElement((PsiElement)node).isOlderThan(LanguageLevel.PYTHON30) && !node.isQualified() && ("None".equals(name = node.getName()) || "False".equals(name) || "True".equals(name));
    }

    public static void updateDocumentUnblockedAndCommitted(@NotNull PsiElement anchor, @NotNull Consumer<Document> consumer) {
        if (anchor == null) {
            PyUtil.$$$reportNull$$$0(77);
        }
        if (consumer == null) {
            PyUtil.$$$reportNull$$$0(78);
        }
        PyUtil.updateDocumentUnblockedAndCommitted(anchor, document -> {
            if (consumer == null) {
                PyUtil.$$$reportNull$$$0(141);
            }
            consumer.consume(document);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T updateDocumentUnblockedAndCommitted(@NotNull PsiElement anchor, @NotNull Function<Document, T> func) {
        PsiDocumentManager manager;
        Document document;
        if (anchor == null) {
            PyUtil.$$$reportNull$$$0(79);
        }
        if (func == null) {
            PyUtil.$$$reportNull$$$0(80);
        }
        if ((document = (manager = PsiDocumentManager.getInstance((Project)anchor.getProject())).getDocument(anchor.getContainingFile())) != null) {
            manager.doPostponedOperationsAndUnblockDocument(document);
            try {
                Object object = func.fun((Object)document);
                return (T)object;
            }
            finally {
                manager.commitDocument(document);
            }
        }
        return null;
    }

    @Nullable
    public static PyType getReturnTypeToAnalyzeAsCallType(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        PyClass cls;
        if (function == null) {
            PyUtil.$$$reportNull$$$0(81);
        }
        if (context == null) {
            PyUtil.$$$reportNull$$$0(82);
        }
        if (PyUtil.isInit(function) && (cls = function.getContainingClass()) != null) {
            for (PyTypeProvider provider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
                PyType providedClassType = provider.getGenericType(cls, context);
                if (providedClassType == null) continue;
                return providedClassType;
            }
            PyInstantiableType classType = PyUtil.as(context.getType(cls), PyInstantiableType.class);
            if (classType != null) {
                return classType.toInstance();
            }
        }
        return context.getReturnType(function);
    }

    @Nullable
    public static PyExpression createExpressionFromFragment(@NotNull String expressionText, @NotNull PsiElement context) {
        if (expressionText == null) {
            PyUtil.$$$reportNull$$$0(83);
        }
        if (context == null) {
            PyUtil.$$$reportNull$$$0(84);
        }
        PyExpressionCodeFragmentImpl codeFragment = new PyExpressionCodeFragmentImpl(context.getProject(), "dummy.py", expressionText, false);
        codeFragment.setContext(context);
        PyExpressionStatement statement = PyUtil.as(codeFragment.getFirstChild(), PyExpressionStatement.class);
        return statement != null ? statement.getExpression() : null;
    }

    @Nullable
    public static PsiElement turnDirIntoInit(@Nullable PsiElement target2) {
        if (target2 instanceof PsiDirectory) {
            PsiDirectory dir = (PsiDirectory)target2;
            PsiFile initStub = dir.findFile("__init__.pyi");
            if (initStub != null) {
                return initStub;
            }
            PsiFile initFile = dir.findFile("__init__.py");
            if (initFile != null) {
                return initFile;
            }
            return null;
        }
        return target2;
    }

    @Nullable
    public static PsiElement getPackageElement(@NotNull PsiDirectory directory2, @Nullable PsiElement anchor) {
        if (directory2 == null) {
            PyUtil.$$$reportNull$$$0(85);
        }
        if (PyUtil.isPackage(directory2, anchor)) {
            PsiElement init = PyUtil.turnDirIntoInit((PsiElement)directory2);
            if (init != null) {
                return init;
            }
            return directory2;
        }
        return null;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static PsiElement turnInitIntoDir(@Nullable PsiElement target2) {
        if (target2 instanceof PyFile && PyUtil.isPackage((PsiFile)target2)) {
            return ((PsiFile)target2).getContainingDirectory();
        }
        return target2;
    }

    public static boolean isPackage(@NotNull PsiDirectory directory2, @Nullable PsiElement anchor) {
        if (directory2 == null) {
            PyUtil.$$$reportNull$$$0(86);
        }
        return PyUtil.isPackage(directory2, true, anchor);
    }

    public static boolean isPackage(@NotNull PsiDirectory directory2, boolean checkSetupToolsPackages, @Nullable PsiElement anchor) {
        LanguageLevel level;
        if (directory2 == null) {
            PyUtil.$$$reportNull$$$0(87);
        }
        for (PyCustomPackageIdentifier customPackageIdentifier : (PyCustomPackageIdentifier[])PyCustomPackageIdentifier.EP_NAME.getExtensions()) {
            if (!customPackageIdentifier.isPackage(directory2)) continue;
            return true;
        }
        if (directory2.findFile("__init__.py") != null) {
            return true;
        }
        LanguageLevel languageLevel = level = anchor != null ? LanguageLevel.forElement(anchor) : PyUtil.getLanguageLevelForVirtualFile(directory2.getProject(), directory2.getVirtualFile());
        if (level.isAtLeast(LanguageLevel.PYTHON33)) {
            return true;
        }
        return checkSetupToolsPackages && PyUtil.isSetuptoolsNamespacePackage(directory2);
    }

    public static boolean isPackage(@NotNull PsiFile file2) {
        if (file2 == null) {
            PyUtil.$$$reportNull$$$0(88);
        }
        for (PyCustomPackageIdentifier customPackageIdentifier : (PyCustomPackageIdentifier[])PyCustomPackageIdentifier.EP_NAME.getExtensions()) {
            if (!customPackageIdentifier.isPackageFile(file2)) continue;
            return true;
        }
        return "__init__.py".equals(file2.getName());
    }

    private static boolean isSetuptoolsNamespacePackage(@NotNull PsiDirectory directory2) {
        String packagePath;
        if (directory2 == null) {
            PyUtil.$$$reportNull$$$0(89);
        }
        return (packagePath = PyUtil.getPackagePath(directory2)) != null && !PySetuptoolsNamespaceIndex.find(packagePath, directory2.getProject()).isEmpty();
    }

    @Nullable
    private static String getPackagePath(@NotNull PsiDirectory directory2) {
        QualifiedName name;
        if (directory2 == null) {
            PyUtil.$$$reportNull$$$0(90);
        }
        return (name = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)directory2)) != null ? name.toString() : null;
    }

    public static int getInitialUnderscores(String name) {
        if (name == null) {
            return 0;
        }
        int underscores = 0;
        if (name.startsWith("__")) {
            underscores = 2;
        } else if (name.startsWith("_")) {
            underscores = 1;
        }
        return underscores;
    }

    public static boolean isClassPrivateName(@NotNull String name) {
        if (name == null) {
            PyUtil.$$$reportNull$$$0(91);
        }
        return name.startsWith("__") && !name.endsWith("__");
    }

    public static boolean isSpecialName(@NotNull String name) {
        if (name == null) {
            PyUtil.$$$reportNull$$$0(92);
        }
        return name.length() > 4 && name.startsWith("__") && name.endsWith("__");
    }

    @NotNull
    public static LookupElement createNamedParameterLookup(@NotNull String name, @Nullable Project project) {
        if (name == null) {
            PyUtil.$$$reportNull$$$0(93);
        }
        String suffix = ((PyCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(PyCodeStyleSettings.class)).SPACE_AROUND_EQ_IN_KEYWORD_ARGUMENT ? " = " : "=";
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)(name + suffix)).withIcon(PlatformIcons.PARAMETER_ICON);
        lookupElementBuilder = lookupElementBuilder.withInsertHandler((InsertHandler)OverwriteEqualsInsertHandler.INSTANCE);
        LookupElement lookupElement = PrioritizedLookupElement.withGrouping((LookupElement)lookupElementBuilder, (int)1);
        if (lookupElement == null) {
            PyUtil.$$$reportNull$$$0(94);
        }
        return lookupElement;
    }

    @Nullable
    public static PyExpression peelArgument(PyExpression expr) {
        while (expr instanceof PyParenthesizedExpression) {
            expr = ((PyParenthesizedExpression)expr).getContainedExpression();
        }
        if (expr instanceof PyKeywordArgument) {
            expr = ((PyKeywordArgument)expr).getValueExpression();
        }
        return expr;
    }

    public static String getFirstParameterName(PyFunction container) {
        PyNamedParameter named;
        PyParameter[] params;
        String selfName = "self";
        if (container != null && (params = container.getParameterList().getParameters()).length > 0 && (named = params[0].getAsNamed()) != null) {
            selfName = named.getName();
        }
        return selfName;
    }

    @NotNull
    public static Collection<VirtualFile> getSourceRoots(@NotNull PsiElement foothold) {
        Module module2;
        if (foothold == null) {
            PyUtil.$$$reportNull$$$0(95);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)foothold)) != null) {
            Collection<VirtualFile> collection = PyUtil.getSourceRoots(module2);
            if (collection == null) {
                PyUtil.$$$reportNull$$$0(96);
            }
            return collection;
        }
        List<VirtualFile> list2 = Collections.emptyList();
        if (list2 == null) {
            PyUtil.$$$reportNull$$$0(97);
        }
        return list2;
    }

    @NotNull
    public static Collection<VirtualFile> getSourceRoots(@NotNull Module module2) {
        if (module2 == null) {
            PyUtil.$$$reportNull$$$0(98);
        }
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module2);
        Collections.addAll(result2, manager.getSourceRoots());
        Collections.addAll(result2, manager.getContentRoots());
        LinkedHashSet<VirtualFile> linkedHashSet = result2;
        if (linkedHashSet == null) {
            PyUtil.$$$reportNull$$$0(99);
        }
        return linkedHashSet;
    }

    @Nullable
    public static VirtualFile findInRoots(Module module2, String path) {
        if (module2 != null) {
            for (VirtualFile root : PyUtil.getSourceRoots(module2)) {
                VirtualFile file2 = root.findFileByRelativePath(path);
                if (file2 == null) continue;
                return file2;
            }
        }
        return null;
    }

    @Nullable
    public static List<String> getStringListFromTargetExpression(PyTargetExpression attr) {
        return PyUtil.strListValue(attr.findAssignedValue());
    }

    @Nullable
    public static List<String> strListValue(PyExpression value) {
        while (value instanceof PyParenthesizedExpression) {
            value = ((PyParenthesizedExpression)value).getContainedExpression();
        }
        if (value instanceof PySequenceExpression) {
            PyExpression[] elements = ((PySequenceExpression)value).getElements();
            ArrayList<String> result2 = new ArrayList<String>(elements.length);
            for (PyExpression element : elements) {
                if (!(element instanceof PyStringLiteralExpression)) {
                    return null;
                }
                result2.add(((PyStringLiteralExpression)element).getStringValue());
            }
            return result2;
        }
        return null;
    }

    @NotNull
    public static Map<String, PyExpression> dictValue(@NotNull PyDictLiteralExpression dict) {
        if (dict == null) {
            PyUtil.$$$reportNull$$$0(100);
        }
        LinkedHashMap result2 = Maps.newLinkedHashMap();
        for (PyKeyValueExpression keyValue : dict.getElements()) {
            PyExpression key = keyValue.getKey();
            PyExpression value = keyValue.getValue();
            if (!(key instanceof PyStringLiteralExpression)) continue;
            result2.put(((PyStringLiteralExpression)key).getStringValue(), value);
        }
        LinkedHashMap linkedHashMap = result2;
        if (linkedHashMap == null) {
            PyUtil.$$$reportNull$$$0(101);
        }
        return linkedHashMap;
    }

    public static <T> boolean among(@NotNull T what, T ... variants) {
        if (what == null) {
            PyUtil.$$$reportNull$$$0(102);
        }
        for (T s : variants) {
            if (!what.equals(s)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getKeywordArgumentString(PyCallExpression expr, String keyword) {
        return PyPsiUtils.strValue(expr.getKeywordArgument(keyword));
    }

    public static boolean isExceptionClass(PyClass pyClass) {
        if (PyUtil.isBaseException(pyClass.getQualifiedName())) {
            return true;
        }
        for (PyClassLikeType type : pyClass.getAncestorTypes(TypeEvalContext.codeInsightFallback(pyClass.getProject()))) {
            if (type == null || !PyUtil.isBaseException(type.getClassQName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isBaseException(String name) {
        return name != null && (name.contains("BaseException") || name.startsWith("exceptions."));
    }

    public static boolean isSuperCall(@NotNull PyCallExpression node) {
        PyClass klass;
        if (node == null) {
            PyUtil.$$$reportNull$$$0(103);
        }
        if ((klass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class)) == null) {
            return false;
        }
        PyExpression callee = node.getCallee();
        if (callee == null) {
            return false;
        }
        String name = callee.getName();
        if ("super".equals(name)) {
            PsiReference reference = callee.getReference();
            if (reference == null) {
                return false;
            }
            PsiElement resolved = reference.resolve();
            PyBuiltinCache cache = PyBuiltinCache.getInstance((PsiElement)node);
            if (resolved != null && cache.isBuiltin(resolved)) {
                PyExpression[] args = node.getArguments();
                if (args.length > 0) {
                    String firstArg = args[0].getText();
                    if (firstArg.equals(klass.getName()) || firstArg.equals("self.__class__")) {
                        return true;
                    }
                    for (PyClass s : klass.getAncestorClasses(null)) {
                        if (!firstArg.equals(s.getName())) continue;
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    public static PyFile getOrCreateFile(String path, Project project) {
        PsiFile psi;
        VirtualFile vfile = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
        if (vfile == null) {
            File file2 = new File(path);
            try {
                VirtualFile baseDir = project.getBaseDir();
                FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance(project);
                FileTemplate template = fileTemplateManager.getInternalTemplate("Python Script");
                Properties properties = fileTemplateManager.getDefaultProperties();
                properties.setProperty("NAME", FileUtil.getNameWithoutExtension((String)file2.getName()));
                String content = template != null ? template.getText(properties) : null;
                psi = PyExtractSuperclassHelper.placeFile(project, StringUtil.notNullize((String)file2.getParent(), (String)(baseDir != null ? baseDir.getPath() : ".")), file2.getName(), content);
            }
            catch (IOException e) {
                throw new IncorrectOperationException(String.format("Cannot create file '%s'", path), (Throwable)e);
            }
        } else {
            psi = PsiManager.getInstance((Project)project).findFile(vfile);
        }
        if (!(psi instanceof PyFile)) {
            throw new IncorrectOperationException(PyBundle.message("refactoring.move.module.members.error.cannot.place.elements.into.nonpython.file", new Object[0]));
        }
        PyFile pyFile = (PyFile)psi;
        if (pyFile == null) {
            PyUtil.$$$reportNull$$$0(104);
        }
        return pyFile;
    }

    @Nullable
    public static PsiElement findPrevAtOffset(PsiFile psiFile, int caretOffset, Class ... toSkip) {
        PsiElement element;
        if (caretOffset < 0) {
            return null;
        }
        int lineStartOffset = 0;
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (document != null) {
            int lineNumber = document.getLineNumber(caretOffset);
            lineStartOffset = document.getLineStartOffset(lineNumber);
        }
        do {
            element = psiFile.findElementAt(--caretOffset);
        } while (caretOffset >= lineStartOffset && PyUtil.instanceOf(element, toSkip));
        return PyUtil.instanceOf(element, toSkip) ? null : element;
    }

    @Nullable
    public static PsiElement findNonWhitespaceAtOffset(PsiFile psiFile, int caretOffset) {
        PsiElement element = PyUtil.findNextAtOffset(psiFile, caretOffset, PsiWhiteSpace.class);
        if (element == null) {
            element = PyUtil.findPrevAtOffset(psiFile, caretOffset - 1, PsiWhiteSpace.class);
        }
        return element;
    }

    @Nullable
    public static PsiElement findElementAtOffset(PsiFile psiFile, int caretOffset) {
        PsiElement element = PyUtil.findPrevAtOffset(psiFile, caretOffset, new Class[0]);
        if (element == null) {
            element = PyUtil.findNextAtOffset(psiFile, caretOffset, new Class[0]);
        }
        return element;
    }

    @Nullable
    public static PsiElement findNextAtOffset(@NotNull PsiFile psiFile, int caretOffset, Class ... toSkip) {
        PsiElement element;
        if (psiFile == null) {
            PyUtil.$$$reportNull$$$0(105);
        }
        if ((element = psiFile.findElementAt(caretOffset)) == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        int lineEndOffset = 0;
        if (document != null) {
            int lineNumber = document.getLineNumber(caretOffset);
            lineEndOffset = document.getLineEndOffset(lineNumber);
        }
        while (caretOffset < lineEndOffset && PyUtil.instanceOf(element, toSkip)) {
            element = psiFile.findElementAt(++caretOffset);
        }
        return PyUtil.instanceOf(element, toSkip) ? null : element;
    }

    public static <T extends PyElement> T addElementToStatementList(@NotNull T element, @NotNull PyStatementList statementList) {
        if (element == null) {
            PyUtil.$$$reportNull$$$0(106);
        }
        if (statementList == null) {
            PyUtil.$$$reportNull$$$0(107);
        }
        PyStatement before = null;
        PyStatement after = null;
        for (PyStatement statement : statementList.getStatements()) {
            if (PyDependenciesComparator.depends(element, statement)) {
                after = statement;
                continue;
            }
            if (!PyDependenciesComparator.depends(statement, element)) continue;
            before = statement;
        }
        PsiElement result2 = after != null ? statementList.addAfter((PsiElement)element, (PsiElement)after) : (before != null ? statementList.addBefore((PsiElement)element, (PsiElement)before) : PyUtil.addElementToStatementList(element, statementList, true));
        PyElement resultCasted = (PyElement)result2;
        return (T)resultCasted;
    }

    @NotNull
    public static PsiElement addElementToStatementList(@NotNull PsiElement element, @NotNull PyStatementList statementList, boolean toTheBeginning) {
        PsiElement firstChild;
        PsiDocumentManager manager;
        Document document;
        PsiElement prevElem;
        if (element == null) {
            PyUtil.$$$reportNull$$$0(108);
        }
        if (statementList == null) {
            PyUtil.$$$reportNull$$$0(109);
        }
        if ((prevElem = PyPsiUtils.getPrevNonWhitespaceSibling((PsiElement)statementList)) != null && PyUtil.onSameLine((PsiElement)statementList, prevElem) && (document = (manager = PsiDocumentManager.getInstance((Project)statementList.getProject())).getDocument(statementList.getContainingFile())) != null) {
            PyStatementListContainer container = (PyStatementListContainer)statementList.getParent();
            manager.doPostponedOperationsAndUnblockDocument(document);
            String indentation = "\n" + PyIndentUtil.getElementIndent((PsiElement)statementList);
            String text = statementList.getStatements().length == 0 ? indentation + "pass" : indentation;
            document.insertString(statementList.getTextRange().getStartOffset(), (CharSequence)text);
            manager.commitDocument(document);
            statementList = container.getStatementList();
        }
        if ((firstChild = statementList.getFirstChild()) == statementList.getLastChild() && firstChild instanceof PyPassStatement) {
            element = firstChild.replace(element);
        } else {
            PyStatement[] statements = statementList.getStatements();
            if (toTheBeginning && statements.length > 0) {
                PyExpression expression;
                PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)statementList, PyDocStringOwner.class);
                PyStatement anchor = statements[0];
                if (docStringOwner != null && anchor instanceof PyExpressionStatement && ((PyExpressionStatement)anchor).getExpression() == docStringOwner.getDocStringExpression()) {
                    PyStatement next = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)anchor, PyStatement.class);
                    if (next == null) {
                        PsiElement psiElement = statementList.addAfter(element, (PsiElement)anchor);
                        if (psiElement == null) {
                            PyUtil.$$$reportNull$$$0(110);
                        }
                        return psiElement;
                    }
                    anchor = next;
                }
                while (anchor instanceof PyExpressionStatement && (expression = ((PyExpressionStatement)anchor).getExpression()) instanceof PyCallExpression) {
                    PyExpression callee = ((PyCallExpression)expression).getCallee();
                    if (!PyUtil.isSuperCall((PyCallExpression)expression) && (callee == null || !"__init__".equals(callee.getName()))) break;
                    PyStatement next = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)anchor, PyStatement.class);
                    if (next == null) {
                        PsiElement psiElement = statementList.addAfter(element, (PsiElement)anchor);
                        if (psiElement == null) {
                            PyUtil.$$$reportNull$$$0(111);
                        }
                        return psiElement;
                    }
                    anchor = next;
                }
                element = statementList.addBefore(element, (PsiElement)anchor);
            } else {
                element = statementList.add(element);
            }
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PyUtil.$$$reportNull$$$0(112);
        }
        return psiElement;
    }

    public static boolean isSignatureCompatibleTo(@NotNull PyCallable callable, @NotNull PyCallable otherCallable, @NotNull TypeEvalContext context) {
        if (callable == null) {
            PyUtil.$$$reportNull$$$0(113);
        }
        if (otherCallable == null) {
            PyUtil.$$$reportNull$$$0(114);
        }
        if (context == null) {
            PyUtil.$$$reportNull$$$0(115);
        }
        List<PyCallableParameter> parameters = callable.getParameters(context);
        List<PyCallableParameter> otherParameters = otherCallable.getParameters(context);
        int optionalCount = PyUtil.optionalParametersCount(parameters);
        int otherOptionalCount = PyUtil.optionalParametersCount(otherParameters);
        int requiredCount = PyUtil.requiredParametersCount(callable, parameters);
        int otherRequiredCount = PyUtil.requiredParametersCount(otherCallable, otherParameters);
        if ((PyUtil.hasPositionalContainer(otherParameters) || PyUtil.hasKeywordContainer(otherParameters)) && otherParameters.size() == PyUtil.specialParametersCount(otherCallable, otherParameters)) {
            return true;
        }
        if (PyUtil.hasPositionalContainer(parameters) || PyUtil.hasKeywordContainer(parameters)) {
            return requiredCount <= otherRequiredCount;
        }
        return requiredCount <= otherRequiredCount && parameters.size() >= otherParameters.size() && optionalCount >= otherOptionalCount;
    }

    private static int optionalParametersCount(@NotNull List<PyCallableParameter> parameters) {
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(116);
        }
        int n = 0;
        for (PyCallableParameter parameter : parameters) {
            if (!parameter.hasDefaultValue()) continue;
            ++n;
        }
        return n;
    }

    private static int requiredParametersCount(@NotNull PyCallable callable, @NotNull List<PyCallableParameter> parameters) {
        if (callable == null) {
            PyUtil.$$$reportNull$$$0(117);
        }
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(118);
        }
        return parameters.size() - PyUtil.optionalParametersCount(parameters) - PyUtil.specialParametersCount(callable, parameters);
    }

    private static int specialParametersCount(@NotNull PyCallable callable, @NotNull List<PyCallableParameter> parameters) {
        if (callable == null) {
            PyUtil.$$$reportNull$$$0(119);
        }
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(120);
        }
        int n = 0;
        if (PyUtil.hasPositionalContainer(parameters)) {
            ++n;
        }
        if (PyUtil.hasKeywordContainer(parameters)) {
            ++n;
        }
        if (PyUtil.isFirstParameterSpecial(callable, parameters)) {
            ++n;
        }
        return n;
    }

    private static boolean hasPositionalContainer(@NotNull List<PyCallableParameter> parameters) {
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(121);
        }
        for (PyCallableParameter parameter : parameters) {
            if (!parameter.isPositionalContainer()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasKeywordContainer(@NotNull List<PyCallableParameter> parameters) {
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(122);
        }
        for (PyCallableParameter parameter : parameters) {
            if (!parameter.isKeywordContainer()) continue;
            return true;
        }
        return false;
    }

    private static boolean isFirstParameterSpecial(@NotNull PyCallable callable, @NotNull List<PyCallableParameter> parameters) {
        PyFunction method;
        if (callable == null) {
            PyUtil.$$$reportNull$$$0(123);
        }
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(124);
        }
        if ((method = callable.asMethod()) != null) {
            return "__new__".equals(method.getName()) || method.getModifier() != PyFunction.Modifier.STATICMETHOD;
        }
        PyCallableParameter first = (PyCallableParameter)ContainerUtil.getFirstItem(parameters);
        return first != null && "self".equals(first.getName());
    }

    public static boolean isInit(@NotNull PyFunction function) {
        if (function == null) {
            PyUtil.$$$reportNull$$$0(125);
        }
        return "__init__".equals(function.getName());
    }

    @NotNull
    public static Collection<PyMemberInfo<PyElement>> filterOutObject(@NotNull Collection<PyMemberInfo<PyElement>> pyMemberInfos) {
        if (pyMemberInfos == null) {
            PyUtil.$$$reportNull$$$0(126);
        }
        Collection collection = Collections2.filter(pyMemberInfos, (Predicate)new ObjectPredicate(false));
        if (collection == null) {
            PyUtil.$$$reportNull$$$0(127);
        }
        return collection;
    }

    public static boolean isStarImportableFrom(@NotNull String name, @NotNull PyFile file2) {
        List<String> dunderAll;
        if (name == null) {
            PyUtil.$$$reportNull$$$0(128);
        }
        if (file2 == null) {
            PyUtil.$$$reportNull$$$0(129);
        }
        return (dunderAll = file2.getDunderAll()) != null ? dunderAll.contains(name) : !name.startsWith("_");
    }

    public static boolean isSymbolInPackage(@NotNull PyQualifiedNameOwner symbol, @NotNull String expectedPackage, @NotNull String expectedName) {
        String qualifiedNameString;
        if (symbol == null) {
            PyUtil.$$$reportNull$$$0(130);
        }
        if (expectedPackage == null) {
            PyUtil.$$$reportNull$$$0(131);
        }
        if (expectedName == null) {
            PyUtil.$$$reportNull$$$0(132);
        }
        if ((qualifiedNameString = symbol.getQualifiedName()) == null) {
            return false;
        }
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)qualifiedNameString);
        String aPackage = qualifiedName.getFirstComponent();
        if (!expectedPackage.equals(aPackage)) {
            return false;
        }
        String symbolName = qualifiedName.getLastComponent();
        return expectedName.equals(symbolName);
    }

    public static boolean isObjectClass(@NotNull PyClass cls) {
        String name;
        if (cls == null) {
            PyUtil.$$$reportNull$$$0(133);
        }
        return "object".equals(name = cls.getQualifiedName()) || "types.InstanceType".equals(name);
    }

    public static boolean isInScratchFile(@NotNull PsiElement element) {
        if (element == null) {
            PyUtil.$$$reportNull$$$0(134);
        }
        return ScratchFileService.isInScratchRoot((VirtualFile)PsiUtilCore.getVirtualFile((PsiElement)element));
    }

    @Nullable
    public static PyType getReturnTypeOfMember(@NotNull PyType type, @NotNull String memberName, @Nullable PyExpression location, @NotNull TypeEvalContext context) {
        PyResolveContext resolveContext;
        List<? extends RatedResolveResult> resolveResults;
        if (type == null) {
            PyUtil.$$$reportNull$$$0(135);
        }
        if (memberName == null) {
            PyUtil.$$$reportNull$$$0(136);
        }
        if (context == null) {
            PyUtil.$$$reportNull$$$0(137);
        }
        if ((resolveResults = type.resolveMember(memberName, location, AccessDirection.READ, resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context))) != null) {
            ArrayList<PyType> types = new ArrayList<PyType>();
            for (RatedResolveResult ratedResolveResult : resolveResults) {
                PyType returnType = PyUtil.getReturnType(ratedResolveResult.getElement(), context);
                if (returnType == null) continue;
                types.add(returnType);
            }
            return PyUnionType.union(types);
        }
        return null;
    }

    @Nullable
    private static PyType getReturnType(@Nullable PsiElement element, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyUtil.$$$reportNull$$$0(138);
        }
        if (element instanceof PyTypedElement) {
            PyType type = context.getType((PyTypedElement)element);
            return PyUtil.getReturnType(type, context);
        }
        return null;
    }

    @Nullable
    private static PyType getReturnType(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyUtil.$$$reportNull$$$0(139);
        }
        if (type instanceof PyCallableType) {
            return ((PyCallableType)type).getReturnType(context);
        }
        if (type instanceof PyUnionType) {
            ArrayList<PyType> types = new ArrayList<PyType>();
            for (PyType pyType : ((PyUnionType)type).getMembers()) {
                PyType returnType = PyUtil.getReturnType(pyType, context);
                if (returnType == null) continue;
                types.add(returnType);
            }
            return PyUnionType.union(types);
        }
        return null;
    }

    public static boolean isEmptyFunction(@NotNull PyFunction function) {
        PyStatementList statementList;
        PyStatement[] statements;
        if (function == null) {
            PyUtil.$$$reportNull$$$0(140);
        }
        if ((statements = (statementList = function.getStatementList()).getStatements()).length == 0) {
            return true;
        }
        return statements.length == 1 ? PyUtil.isStringLiteral(statements[0]) || PyUtil.isPassOrRaiseOrEmptyReturnOrEllipsis(statements[0]) : statements.length == 2 && PyUtil.isStringLiteral(statements[0]) && PyUtil.isPassOrRaiseOrEmptyReturnOrEllipsis(statements[1]);
    }

    private static boolean isPassOrRaiseOrEmptyReturnOrEllipsis(PyStatement stmt) {
        PyExpression expression;
        if (stmt instanceof PyPassStatement || stmt instanceof PyRaiseStatement) {
            return true;
        }
        if (stmt instanceof PyReturnStatement && ((PyReturnStatement)stmt).getExpression() == null) {
            return true;
        }
        return stmt instanceof PyExpressionStatement && (expression = ((PyExpressionStatement)stmt).getExpression()) instanceof PyNoneLiteralExpression && ((PyNoneLiteralExpression)expression).isEllipsis();
    }

    public static boolean isStringLiteral(@Nullable PyStatement stmt) {
        PyExpression expr;
        return stmt instanceof PyExpressionStatement && (expr = ((PyExpressionStatement)stmt).getExpression()) instanceof PyStringLiteralExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 69: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 104: 
            case 110: 
            case 111: 
            case 112: 
            case 127: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 69: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 104: 
            case 110: 
            case 111: 
            case 112: 
            case 127: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 69: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 104: 
            case 110: 
            case 111: 
            case 112: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyUtil";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 15: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 16: 
            case 82: 
            case 84: 
            case 115: 
            case 137: 
            case 138: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: 
            case 73: 
            case 81: 
            case 125: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comprehension";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToResolve";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 47: 
            case 54: 
            case 55: 
            case 57: 
            case 66: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedClass";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 76: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 78: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionText";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 88: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dict";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 107: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementList";
                break;
            }
            case 113: 
            case 117: 
            case 119: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherCallable";
                break;
            }
            case 116: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyMemberInfos";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedPackage";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedName";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChildrenOfType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenedParensAndTuples";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenedParensAndLists";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenedParensAndStars";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableRepr";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sure";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyAccessDirection";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "computeElementNameForStringSearch";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToTheTop";
                break;
            }
            case 34: 
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveTopPriority";
                break;
            }
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "filterTopPriorityResults";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForVirtualFile";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "guessLanguageLevelWithCaching";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "guessLanguageLevel";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "asList";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterizedCachedValue";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedParameterLookup";
                break;
            }
            case 96: 
            case 97: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "dictValue";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateFile";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "addElementToStatementList";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllChildrenOfType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 69: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 104: 
            case 110: 
            case 111: 
            case 112: 
            case 127: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inSameFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onSameLine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedAncestors";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyAccessDirection";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeQualifier";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "computeElementNameForStringSearch";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isOwnScopeComprehension";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveToTheTop";
                break;
            }
            case 32: 
            case 33: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveTopPriority";
                break;
            }
            case 38: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "filterTopPriorityResults";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getMaxRate";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getRate";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getInitMethod";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevelForVirtualFile";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "invalidateLanguageLevelCache";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "guessLanguageLevelWithCaching";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "guessLanguageLevel";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "as";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "findReference";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "asList";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "rehighlightOpenEditors";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedCachedValue";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getNullableParameterizedCachedValue";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "runWithProgress";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "verboseOnly";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getCommentOnHeaderLine";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isPy2ReservedWord";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "updateDocumentUnblockedAndCommitted";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeToAnalyzeAsCallType";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionFromFragment";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getPackageElement";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isPackage";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "isSetuptoolsNamespacePackage";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getPackagePath";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isClassPrivateName";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialName";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "createNamedParameterLookup";
                break;
            }
            case 95: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "dictValue";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "among";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isSuperCall";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "findNextAtOffset";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "addElementToStatementList";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isSignatureCompatibleTo";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "optionalParametersCount";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "requiredParametersCount";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "specialParametersCount";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "hasPositionalContainer";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "hasKeywordContainer";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "isFirstParameterSpecial";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "isInit";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "filterOutObject";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "isStarImportableFrom";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "isSymbolInPackage";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "isObjectClass";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "isInScratchFile";
                break;
            }
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeOfMember";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyFunction";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateDocumentUnblockedAndCommitted$5";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "lambda$rehighlightOpenEditors$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 69: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 104: 
            case 110: 
            case 111: 
            case 112: 
            case 127: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IterHelper {
        private IterHelper() {
        }

        @Nullable
        public static PsiNamedElement findName(Iterable<PsiNamedElement> it, String name) {
            PsiNamedElement ret = null;
            for (PsiNamedElement elt : it) {
                if (elt == null || elt instanceof PyQualifiedExpression && ((PyQualifiedExpression)elt).isQualified() || !name.equals(elt.getName())) continue;
                ret = elt;
                break;
            }
            return ret;
        }
    }

    public static final class StringNodeInfo {
        private final ASTNode myNode;
        private final String myPrefix;
        private final String myQuote;
        private final TextRange myContentRange;

        public StringNodeInfo(@NotNull ASTNode node) {
            if (node == null) {
                StringNodeInfo.$$$reportNull$$$0(0);
            }
            if (!PyTokenTypes.STRING_NODES.contains(node.getElementType())) {
                throw new IllegalArgumentException("Node must be valid Python string literal token, but " + node.getElementType() + " was given");
            }
            this.myNode = node;
            String nodeText = node.getText();
            int prefixLength = PyStringLiteralExpressionImpl.getPrefixLength(nodeText);
            this.myPrefix = nodeText.substring(0, prefixLength);
            this.myContentRange = PyStringLiteralExpressionImpl.getNodeTextRange(nodeText);
            this.myQuote = nodeText.substring(prefixLength, this.myContentRange.getStartOffset());
        }

        public StringNodeInfo(@NotNull PsiElement element) {
            if (element == null) {
                StringNodeInfo.$$$reportNull$$$0(1);
            }
            this(element.getNode());
        }

        @NotNull
        public ASTNode getNode() {
            ASTNode aSTNode = this.myNode;
            if (aSTNode == null) {
                StringNodeInfo.$$$reportNull$$$0(2);
            }
            return aSTNode;
        }

        @NotNull
        public String getPrefix() {
            String string = this.myPrefix;
            if (string == null) {
                StringNodeInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getContent() {
            String string = this.myContentRange.substring(this.myNode.getText());
            if (string == null) {
                StringNodeInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public TextRange getContentRange() {
            TextRange textRange = this.myContentRange;
            if (textRange == null) {
                StringNodeInfo.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        @NotNull
        public TextRange getAbsoluteContentRange() {
            TextRange textRange = this.getContentRange().shiftRight(this.myNode.getStartOffset());
            if (textRange == null) {
                StringNodeInfo.$$$reportNull$$$0(6);
            }
            return textRange;
        }

        public char getSingleQuote() {
            return this.myQuote.charAt(0);
        }

        @NotNull
        public String getQuote() {
            String string = this.myQuote;
            if (string == null) {
                StringNodeInfo.$$$reportNull$$$0(7);
            }
            return string;
        }

        public boolean isTripleQuoted() {
            return this.myQuote.length() == 3;
        }

        public boolean isTerminated() {
            String text = this.myNode.getText();
            return text.length() - this.myPrefix.length() >= this.myQuote.length() * 2 && text.endsWith(this.myQuote);
        }

        public boolean isUnicode() {
            return PyStringLiteralUtil.isUnicodePrefix(this.myPrefix);
        }

        public boolean isRaw() {
            return PyStringLiteralUtil.isRawPrefix(this.myPrefix);
        }

        public boolean isBytes() {
            return PyStringLiteralUtil.isBytesPrefix(this.myPrefix);
        }

        public boolean isFormatted() {
            return PyStringLiteralUtil.isFormattedPrefix(this.myPrefix);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringNodeInfo info = (StringNodeInfo)o;
            return this.getQuote().equals(info.getQuote()) && this.isRaw() == info.isRaw() && this.isUnicode() == info.isUnicode() && this.isBytes() == info.isBytes();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/PyUtil$StringNodeInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/PyUtil$StringNodeInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentRange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAbsoluteContentRange";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuote";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ObjectPredicate
    extends NotNullPredicate<PyMemberInfo<PyElement>> {
        private final boolean myAllowObjects;

        public ObjectPredicate(boolean allowObjects) {
            this.myAllowObjects = allowObjects;
        }

        @Override
        public boolean applyNotNull(@NotNull PyMemberInfo<PyElement> input) {
            if (input == null) {
                ObjectPredicate.$$$reportNull$$$0(0);
            }
            return this.myAllowObjects == ObjectPredicate.isObject(input);
        }

        private static boolean isObject(@NotNull PyMemberInfo<PyElement> classMemberInfo) {
            PyElement element;
            if (classMemberInfo == null) {
                ObjectPredicate.$$$reportNull$$$0(1);
            }
            return (element = (PyElement)classMemberInfo.getMember()) instanceof PyClass && "object".equals(element.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classMemberInfo";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/PyUtil$ObjectPredicate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isObject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MethodFlags {
        private final boolean myIsStaticMethod;
        private final boolean myIsMetaclassMethod;
        private final boolean myIsSpecialMetaclassMethod;
        private final boolean myIsClassMethod;

        public boolean isMetaclassMethod() {
            return this.myIsMetaclassMethod;
        }

        public boolean isSpecialMetaclassMethod() {
            return this.myIsSpecialMetaclassMethod;
        }

        public boolean isStaticMethod() {
            return this.myIsStaticMethod;
        }

        public boolean isClassMethod() {
            return this.myIsClassMethod;
        }

        private MethodFlags(boolean isClassMethod, boolean isStaticMethod, boolean isMetaclassMethod, boolean isSpecialMetaclassMethod) {
            this.myIsClassMethod = isClassMethod;
            this.myIsStaticMethod = isStaticMethod;
            this.myIsMetaclassMethod = isMetaclassMethod;
            this.myIsSpecialMetaclassMethod = isSpecialMetaclassMethod;
        }

        @Nullable
        public static MethodFlags of(@NotNull PyFunction node) {
            PyClass cls;
            if (node == null) {
                MethodFlags.$$$reportNull$$$0(0);
            }
            if ((cls = node.getContainingClass()) != null) {
                PyFunction.Modifier modifier = node.getModifier();
                boolean isMetaclassMethod = false;
                PyClass type_cls = PyBuiltinCache.getInstance(node).getClass("type");
                for (PyClass ancestor_cls : cls.getAncestorClasses(null)) {
                    if (ancestor_cls != type_cls) continue;
                    isMetaclassMethod = true;
                    break;
                }
                String method_name = node.getName();
                boolean isSpecialMetaclassMethod = isMetaclassMethod && method_name != null && PyUtil.among(method_name, "__init__", "__call__");
                return new MethodFlags(modifier == PyFunction.Modifier.CLASSMETHOD, modifier == PyFunction.Modifier.STATICMETHOD, isMetaclassMethod, isSpecialMetaclassMethod);
            }
            return null;
        }

        public boolean isInstanceMethod() {
            return !this.myIsClassMethod && !this.myIsStaticMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/psi/PyUtil$MethodFlags", "of"));
        }
    }

    public static class KnownDecoratorProviderHolder {
        public static final PyKnownDecoratorProvider[] KNOWN_DECORATOR_PROVIDERS = (PyKnownDecoratorProvider[])Extensions.getExtensions(PyKnownDecoratorProvider.EP_NAME);

        private KnownDecoratorProviderHolder() {
        }
    }
}

