/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBuiltinCache {
    public static final String BUILTIN_FILE = "__builtin__.py";
    public static final String BUILTIN_FILE_3K = "builtins.py";
    private static final String EXCEPTIONS_FILE = "exceptions.py";
    private static final PyBuiltinCache DUD_INSTANCE = new PyBuiltinCache(null, null);
    private static final int MAX_ANALYZED_ELEMENTS_OF_LITERALS = 10;
    @NotNull
    private final Map<String, PyClassTypeImpl> myTypeCache = new HashMap<String, PyClassTypeImpl>();
    @Nullable
    private PyFile myBuiltinsFile;
    @Nullable
    private PyFile myExceptionsFile;
    private long myModStamp = -1L;

    public PyBuiltinCache() {
    }

    public PyBuiltinCache(@Nullable PyFile builtins, @Nullable PyFile exceptions) {
        this.myBuiltinsFile = builtins;
        this.myExceptionsFile = exceptions;
    }

    @NotNull
    public static PyBuiltinCache getInstance(@Nullable PsiElement reference) {
        block5: {
            if (reference != null) {
                PyBuiltinCache pyBuiltinCache;
                try {
                    Sdk sdk = PyBuiltinCache.findSdkForFile((PsiFileSystemItem)reference.getContainingFile());
                    if (sdk == null) break block5;
                    pyBuiltinCache = PythonSdkPathCache.getInstance(reference.getProject(), sdk).getBuiltins();
                }
                catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                    // empty catch block
                }
                if (pyBuiltinCache == null) {
                    PyBuiltinCache.$$$reportNull$$$0(0);
                }
                return pyBuiltinCache;
            }
        }
        PyBuiltinCache pyBuiltinCache = DUD_INSTANCE;
        if (pyBuiltinCache == null) {
            PyBuiltinCache.$$$reportNull$$$0(1);
        }
        return pyBuiltinCache;
    }

    @Nullable
    public static Sdk findSdkForFile(PsiFileSystemItem psifile) {
        if (psifile == null) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psifile);
        if (module2 != null) {
            return PythonSdkType.findPythonSdk(module2);
        }
        return PyBuiltinCache.findSdkForNonModuleFile(psifile);
    }

    @Nullable
    public static Sdk findSdkForNonModuleFile(@NotNull PsiFileSystemItem psiFile) {
        ProjectRootManager projectRootManager;
        PsiFile contextFile;
        if (psiFile == null) {
            PyBuiltinCache.$$$reportNull$$$0(2);
        }
        VirtualFile vfile = psiFile instanceof PsiFile ? ((contextFile = FileContextUtil.getContextFile((PsiElement)psiFile)) != null ? contextFile.getOriginalFile().getVirtualFile() : null) : psiFile.getVirtualFile();
        Sdk sdk = null;
        if (vfile != null && (sdk = (projectRootManager = ProjectRootManager.getInstance((Project)psiFile.getProject())).getProjectSdk()) == null) {
            List orderEntries = projectRootManager.getFileIndex().getOrderEntriesForFile(vfile);
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry instanceof JdkOrderEntry) {
                    sdk = ((JdkOrderEntry)orderEntry).getJdk();
                    continue;
                }
                if (!(orderEntry instanceof ModuleLibraryOrderEntryImpl)) continue;
                sdk = PythonSdkType.findPythonSdk(orderEntry.getOwnerModule());
            }
        }
        return sdk;
    }

    @Nullable
    public static PyFile getBuiltinsForSdk(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PyBuiltinCache.$$$reportNull$$$0(3);
        }
        if (sdk == null) {
            PyBuiltinCache.$$$reportNull$$$0(4);
        }
        return PyBuiltinCache.getSkeletonFile(project, sdk, PythonSdkType.getBuiltinsFileName(sdk));
    }

    @Nullable
    public static PyFile getExceptionsForSdk(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PyBuiltinCache.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            PyBuiltinCache.$$$reportNull$$$0(6);
        }
        return PyBuiltinCache.getSkeletonFile(project, sdk, EXCEPTIONS_FILE);
    }

    @Nullable
    private static PyFile getSkeletonFile(@NotNull Project project, @NotNull Sdk sdk, @NotNull String name) {
        SdkTypeId sdkType;
        if (project == null) {
            PyBuiltinCache.$$$reportNull$$$0(7);
        }
        if (sdk == null) {
            PyBuiltinCache.$$$reportNull$$$0(8);
        }
        if (name == null) {
            PyBuiltinCache.$$$reportNull$$$0(9);
        }
        if ((sdkType = sdk.getSdkType()) instanceof PythonSdkType) {
            int index = name.indexOf(".");
            if (index != -1) {
                name = name.substring(0, index);
            }
            List<PsiElement> results = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromComponents((String[])new String[]{name}), PyResolveImportUtil.fromSdk(project, sdk));
            return PyUtil.as(ContainerUtil.getFirstItem(results), PyFile.class);
        }
        return null;
    }

    @Nullable
    public PyType createLiteralCollectionType(PySequenceExpression sequence, String name, @NotNull TypeEvalContext context) {
        PyClass cls;
        if (context == null) {
            PyBuiltinCache.$$$reportNull$$$0(10);
        }
        if ((cls = this.getClass(name)) != null) {
            return new PyCollectionTypeImpl(cls, false, PyBuiltinCache.getSequenceElementTypes(sequence, context));
        }
        return null;
    }

    @NotNull
    private static List<PyType> getSequenceElementTypes(@NotNull PySequenceExpression sequence, @NotNull TypeEvalContext context) {
        if (sequence == null) {
            PyBuiltinCache.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PyBuiltinCache.$$$reportNull$$$0(12);
        }
        if (sequence instanceof PyListLiteralExpression || sequence instanceof PySetLiteralExpression) {
            List<PyType> list2 = Collections.singletonList(PyBuiltinCache.getListOrSetIteratedValueType(sequence.getElements(), context));
            if (list2 == null) {
                PyBuiltinCache.$$$reportNull$$$0(13);
            }
            return list2;
        }
        if (sequence instanceof PyDictLiteralExpression) {
            List<PyType> list3 = PyBuiltinCache.getDictElementTypes(sequence.getElements(), context);
            if (list3 == null) {
                PyBuiltinCache.$$$reportNull$$$0(14);
            }
            return list3;
        }
        List<Object> list4 = Collections.singletonList(null);
        if (list4 == null) {
            PyBuiltinCache.$$$reportNull$$$0(15);
        }
        return list4;
    }

    @Nullable
    private static PyType getListOrSetIteratedValueType(@NotNull PyExpression[] elements, @NotNull TypeEvalContext context) {
        if (elements == null) {
            PyBuiltinCache.$$$reportNull$$$0(16);
        }
        if (context == null) {
            PyBuiltinCache.$$$reportNull$$$0(17);
        }
        int maxAnalyzedElements = Math.min(10, elements.length);
        PyType analyzedElementsType = (PyType)StreamEx.of((Object[])elements, (int)0, (int)maxAnalyzedElements).map(context::getType).toListAndThen(PyUnionType::union);
        if (elements.length > maxAnalyzedElements) {
            return PyUnionType.createWeakType(analyzedElementsType);
        }
        return analyzedElementsType;
    }

    @NotNull
    private static List<PyType> getDictElementTypes(@NotNull PyExpression[] elements, @NotNull TypeEvalContext context) {
        if (elements == null) {
            PyBuiltinCache.$$$reportNull$$$0(18);
        }
        if (context == null) {
            PyBuiltinCache.$$$reportNull$$$0(19);
        }
        int maxAnalyzedElements = Math.min(10, elements.length);
        ArrayList<PyType> keyTypes = new ArrayList<PyType>();
        ArrayList<PyType> valueTypes = new ArrayList<PyType>();
        StreamEx.of((Object[])elements, (int)0, (int)maxAnalyzedElements).map(element -> {
            if (context == null) {
                PyBuiltinCache.$$$reportNull$$$0(23);
            }
            return PyUtil.as(context.getType((PyTypedElement)element), PyTupleType.class);
        }).forEach(tupleType -> {
            if (tupleType != null) {
                List<PyType> tupleElementTypes = tupleType.getElementTypes();
                if (tupleType.isHomogeneous()) {
                    PyType keyAndValueType = tupleType.getIteratedItemType();
                    keyTypes.add(keyAndValueType);
                    valueTypes.add(keyAndValueType);
                } else if (tupleElementTypes.size() == 2) {
                    keyTypes.add(tupleElementTypes.get(0));
                    valueTypes.add(tupleElementTypes.get(1));
                } else {
                    keyTypes.add(null);
                    valueTypes.add(null);
                }
            } else {
                keyTypes.add(null);
                valueTypes.add(null);
            }
        });
        if (elements.length > maxAnalyzedElements) {
            keyTypes.add(null);
            valueTypes.add(null);
        }
        List<PyType> list2 = Arrays.asList(PyUnionType.union(keyTypes), PyUnionType.union(valueTypes));
        if (list2 == null) {
            PyBuiltinCache.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @Nullable
    public PyFile getBuiltinsFile() {
        return this.myBuiltinsFile;
    }

    public boolean isValid() {
        return this.myBuiltinsFile != null && this.myBuiltinsFile.isValid();
    }

    @Nullable
    public PsiElement getByName(@NonNls String name) {
        PsiElement element;
        if (this.myBuiltinsFile != null && (element = this.myBuiltinsFile.getElementNamed(name)) != null) {
            return element;
        }
        if (this.myExceptionsFile != null) {
            return this.myExceptionsFile.getElementNamed(name);
        }
        return null;
    }

    @Nullable
    public PyClass getClass(@NonNls String name) {
        if (this.myBuiltinsFile != null) {
            return this.myBuiltinsFile.findTopLevelClass(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PyClassTypeImpl getObjectType(@NonNls String name) {
        PyClassTypeImpl val;
        Map<String, PyClassTypeImpl> map2 = this.myTypeCache;
        synchronized (map2) {
            if (this.myBuiltinsFile != null && this.myBuiltinsFile.getModificationStamp() != this.myModStamp) {
                this.myTypeCache.clear();
                this.myModStamp = this.myBuiltinsFile.getModificationStamp();
            }
            val = this.myTypeCache.get(name);
        }
        if (val == null) {
            PyClass cls = this.getClass(name);
            if (cls != null) {
                val = new PyClassTypeImpl(cls, false);
                val.assertValid(name);
                Map<String, PyClassTypeImpl> map3 = this.myTypeCache;
                synchronized (map3) {
                    this.myTypeCache.put(name, val);
                }
            }
        } else {
            val.assertValid(name);
        }
        return val;
    }

    @Nullable
    public PyClassType getObjectType() {
        return this.getObjectType("object");
    }

    @Nullable
    public PyClassType getListType() {
        return this.getObjectType("list");
    }

    @Nullable
    public PyClassType getDictType() {
        return this.getObjectType("dict");
    }

    @Nullable
    public PyClassType getSetType() {
        return this.getObjectType("set");
    }

    @Nullable
    public PyClassType getTupleType() {
        return this.getObjectType("tuple");
    }

    @Nullable
    public PyClassType getIntType() {
        return this.getObjectType("int");
    }

    @Nullable
    public PyClassType getFloatType() {
        return this.getObjectType("float");
    }

    @Nullable
    public PyClassType getComplexType() {
        return this.getObjectType("complex");
    }

    @Nullable
    public PyClassType getStrType() {
        return this.getObjectType("str");
    }

    @Nullable
    public PyClassType getBytesType(LanguageLevel level) {
        if (level.isPy3K()) {
            return this.getObjectType("bytes");
        }
        return this.getObjectType("str");
    }

    @Nullable
    public PyClassType getUnicodeType(LanguageLevel level) {
        if (level.isPy3K()) {
            return this.getObjectType("str");
        }
        return this.getObjectType("unicode");
    }

    @Nullable
    public PyType getStringType(LanguageLevel level) {
        if (level.isPy3K()) {
            return this.getObjectType("str");
        }
        return this.getStrOrUnicodeType();
    }

    @Nullable
    public PyType getByteStringType(@NotNull LanguageLevel level) {
        if (level == null) {
            PyBuiltinCache.$$$reportNull$$$0(21);
        }
        if (level.isPy3K()) {
            return this.getObjectType("bytes");
        }
        return this.getStrOrUnicodeType();
    }

    @Nullable
    public PyType getStrOrUnicodeType() {
        return this.getStrOrUnicodeType(false);
    }

    @Nullable
    public PyType getStrOrUnicodeType(boolean definition) {
        PyClassLikeType str = this.getObjectType("str");
        PyClassLikeType unicode = this.getObjectType("unicode");
        if (str != null && str.isDefinition() ^ definition) {
            PyClassLikeType pyClassLikeType = str = definition ? (PyClassLikeType)str.toClass() : (PyClassLikeType)str.toInstance();
        }
        if (unicode != null && unicode.isDefinition() ^ definition) {
            unicode = definition ? (PyClassLikeType)unicode.toClass() : (PyClassLikeType)unicode.toInstance();
        }
        return PyUnionType.union(str, unicode);
    }

    @Nullable
    public PyClassType getBoolType() {
        return this.getObjectType("bool");
    }

    @Nullable
    public PyClassType getClassMethodType() {
        return this.getObjectType("classmethod");
    }

    @Nullable
    public PyClassType getStaticMethodType() {
        return this.getObjectType("staticmethod");
    }

    @Nullable
    public PyClassType getTypeType() {
        return this.getObjectType("type");
    }

    public boolean isBuiltin(@Nullable PsiElement target2) {
        if (target2 == null) {
            return false;
        }
        PyPsiUtils.assertValid(target2);
        if (!target2.isValid()) {
            return false;
        }
        PsiFile the_file = target2.getContainingFile();
        if (!(the_file instanceof PyFile)) {
            return false;
        }
        return the_file == this.myBuiltinsFile || the_file == this.myExceptionsFile;
    }

    public static boolean isInBuiltins(@NotNull PyExpression expression) {
        PsiElement resolved;
        PyBuiltinCache cache;
        if (expression == null) {
            PyBuiltinCache.$$$reportNull$$$0(22);
        }
        if (expression instanceof PyQualifiedExpression && ((PyQualifiedExpression)expression).isQualified()) {
            return false;
        }
        String name = expression.getName();
        PsiReference reference = expression.getReference();
        return reference != null && name != null && (cache = PyBuiltinCache.getInstance((PsiElement)expression)).getByName(name) != null && (resolved = reference.resolve()) != null && cache.isBuiltin(resolved);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyBuiltinCache";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyBuiltinCache";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSequenceElementTypes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDictElementTypes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSdkForNonModuleFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinsForSdk";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionsForSdk";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSkeletonFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralCollectionType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSequenceElementTypes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getListOrSetIteratedValueType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDictElementTypes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getByteStringType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInBuiltins";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDictElementTypes$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

