/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import java.math.BigInteger;
import org.jetbrains.annotations.Nullable;

public class PyConstantExpressionEvaluator {
    private PyConstantExpressionEvaluator() {
    }

    @Nullable
    public static Object evaluate(PyExpression expr) {
        BigInteger value;
        PyNumericLiteralExpression numericLiteral;
        if (expr instanceof PyNumericLiteralExpression && (numericLiteral = (PyNumericLiteralExpression)expr).isIntegerLiteral() && (long)(value = numericLiteral.getBigIntegerValue()).intValue() == value.longValue()) {
            return value.intValue();
        }
        if (expr instanceof PyBoolLiteralExpression) {
            return ((PyBoolLiteralExpression)expr).getValue();
        }
        if (expr instanceof PyReferenceExpression) {
            String text = expr.getText();
            if ("true".equals(text) || "True".equals(text)) {
                return true;
            }
            if ("false".equals(text) || "False".equals(text)) {
                return false;
            }
        }
        return null;
    }

    public static boolean evaluateBoolean(PyExpression expr, boolean defaultValue) {
        Object result2 = PyConstantExpressionEvaluator.evaluate(expr);
        if (result2 instanceof Boolean) {
            return (Boolean)result2;
        }
        if (result2 instanceof Integer) {
            return (Integer)result2 != 0;
        }
        return defaultValue;
    }

    public static boolean evaluateBoolean(PyExpression expr) {
        return PyConstantExpressionEvaluator.evaluateBoolean(expr, true);
    }
}

