/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorProvider;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyDynamicallyEvaluatedType;
import com.jetbrains.python.psi.types.PyFunctionTypeImpl;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import icons.PythonIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFunctionImpl
extends PyBaseElementImpl<PyFunctionStub>
implements PyFunction {
    private static final Key<CachedValue<List<PyAssignmentStatement>>> ATTRIBUTES_KEY = Key.create((String)"attributes");
    @NotNull
    private final CachedStructuredDocStringProvider myCachedStructuredDocStringProvider = new CachedStructuredDocStringProvider();
    @Nullable
    private volatile Boolean myIsGenerator;

    public PyFunctionImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyFunctionImpl(PyFunctionStub stub) {
        this(stub, (IStubElementType)PyElementTypes.FUNCTION_DECLARATION);
    }

    public PyFunctionImpl(PyFunctionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    @Nullable
    public String getName() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.getNameNode();
        return node != null ? node.getText() : null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode nameNode = this.getNameNode();
        return nameNode != null ? nameNode.getPsi() : null;
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PyFunctionImpl.$$$reportNull$$$0(0);
        }
        ASTNode nameElement = PyUtil.createNewName(this, name);
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            this.getNode().replaceChild(nameNode, nameElement);
        }
        PyFunctionImpl pyFunctionImpl = this;
        if (pyFunctionImpl == null) {
            PyFunctionImpl.$$$reportNull$$$0(1);
        }
        return pyFunctionImpl;
    }

    public Icon getIcon(int flags) {
        PyPsiUtils.assertValid(this);
        Property property = this.getProperty();
        if (property != null) {
            if (property.getGetter().valueOrNull() == this) {
                return PythonIcons.Python.PropertyGetter;
            }
            if (property.getSetter().valueOrNull() == this) {
                return PythonIcons.Python.PropertySetter;
            }
            if (property.getDeleter().valueOrNull() == this) {
                return PythonIcons.Python.PropertyDeleter;
            }
            return PlatformIcons.PROPERTY_ICON;
        }
        if (this.getContainingClass() != null) {
            return PlatformIcons.METHOD_ICON;
        }
        return PythonIcons.Python.Function;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        ASTNode error;
        ASTNode id = this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
        if (id == null && (error = this.getNode().findChildByType(TokenType.ERROR_ELEMENT)) != null) {
            id = error.findChildByType(PythonDialectsTokenSetProvider.INSTANCE.getKeywordTokens());
        }
        return id;
    }

    @Override
    @NotNull
    public PyParameterList getParameterList() {
        PyParameterList pyParameterList = this.getRequiredStubOrPsiChild(PyElementTypes.PARAMETER_LIST);
        if (pyParameterList == null) {
            PyFunctionImpl.$$$reportNull$$$0(2);
        }
        return pyParameterList;
    }

    @Override
    @NotNull
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(3);
        }
        List list2 = Optional.ofNullable(context.getType(this)).filter(PyCallableType.class::isInstance).map(PyCallableType.class::cast).map(callableType -> {
            if (context == null) {
                PyFunctionImpl.$$$reportNull$$$0(32);
            }
            return callableType.getParameters(context);
        }).orElseGet(() -> ContainerUtil.map((Object[])this.getParameterList().getParameters(), PyCallableParameterImpl::psi));
        if (list2 == null) {
            PyFunctionImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @NotNull
    public PyStatementList getStatementList() {
        PyStatementList statementList = (PyStatementList)this.childToPsi(PyElementTypes.STATEMENT_LIST);
        assert (statementList != null) : "Statement list missing for function " + this.getText();
        PyStatementList pyStatementList = statementList;
        if (pyStatementList == null) {
            PyFunctionImpl.$$$reportNull$$$0(5);
        }
        return pyStatementList;
    }

    @Override
    @Nullable
    public PyClass getContainingClass() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            StubElement parentStub = stub.getParentStub();
            if (parentStub instanceof PyClassStub) {
                return (PyClass)((PyClassStub)parentStub).getPsi();
            }
            return null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)this, StubBasedPsiElement.class);
        if (parent instanceof PyClass) {
            return (PyClass)parent;
        }
        return null;
    }

    @Override
    @Nullable
    public PyDecoratorList getDecoratorList() {
        return this.getStubOrPsiChild(PyElementTypes.DECORATOR_LIST);
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(6);
        }
        if (key == null) {
            PyFunctionImpl.$$$reportNull$$$0(7);
        }
        for (PyTypeProvider typeProvider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
            Ref<PyType> returnTypeRef = typeProvider.getReturnType(this, context);
            if (returnTypeRef == null) continue;
            return PyFunctionImpl.derefType(returnTypeRef, typeProvider);
        }
        PyType inferredType = null;
        if (context.allowReturnTypes(this)) {
            Ref<? extends PyType> yieldTypeRef = this.getYieldStatementType(context);
            inferredType = yieldTypeRef != null ? (PyType)yieldTypeRef.get() : this.getReturnStatementType(context);
        }
        return PyTypingTypeProvider.toAsyncIfNeeded(this, inferredType);
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(8);
        }
        if (callSite == null) {
            PyFunctionImpl.$$$reportNull$$$0(9);
        }
        for (PyTypeProvider typeProvider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
            Ref<PyType> typeRef = typeProvider.getCallType(this, callSite, context);
            if (typeRef == null) continue;
            return PyFunctionImpl.derefType(typeRef, typeProvider);
        }
        PyExpression receiver = callSite.getReceiver(this);
        PyCallExpression.PyArgumentsMapping fullMapping = PyCallExpressionHelper.mapArguments(callSite, this, context);
        Map<PyExpression, PyCallableParameter> mappedExplicitParameters = fullMapping.getMappedParameters();
        LinkedHashMap<PyExpression, PyCallableParameter> allMappedParameters = new LinkedHashMap<PyExpression, PyCallableParameter>();
        PyCallableParameter firstImplicit = (PyCallableParameter)ContainerUtil.getFirstItem(fullMapping.getImplicitParameters());
        if (receiver != null && firstImplicit != null) {
            allMappedParameters.put(receiver, firstImplicit);
        }
        allMappedParameters.putAll(mappedExplicitParameters);
        return this.getCallType(receiver, allMappedParameters, context);
    }

    @Nullable
    private static PyType derefType(@NotNull Ref<PyType> typeRef, @NotNull PyTypeProvider typeProvider) {
        PyType type;
        if (typeRef == null) {
            PyFunctionImpl.$$$reportNull$$$0(10);
        }
        if (typeProvider == null) {
            PyFunctionImpl.$$$reportNull$$$0(11);
        }
        if ((type = (PyType)typeRef.get()) != null) {
            type.assertValid(typeProvider.toString());
        }
        return type;
    }

    @Override
    @Nullable
    public PyType getCallType(@Nullable PyExpression receiver, @NotNull Map<PyExpression, PyCallableParameter> parameters, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            PyFunctionImpl.$$$reportNull$$$0(12);
        }
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(13);
        }
        return this.analyzeCallType(PyUtil.getReturnTypeToAnalyzeAsCallType(this, context), receiver, parameters, context);
    }

    @Nullable
    private PyType analyzeCallType(@Nullable PyType type, @Nullable PyExpression receiver, @NotNull Map<PyExpression, PyCallableParameter> parameters, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            PyFunctionImpl.$$$reportNull$$$0(14);
        }
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(15);
        }
        if (PyTypeChecker.hasGenerics(type, context)) {
            Map<PyGenericType, PyType> substitutions = PyTypeChecker.unifyGenericCall(receiver, parameters, context);
            type = substitutions != null ? PyTypeChecker.substitute(type, substitutions, context) : null;
        }
        if (receiver != null) {
            type = this.replaceSelf(type, receiver, context);
        }
        if (type != null && PyFunctionImpl.isDynamicallyEvaluated(parameters.values(), context)) {
            type = PyUnionType.createWeakType(type);
        }
        return type;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this){

            @Override
            @NotNull
            public String getPresentableText() {
                String string = StringUtil.notNullize((String)PyFunctionImpl.this.getName(), (String)"<unnamed>") + PyFunctionImpl.this.getParameterList().getPresentableText(true);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @Nullable
            public String getLocationString() {
                PyClass containingClass = PyFunctionImpl.this.getContainingClass();
                if (containingClass != null) {
                    return "(" + containingClass.getName() + " in " + 1.getPackageForFile(PyFunctionImpl.this.getContainingFile()) + ")";
                }
                return super.getLocationString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionImpl$1", "getPresentableText"));
            }
        };
    }

    @Nullable
    private PyType replaceSelf(@Nullable PyType returnType, @Nullable PyExpression receiver, @NotNull TypeEvalContext context) {
        PyClassType receiverClassType;
        PyType receiverType;
        PyClassType returnClassType;
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(16);
        }
        if (receiver != null && returnType instanceof PyClassType && (returnClassType = (PyClassType)returnType).getPyClass() == this.getContainingClass() && (receiverType = context.getType(receiver)) instanceof PyClassType && (receiverClassType = (PyClassType)receiverType).getPyClass() != returnClassType.getPyClass() && PyTypeChecker.match(returnType, receiverType, context)) {
            return returnClassType.isDefinition() ? receiverType : receiverClassType.toInstance();
        }
        return returnType;
    }

    private static boolean isDynamicallyEvaluated(@NotNull Collection<PyCallableParameter> parameters, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            PyFunctionImpl.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(18);
        }
        for (PyCallableParameter parameter : parameters) {
            PyType type = parameter.getType(context);
            if (!(type instanceof PyDynamicallyEvaluatedType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Ref<? extends PyType> getYieldStatementType(final @NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(19);
        }
        Ref elementType = null;
        final PyBuiltinCache cache = PyBuiltinCache.getInstance(this);
        PyStatementList statements = this.getStatementList();
        final LinkedHashSet<PyType> types = new LinkedHashSet<PyType>();
        statements.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyYieldExpression(PyYieldExpression node) {
                PyType type;
                PyExpression expr = node.getExpression();
                PyType pyType = type = expr != null ? context.getType(expr) : null;
                if (node.isDelegating()) {
                    if (type instanceof PyCollectionType) {
                        types.add(((PyCollectionType)type).getIteratedItemType());
                    } else if (ArrayUtil.contains((Object)type, (Object[])new PyType[]{cache.getListType(), cache.getDictType(), cache.getSetType(), cache.getTupleType()})) {
                        types.add(null);
                    } else {
                        types.add(type);
                    }
                } else {
                    types.add(type);
                }
            }

            @Override
            public void visitPyFunction(PyFunction node) {
            }
        });
        int n = types.size();
        if (n == 1) {
            elementType = Ref.create(types.iterator().next());
        } else if (n > 0) {
            elementType = Ref.create((Object)PyUnionType.union(types));
        }
        if (elementType != null) {
            return Ref.create((Object)PyTypingTypeProvider.wrapInGeneratorType((PyType)elementType.get(), this.getReturnStatementType(context), this));
        }
        if (!types.isEmpty()) {
            return Ref.create(null);
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getReturnStatementType(TypeEvalContext typeEvalContext) {
        ReturnVisitor visitor2 = new ReturnVisitor(this, typeEvalContext);
        PyStatementList statements = this.getStatementList();
        statements.accept(visitor2);
        if (this.isGeneratedStub() && !visitor2.myHasReturns) {
            if ("__init__".equals(this.getName())) {
                return PyNoneType.INSTANCE;
            }
            return null;
        }
        return visitor2.result();
    }

    @Override
    @Nullable
    public PyFunction asMethod() {
        if (this.getContainingClass() != null) {
            return this;
        }
        return null;
    }

    @Override
    @Nullable
    public String getDeprecationMessage() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.getDeprecationMessage();
        }
        return this.extractDeprecationMessage();
    }

    @Nullable
    public String extractDeprecationMessage() {
        PyStatementList statementList = this.getStatementList();
        return PyFunctionImpl.extractDeprecationMessage(Arrays.asList(statementList.getStatements()));
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(20);
        }
        if (key == null) {
            PyFunctionImpl.$$$reportNull$$$0(21);
        }
        for (PyTypeProvider provider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
            PyType type = provider.getCallableType(this, context);
            if (type == null) continue;
            return type;
        }
        return new PyFunctionTypeImpl(this);
    }

    @Nullable
    public static String extractDeprecationMessage(List<PyStatement> statements) {
        for (PyStatement statement : statements) {
            PyReferenceExpression warningClass;
            PyCallExpression callExpression;
            PyExpressionStatement expressionStatement;
            if (!(statement instanceof PyExpressionStatement) || !((expressionStatement = (PyExpressionStatement)statement).getExpression() instanceof PyCallExpression) || !(callExpression = (PyCallExpression)expressionStatement.getExpression()).isCalleeText("warn") || (warningClass = callExpression.getArgument(1, PyReferenceExpression.class)) == null || !"DeprecationWarning".equals(warningClass.getReferencedName()) && !"PendingDeprecationWarning".equals(warningClass.getReferencedName())) continue;
            return PyPsiUtils.strValue(callExpression.getArguments()[0]);
        }
        return null;
    }

    @Override
    public String getDocStringValue() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.getDocString();
        }
        return DocStringUtil.getDocStringValue(this);
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return (StructuredDocString)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)this.myCachedStructuredDocStringProvider);
    }

    private boolean isGeneratedStub() {
        VirtualFile vFile = this.getContainingFile().getVirtualFile();
        return vFile != null && (vFile = vFile.getParent()) != null && (vFile = vFile.getParent()) != null && vFile.getName().equals("python_stubs");
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyFunction(this);
    }

    @Override
    public int getTextOffset() {
        ASTNode name = this.getNameNode();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    @Override
    @Nullable
    public PyStringLiteralExpression getDocStringExpression() {
        PyStatementList stmtList = this.getStatementList();
        return DocStringUtil.findDocStringExpression(stmtList);
    }

    @Override
    public String toString() {
        return super.toString() + "('" + this.getName() + "')";
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        ControlFlowCache.clear(this);
        this.myIsGenerator = null;
    }

    @Override
    @Nullable
    public Property getProperty() {
        PyClass containingClass = this.getContainingClass();
        if (containingClass != null) {
            return containingClass.findPropertyByCallable(this);
        }
        return null;
    }

    @Override
    public PyAnnotation getAnnotation() {
        return this.getStubOrPsiChild(PyElementTypes.ANNOTATION);
    }

    @Override
    @Nullable
    public String getAnnotationValue() {
        return PyFunctionImpl.getAnnotationContentFromStubOrPsi(this);
    }

    @Override
    @Nullable
    public PsiComment getTypeComment() {
        PsiComment comment;
        PsiComment inlineComment = PyUtil.getCommentOnHeaderLine(this);
        if (inlineComment != null && PyTypingTypeProvider.getTypeCommentValue(inlineComment.getText()) != null) {
            return inlineComment;
        }
        PyStatementList statements = this.getStatementList();
        if (statements.getStatements().length != 0 && (comment = PyUtil.as(statements.getFirstChild(), PsiComment.class)) != null && PyTypingTypeProvider.getTypeCommentValue(comment.getText()) != null) {
            return comment;
        }
        return null;
    }

    @Override
    @Nullable
    public String getTypeCommentAnnotation() {
        return PyFunctionImpl.getTypeCommentAnnotationFromStubOrPsi(this);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(this);
        if (scopeOwner instanceof PyFunction) {
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)scopeOwner);
            if (localSearchScope == null) {
                PyFunctionImpl.$$$reportNull$$$0(22);
            }
            return localSearchScope;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            PyFunctionImpl.$$$reportNull$$$0(23);
        }
        return searchScope;
    }

    @Override
    @Nullable
    public PyFunction.Modifier getModifier() {
        String deconame = this.getClassOrStaticMethodDecorator();
        if ("classmethod".equals(deconame)) {
            return PyFunction.Modifier.CLASSMETHOD;
        }
        if ("staticmethod".equals(deconame)) {
            return PyFunction.Modifier.STATICMETHOD;
        }
        String funcName = this.getName();
        PyClass cls = this.getContainingClass();
        if (cls != null && "__new__".equals(funcName) && cls.isNewStyleClass(null)) {
            return PyFunction.Modifier.STATICMETHOD;
        }
        if (cls != null && "__init_subclass__".equals(funcName) && LanguageLevel.forElement(this).isAtLeast(LanguageLevel.PYTHON36)) {
            return PyFunction.Modifier.CLASSMETHOD;
        }
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return PyFunctionImpl.getModifierFromStub(stub);
        }
        if (funcName != null) {
            PyAssignmentStatement currentAssignment = (PyAssignmentStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)this, PyAssignmentStatement.class);
            while (currentAssignment != null) {
                String modifier = currentAssignment.getTargetsToValuesMapping().stream().filter(pair -> pair.getFirst() instanceof PyTargetExpression && funcName.equals(((PyExpression)pair.getFirst()).getName())).filter(pair -> pair.getSecond() instanceof PyCallExpression).map(pair -> PyCallExpressionHelper.interpretAsModifierWrappingCall((PyCallExpression)pair.getSecond())).filter(interpreted -> interpreted != null && interpreted.getSecond() == this).map(interpreted -> (String)interpreted.getFirst()).filter(wrapperName -> "classmethod".equals(wrapperName) || "staticmethod".equals(wrapperName)).findAny().orElse(null);
                if ("classmethod".equals(modifier)) {
                    return PyFunction.Modifier.CLASSMETHOD;
                }
                if ("staticmethod".equals(modifier)) {
                    return PyFunction.Modifier.STATICMETHOD;
                }
                currentAssignment = (PyAssignmentStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)currentAssignment, PyAssignmentStatement.class);
            }
        }
        return null;
    }

    @Override
    public boolean isGenerator() {
        Boolean result2 = this.myIsGenerator;
        if (result2 == null) {
            final Ref containsYield = Ref.create((Object)false);
            this.getStatementList().accept(new PyRecursiveElementVisitor(){

                @Override
                public void visitPyYieldExpression(PyYieldExpression node) {
                    containsYield.set((Object)true);
                }

                @Override
                public void visitPyFunction(PyFunction node) {
                }

                @Override
                public void visitElement(PsiElement element) {
                    if (!((Boolean)containsYield.get()).booleanValue()) {
                        super.visitElement(element);
                    }
                }
            });
            this.myIsGenerator = result2 = (Boolean)containsYield.get();
        }
        return result2;
    }

    @Override
    public boolean isAsync() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.isAsync();
        }
        return this.getNode().findChildByType((IElementType)PyTokenTypes.ASYNC_KEYWORD) != null;
    }

    @Override
    public boolean isAsyncAllowed() {
        LanguageLevel languageLevel = LanguageLevel.forElement(this);
        String functionName = this.getName();
        return languageLevel.isAtLeast(LanguageLevel.PYTHON35) && (functionName == null || ArrayUtil.contains((String)functionName, (String[])new String[]{"__aiter__", "__anext__", "__aenter__", "__aexit__", "__call__"}) || !PyNames.getBuiltinMethods(languageLevel).containsKey((Object)functionName));
    }

    @Override
    public boolean onlyRaisesNotImplementedError() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.onlyRaisesNotImplementedError();
        }
        PyStatement[] statements = this.getStatementList().getStatements();
        return statements.length == 1 && PyFunctionImpl.isRaiseNotImplementedError(statements[0]) || statements.length == 2 && PyUtil.isStringLiteral(statements[0]) && PyFunctionImpl.isRaiseNotImplementedError(statements[1]);
    }

    private static boolean isRaiseNotImplementedError(@NotNull PyStatement statement) {
        PyExpression callee;
        PyExpression raisedExpression;
        if (statement == null) {
            PyFunctionImpl.$$$reportNull$$$0(24);
        }
        return (raisedExpression = (PyExpression)Optional.ofNullable(PyUtil.as(statement, PyRaiseStatement.class)).map(PyRaiseStatement::getExpressions).filter(expressions -> ((PyExpression[])expressions).length == 1).map(expressions -> expressions[0]).orElse(null)) instanceof PyCallExpression ? (callee = ((PyCallExpression)raisedExpression).getCallee()) != null && callee.getText().equals("NotImplementedError") : raisedExpression != null && raisedExpression.getText().equals("NotImplementedError");
    }

    @Nullable
    private static PyFunction.Modifier getModifierFromStub(@NotNull PyFunctionStub stub) {
        if (stub == null) {
            PyFunctionImpl.$$$reportNull$$$0(25);
        }
        return (PyFunction.Modifier)((Object)JBIterable.of((Object)stub.getParentStub()).flatMap(element -> element.getChildrenStubs()).skipWhile(siblingStub -> {
            if (stub == null) {
                PyFunctionImpl.$$$reportNull$$$0(31);
            }
            return !stub.equals(siblingStub);
        }).transform(nextSiblingStub -> PyUtil.as(nextSiblingStub, PyTargetExpressionStub.class)).filter(Objects::nonNull).filter(nextSiblingStub -> nextSiblingStub.getInitializerType() == PyTargetExpressionStub.InitializerType.CallExpression).transform(PyTargetExpressionStub::getInitializer).transform(initializerName -> {
            if (initializerName == null) {
                return null;
            }
            if (initializerName.matches(new String[]{"classmethod"})) {
                return PyFunction.Modifier.CLASSMETHOD;
            }
            if (initializerName.matches(new String[]{"staticmethod"})) {
                return PyFunction.Modifier.STATICMETHOD;
            }
            return null;
        }).find(Objects::nonNull));
    }

    @Nullable
    private String getClassOrStaticMethodDecorator() {
        PyDecorator[] decos;
        PyDecoratorList decolist = this.getDecoratorList();
        if (decolist != null && (decos = decolist.getDecorators()).length > 0) {
            for (int i = decos.length - 1; i >= 0; --i) {
                PyDecorator deco = decos[i];
                String deconame = deco.getName();
                if ("classmethod".equals(deconame) || "staticmethod".equals(deconame)) {
                    return deconame;
                }
                for (PyKnownDecoratorProvider provider : PyUtil.KnownDecoratorProviderHolder.KNOWN_DECORATOR_PROVIDERS) {
                    String name = provider.toKnownDecorator(deconame);
                    if (name == null) continue;
                    return name;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return QualifiedNameFinder.getQualifiedName(this);
    }

    @Override
    @NotNull
    public List<PyAssignmentStatement> findAttributes() {
        List list2 = (List)CachedValuesManager.getManager((Project)this.getProject()).getCachedValue((UserDataHolder)this, ATTRIBUTES_KEY, () -> {
            List<PyAssignmentStatement> result2 = PyFunctionImpl.findAttributesStatic(this);
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
        if (list2 == null) {
            PyFunctionImpl.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @NotNull
    private static List<PyAssignmentStatement> findAttributesStatic(@NotNull PsiElement self) {
        if (self == null) {
            PyFunctionImpl.$$$reportNull$$$0(27);
        }
        ArrayList<PyAssignmentStatement> result2 = new ArrayList<PyAssignmentStatement>();
        for (PyAssignmentStatement statement : new PsiQuery<PsiElement>(self).siblings(PyAssignmentStatement.class).getElements()) {
            for (PyQualifiedExpression targetExpression : new PsiQuery<PyExpression[]>(statement.getTargets()).filter(new PsiQuery.PsiFilter<PyQualifiedExpression>(PyQualifiedExpression.class)).getElements()) {
                PsiReference qualifierReference;
                PyExpression qualifier = targetExpression.getQualifier();
                if (qualifier == null || (qualifierReference = qualifier.getReference()) == null || !qualifierReference.isReferenceTo(self)) continue;
                result2.add(statement);
            }
        }
        ArrayList<PyAssignmentStatement> arrayList = result2;
        if (arrayList == null) {
            PyFunctionImpl.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public PyFunction.ProtectionLevel getProtectionLevel() {
        int underscoreLevels = PyUtil.getInitialUnderscores(this.getName());
        for (PyFunction.ProtectionLevel level : PyFunction.ProtectionLevel.values()) {
            if (level.getUnderscoreLevel() != underscoreLevels) continue;
            PyFunction.ProtectionLevel protectionLevel = level;
            if (protectionLevel == null) {
                PyFunctionImpl.$$$reportNull$$$0(29);
            }
            return protectionLevel;
        }
        PyFunction.ProtectionLevel protectionLevel = PyFunction.ProtectionLevel.PRIVATE;
        if (protectionLevel == null) {
            PyFunctionImpl.$$$reportNull$$$0(30);
        }
        return protectionLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyFunctionImpl";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRef";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProvider";
                break;
            }
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyFunctionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementList";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttributes";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttributesStatic";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtectionLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "derefType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "analyzeCallType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceSelf";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicallyEvaluated";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getYieldStatementType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isRaiseNotImplementedError";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getModifierFromStub";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findAttributesStatic";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getModifierFromStub$11";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getParameters$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReturnVisitor
    extends PyRecursiveElementVisitor {
        private final PyFunction myFunction;
        private final TypeEvalContext myContext;
        private PyType myResult = null;
        private boolean myHasReturns = false;
        private boolean myHasRaises = false;

        public ReturnVisitor(PyFunction function, TypeEvalContext context) {
            this.myFunction = function;
            this.myContext = context;
        }

        @Override
        public void visitPyReturnStatement(PyReturnStatement node) {
            if (ScopeUtil.getScopeOwner((PsiElement)node) == this.myFunction) {
                PyNoneType returnType;
                PyExpression expr = node.getExpression();
                PyType pyType = returnType = expr == null ? PyNoneType.INSTANCE : this.myContext.getType(expr);
                if (!this.myHasReturns) {
                    this.myResult = returnType;
                    this.myHasReturns = true;
                } else {
                    this.myResult = PyUnionType.union(this.myResult, returnType);
                }
            }
        }

        @Override
        public void visitPyRaiseStatement(PyRaiseStatement node) {
            this.myHasRaises = true;
        }

        @Nullable
        PyType result() {
            return this.myHasReturns || this.myHasRaises ? this.myResult : PyNoneType.INSTANCE;
        }
    }

    private class CachedStructuredDocStringProvider
    implements CachedValueProvider<StructuredDocString> {
        private CachedStructuredDocStringProvider() {
        }

        @Nullable
        public CachedValueProvider.Result<StructuredDocString> compute() {
            PyFunctionImpl f = PyFunctionImpl.this;
            return CachedValueProvider.Result.create((Object)DocStringUtil.getStructuredDocString(f), (Object[])new Object[]{f});
        }
    }
}

